/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.mail.AutoMailer;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.mail.api.PGPPublicKeyFoundListener;
import jakarta.mail.Address;
import jakarta.mail.internet.InternetAddress;
import java.util.Hashtable;
import srv.mail.AutoMail;
import srv.mail.Mail;

public class AutoMailerFactoryImpl
implements PGPPublicKeyFoundListener {
    private static final ConfigValue<String> MAIL_FORMAT = new ConfigValue(HDConfigKeys.MAIL_FORMAT);
    private static final String MAIL_TEMPLATE_NAME = "pgpkeyreceived";

    public AutoMailer create() {
        return new AutoMailerImpl();
    }

    public void foundPublicKey(Address[] recipients, String sender) {
        AutoMailer autoMailer = this.create();
        autoMailer.setSenderByAnyHelpDeskAddressOf(recipients).setTo(sender).setTemplate(MAIL_TEMPLATE_NAME).send();
    }

    public static class AutoMailerImpl
    implements AutoMailer {
        private Hashtable<String, String> table = new Hashtable();

        @Override
        public AutoMailer setSenderByAnyHelpDeskAddressOf(Address[] senders) {
            for (Address s : senders) {
                for (EmailAccount emailAccount : (EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get()) {
                    if (!(s instanceof InternetAddress) || !((InternetAddress)s).getAddress().equals(emailAccount.getFrom())) continue;
                    this.table.put("e-mail absender", emailAccount.getFrom());
                    this.table.put("name absender", emailAccount.getFromName());
                    return this;
                }
            }
            String defaultSender = (String)AutoMail.MAIL_FROM.get();
            this.table.put("e-mail absender", defaultSender);
            this.table.put("name absender", "HelpDesk");
            return this;
        }

        @Override
        public AutoMailer setTo(String to) {
            this.table.put("e-mail empfaenger", to);
            return this;
        }

        @Override
        public AutoMailer setTemplate(String template) {
            this.table.put("templatename", template + ("html".equals(MAIL_FORMAT.get()) ? ".html" : ".txt"));
            return this;
        }

        @Override
        public void send() {
            Mail.send(this.table, 666, null);
        }
    }
}

