/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.IModelWriter;
import com.inet.dbupdater.model.ModelWriterString;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public abstract class Node
implements Cloneable {
    private static final Logger logger = LogManager.getLogger((String)"DB Updater");
    public static final int STATE_NEW = 0;
    public static final int STATE_CHANGED = 1;
    public static final int STATE_REMOVED = 2;
    public static final int COMPARE_ALWAYS = 0;
    public static final int COMPARE_ATTACH = 1;
    public static final int COMPARE_IGNORE = 2;
    public static final int COMPARE_INCLUDE = 3;
    private static final Comparator<NodeFactory.TAG> TAG_COMPARATOR = new TagComparator();
    private static final Comparator<String> STRING_COMPARATOR = new StringCIComparator();
    private Node parent;
    private NodeFactory.TAG name;
    private HashMap<NodeFactory.TAG, List<Node>> childList = new HashMap();
    private AttributeMap<String> attributes;
    private Node diffSource = null;
    private Node diffTarget = null;
    private int state = 0;

    protected Node() {
        this.init();
    }

    private void init() {
        NodeFactory.TAG[] allowed = this.getAllowedChildren();
        if (allowed != null) {
            for (NodeFactory.TAG tag : allowed) {
                this.childList.put(tag, new ArrayList());
            }
        }
    }

    protected void setName(NodeFactory.TAG name) {
        this.name = name;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public void readParameter(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new AttributeMap();
        }
        this.attributes.put(name, value);
    }

    public void dropParameter(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void readString(String string) {
    }

    public void addChild(Node child) {
        if (!this.childList.keySet().contains((Object)child.getName())) {
            throw new IllegalArgumentException("An element of type '" + String.valueOf((Object)this.name) + "' cannot contain directly an element of type '" + String.valueOf((Object)child.getName()) + "'");
        }
        child.setParent(this);
        List<Node> list = this.childList.get((Object)child.getName());
        list.add(child);
    }

    public void removeChild(Node child) {
        if (child == null || !this.childList.keySet().contains((Object)child.getName())) {
            return;
        }
        List<Node> list = this.childList.get((Object)child.getName());
        list.remove(child);
    }

    public void replaceChild(Node child, Node newChild) {
        if (child == null || !this.childList.keySet().contains((Object)child.getName())) {
            return;
        }
        List<Node> list = this.childList.get((Object)child.getName());
        int index = list.indexOf(child);
        if (index >= 0) {
            list.set(index, newChild);
        } else {
            list.add(newChild);
        }
    }

    public abstract NodeFactory.TAG[] getAllowedChildren();

    public NodeFactory.TAG getName() {
        return this.name;
    }

    public Node getParent() {
        return this.parent;
    }

    public List<? extends Node> getChildren(NodeFactory.TAG type) {
        return this.childList.get((Object)type);
    }

    public List<? extends Node> getAllChildren() {
        if (this.childList.size() == 0) {
            return new ArrayList();
        }
        if (this.childList.size() == 1) {
            return this.childList.values().iterator().next();
        }
        ArrayList<Node> list = new ArrayList<Node>();
        for (List<Node> children : this.childList.values()) {
            list.addAll(children);
        }
        return list;
    }

    public String getContent() {
        return null;
    }

    public boolean isDefined(String parameterName) {
        if (this.attributes != null) {
            return this.attributes.containsKey(parameterName);
        }
        return false;
    }

    public String getParameter(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public String[] getParameterNames() {
        if (this.attributes != null) {
            return this.attributes.keySet().toArray(new String[this.attributes.size()]);
        }
        return new String[0];
    }

    public int getCompareType() {
        return 0;
    }

    public String toString() {
        ModelWriterString writer = new ModelWriterString(this);
        return writer.run();
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public Node replicate(int state) {
        Node instance = this.createEmptyClone();
        instance.setState(state);
        instance.parent = null;
        if (this.attributes != null) {
            instance.attributes = (AttributeMap)this.attributes.clone();
        }
        instance.readString(this.getContent());
        if (instance != null) {
            for (Map.Entry<NodeFactory.TAG, List<Node>> set : this.childList.entrySet()) {
                ArrayList list = new ArrayList();
                instance.childList.put(set.getKey(), list);
                for (Node node : set.getValue()) {
                    instance.addChild(node.replicate(state));
                }
            }
        }
        return instance;
    }

    protected Node createEmptyClone() {
        try {
            Node instance = (Node)this.clone();
            instance.clear();
            instance.init();
            return instance;
        }
        catch (CloneNotSupportedException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    protected void clear() {
        this.attributes = null;
        this.childList = new HashMap();
        this.parent = null;
        this.state = 0;
    }

    public boolean equals(Object obj) {
        String otherContent;
        String thisContent;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        if (other.name != this.name) {
            return false;
        }
        if (this.attributes == null != (other.attributes == null)) {
            return false;
        }
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                String key = entry.getKey().toString();
                if (!other.attributes.containsKey(key)) {
                    return false;
                }
                String otherValue = other.attributes.get(key);
                String value = (String)entry.getValue();
                if (value == null != (otherValue == null)) {
                    return false;
                }
                if (value == null || value.equals(otherValue)) continue;
                return false;
            }
        }
        if ((thisContent = this.getContent()) == null != ((otherContent = other.getContent()) == null)) {
            return false;
        }
        return thisContent == null || thisContent.equals(otherContent);
    }

    public String[] getKeyParamNames() {
        return new String[]{"name"};
    }

    public String getKeyValueLowerCase() {
        String keyValueOriginalCase = this.getKeyValueOriginalCase();
        return keyValueOriginalCase != null ? keyValueOriginalCase.toLowerCase() : null;
    }

    public String getKeyValueOriginalCase() {
        String[] keys = this.getKeyParamNames();
        if (keys == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (String key : keys) {
            b.append(this.getParameter(key));
        }
        return b.toString();
    }

    public boolean hasKey() {
        return true;
    }

    public Node findChildMatching(String keyValue, NodeFactory.TAG type) {
        if (keyValue == null) {
            List<? extends Node> list = this.getAllChildren();
            if (list.size() == 1) {
                Node child = list.get(0);
                if (type == null || type == child.getName()) {
                    return child;
                }
            }
            return null;
        }
        keyValue = keyValue.toLowerCase();
        if (type == null) {
            for (List<Node> list : this.childList.values()) {
                Node node = this.searchList(keyValue, list);
                if (node == null) continue;
                return node;
            }
        } else {
            return this.searchList(keyValue, this.childList.get((Object)type));
        }
        return null;
    }

    private Node searchList(String keyValue, List<Node> list) {
        if (list == null) {
            return null;
        }
        for (Node node : list) {
            if (!node.hasKey()) {
                return null;
            }
            if (!keyValue.equals(node.getKeyValueLowerCase())) continue;
            return node;
        }
        return null;
    }

    public List<String> getContentLines() {
        return null;
    }

    public void write(IModelWriter writer) {
        String content = this.getContent();
        writer.openNode(this.getName().toString(), this.childList.size() == 0 && content == null);
        if (this.attributes != null) {
            TreeSet<String> names = new TreeSet<String>(STRING_COMPARATOR);
            for (Object k : this.attributes.keySet()) {
                names.add(k.toString());
            }
            for (String string : names) {
                if ("schema".equalsIgnoreCase(string)) continue;
                writer.writeParameter(string, this.attributes.get(string));
            }
        }
        TreeSet<NodeFactory.TAG> sorter = new TreeSet<NodeFactory.TAG>(TAG_COMPARATOR);
        sorter.addAll(this.childList.keySet());
        for (NodeFactory.TAG tAG : sorter) {
            List<Node> list = this.childList.get((Object)tAG);
            if (list == null) continue;
            for (Node node : list) {
                node.write(writer);
            }
        }
        writer.writeContent(content);
        writer.closeNode();
    }

    public AttributeMap<String> getAttributeMap() {
        return this.attributes;
    }

    public void setDiffReferences(Node source, Node target) {
        this.diffSource = source;
        this.diffTarget = target;
    }

    public Node getDiffSource() {
        return this.diffSource;
    }

    public Node getDiffTarget() {
        return this.diffTarget;
    }

    public String getRecentValue(String key) {
        if (key == null) {
            return null;
        }
        Node target = this.getDiffTarget();
        Node source = this.getDiffSource();
        if (this.isDefined(key)) {
            String value = this.getParameter(key);
            if (value != null) {
                return value;
            }
            if (target.isDefined(key)) {
                return target.getParameter(key);
            }
            return null;
        }
        if (target != null && target.isDefined(key)) {
            return target.getParameter(key);
        }
        return source != null ? source.getParameter(key) : null;
    }

    public abstract HashSet<String> getCIkeys();

    public List<String> getOptionalAttributes() {
        return new ArrayList<String>();
    }

    public boolean hasDefault(String parameterName, DatabaseInfos dbDescription) {
        return false;
    }

    public String getDefault(String parameterName, DatabaseInfos dbDescription) {
        return null;
    }

    private static class TagComparator
    implements Comparator<NodeFactory.TAG> {
        private TagComparator() {
        }

        @Override
        public int compare(NodeFactory.TAG o1, NodeFactory.TAG o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
        }
    }

    private static class StringCIComparator
    implements Comparator<String> {
        private StringCIComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
        }
    }
}

