/*
 * Decompiled with CFR 0.152.
 */
package srv.controller.ticket.timeline;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.TicketAccessInfo;
import com.inet.helpdesk.core.data.TicketAccessInformationsProvider;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceManager;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.tickets.GeneratedTicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeDeadlineLight;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeEscalationLight;
import com.inet.helpdesk.core.ticketmanager.timeline.PeriodOfTime;
import com.inet.helpdesk.core.ticketmanager.timeline.TicketWarningListener;
import com.inet.helpdesk.core.ticketmanager.timeline.TimelineDataHandler;
import com.inet.helpdesk.shared.model.ticket.TicketTimelineInformations;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import srv.controller.ticket.timeline.ResourceTimelineManager;
import srv.controller.ticket.timeline.SpecificThresholdValues;
import srv.controller.ticket.timeline.TimelineJob;
import srv.controller.ticket.timeline.TimelineJobExecuter;
import srv.controller.ticket.timeline.TimelineUtilities;
import srv.controller.ticket.timeline.WorkingHourTimeline;
import srv.mail.AutoMailSender;

public class TimelineDataHandlerImpl
implements TicketEventListener,
GenericFieldsManager.DataChangeListener,
TimelineDataHandler,
UserGroupEventListener {
    private static final long MILLIS_PER_MINUTE = 60000L;
    protected static final long MILLIS_PER_CYCLE = 600000L;
    private static final int EXECUTION = 0;
    private static final int RED = 1;
    private static final int YELLOW = 2;
    private static final int NORMAL = 3;
    private static int escalationWarningActionId = -1;
    private Map<Integer, TicketTimelineInformations> deadlineTickets;
    private Map<Integer, TicketTimelineInformations> escalationsData;
    private int metaDataChangeCounter = 0;
    private long nextEscalationCheck;
    private HashMap<Integer, Double> priorityEskalationSettings;
    private HashMap<Integer, Integer> resourceEskalationSettings;
    private HashMap<Integer, ArrayList<PeriodOfTime>> resourceAttendanceTimes;
    public static final Logger LOGGER = LogManager.getLogger((String)"HelpDesk Timing");
    private static HashSet<Integer> escalationCheckedStatus = new HashSet();
    private static int[] eskalationsStatus = new int[]{100, 101};

    public void init() {
        this.deadlineTickets = new DeadlineMap();
        this.escalationsData = new EscalationMap();
        this.priorityEskalationSettings = new HashMap();
        this.resourceEskalationSettings = new HashMap();
        this.resourceAttendanceTimes = new HashMap();
        this.cacheUpdated();
        UserGroupManager.getInstance().registerListener((UserGroupEventListener)this);
        PriorityManager.getInstance().addDataChangeListener(this);
    }

    private boolean relevantChange(TicketVO newTicket, TicketVO oldTicket) {
        if (newTicket != null && oldTicket != null) {
            boolean sameDeadline;
            boolean sameStatus = oldTicket.getStatusID() == newTicket.getStatusID();
            boolean sameRessource = TimelineDataHandlerImpl.getResourceIdFromTicket(oldTicket) == TimelineDataHandlerImpl.getResourceIdFromTicket(newTicket);
            boolean samePriority = oldTicket.getPriorityID() == newTicket.getPriorityID();
            boolean sameDispatched = oldTicket.isDispatched() == newTicket.isDispatched();
            boolean bl = sameDeadline = oldTicket.getDeadline() == null && newTicket.getDeadline() == null || oldTicket.getDeadline() != null && oldTicket.getDeadline().equals(newTicket.getDeadline());
            if (sameStatus && sameRessource && samePriority && sameDispatched && sameDeadline) {
                LOGGER.debug((Object)("NO CHANGES " + newTicket.getID() + " " + oldTicket.getDeadline() + " " + newTicket.getDeadline()));
                return false;
            }
            LOGGER.debug((Object)("CHANGES " + newTicket.getID() + " - " + sameStatus + " - " + sameRessource + " - " + samePriority + " - " + sameDispatched + " - " + sameDeadline));
        }
        return true;
    }

    private boolean isOfInterest(TicketVO ticket) {
        return ticket != null && ticket.isDispatched() && ticket.getStatusID() < 300 && ticket.getStatusID() >= 100 && ticket.getID() == ticket.getBundleID();
    }

    @Override
    public void handleEvent(TicketEvent event) {
        for (ChangedTicketVO changed : event.getChangedTickets()) {
            TicketVO newTicket = changed.getNewTicket();
            TicketVO oldTicket = changed.getOldTicket();
            if (!this.isOfInterest(newTicket)) {
                if (this.escalationsData.get(changed.getTicketID()) != null) {
                    this.escalationsData.remove(changed.getTicketID());
                    LOGGER.debug((Object)("REMOVE " + changed.getTicketID() + " FROM ESCALATION OBSERVATION"));
                }
                if (this.deadlineTickets.get(changed.getTicketID()) == null) continue;
                this.deadlineTickets.remove(changed.getTicketID());
                LOGGER.debug((Object)("REMOVE " + changed.getTicketID() + " FROM DEADLINE OBSERVATION"));
                continue;
            }
            if (!this.relevantChange(newTicket, oldTicket)) continue;
            int status = newTicket.getStatusID();
            LOGGER.debug((Object)("EVENT " + newTicket.getID() + " Status " + status));
            if (oldTicket == null || oldTicket.getStatusID() == status || status != 102) {
                if (newTicket.getDeadline() == null && this.deadlineTickets.get(newTicket.getID()) != null) {
                    this.deadlineTickets.remove(newTicket.getID());
                    LOGGER.debug((Object)("REMOVE " + newTicket.getID() + " FROM DEADLINE OBSERVATION(Date removed)"));
                } else if (newTicket.getDeadline() != null && newTicket.getDeadline() > System.currentTimeMillis()) {
                    LOGGER.debug((Object)("EVENT DEADLINE " + newTicket.getID() + " CHECK"));
                    Timestamp dl = new Timestamp(newTicket.getDeadline());
                    TicketTimelineInformations data = this.deadlineTickets.get(newTicket.getID());
                    this.checkDeadlineData(newTicket.getID(), TimelineDataHandlerImpl.getResourceIdFromTicket(newTicket), dl, data == null ? false : data.isExpired());
                }
            }
            if (!TimelineDataHandlerImpl.isEscalationCheckedState(status) || TimelineDataHandlerImpl.isEscalatableStatus(status)) {
                this.checkForEscalation(newTicket);
                continue;
            }
            if (this.escalationsData.get(newTicket.getID()) == null) continue;
            this.escalationsData.remove(newTicket.getID());
            LOGGER.debug((Object)("REMOVE " + changed.getTicketID() + " FROM ESCALATION OBSERVATION " + newTicket.getStatusID()));
        }
    }

    private void checkDeadlineData(int ticketID, int resID, Timestamp deadline, boolean expired) {
        TicketTimelineInformations deadlineData = this.deadlineTickets.get(ticketID);
        if (deadlineData != null) {
            if (deadline.equals(deadlineData.getReferenceTime()) && resID == deadlineData.getCalculationResource()) {
                TicketVO ticket;
                Job job;
                if ((this.isCritical(deadlineData.getTargetTime(), System.currentTimeMillis()) || this.isCritical(deadlineData.getSecondThreshold(), System.currentTimeMillis()) || this.isCritical(deadlineData.getFirstThreshold(), System.currentTimeMillis())) && (job = this.checkForExecuteableJob(ticket = TicketManager.getReaderForSystem().getTicket(ticketID), deadlineData, deadlineData.clone(), System.currentTimeMillis(), TimelineUtilities.DEADLINE_TYPES)) != null) {
                    LOGGER.info((Object)("NEW DEADLINE JOB: " + String.valueOf(job)));
                    TimelineJobExecuter.getInstance().addJob(job);
                }
                return;
            }
            deadlineData = new TicketTimelineInformations(ticketID, deadline, TicketTimelineInformations.TimelineType.DEADLINE);
        } else {
            deadlineData = new TicketTimelineInformations(ticketID, deadline, TicketTimelineInformations.TimelineType.DEADLINE);
        }
        deadlineData.setExpired(expired);
        this.calculateDeadlineThresholdsForTicket(ticketID, resID, deadlineData);
    }

    public void groupCreated(UserGroupInfo groupInfo) {
    }

    public void groupRenamed(String previousGroupName, UserGroupInfo groupInfo) {
    }

    public void groupParentChanged(UserGroupInfo groupInfo) {
    }

    public void groupDataUpdated(UserGroupInfo groupInfo) {
        if (groupInfo.getType() == HDUsersAndGroups.RESOURCE) {
            Integer escaResourceId = (Integer)groupInfo.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ESC_RES_ID);
            Integer resourceId = (Integer)groupInfo.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
            Integer previous = this.resourceEskalationSettings.get(resourceId);
            if (escaResourceId == null && previous != null && previous != 0 && escalationWarningActionId < 0) {
                boolean dataRemoved = false;
                for (int ticketId : this.escalationsData.keySet()) {
                    TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
                    if (ticket == null || resourceId != TimelineDataHandlerImpl.getResourceIdFromTicket(ticket)) continue;
                    this.escalationsData.remove(ticketId);
                    dataRemoved = true;
                }
                if (dataRemoved) {
                    LOGGER.info((Object)("Tickets of ressource " + resourceId + " are no longer escalatable!"));
                    ++this.metaDataChangeCounter;
                }
            } else if (escaResourceId != null && previous != null && previous == 0) {
                int countBefore = this.escalationsData.size();
                ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                try (Connection con = factory.getConnection();){
                    this.checkEscalationDataForExecutions(con);
                }
                catch (Exception ex) {
                    LOGGER.error((Throwable)ex);
                }
                if (this.escalationsData.size() > countBefore) {
                    LOGGER.info((Object)("New escalatable tickets for ressource " + resourceId));
                    ++this.metaDataChangeCounter;
                }
            }
            this.cacheUpdated();
        }
    }

    public void groupMembersUpdated(@Nonnull UserGroupInfo groupInfo, @Nonnull Map<GUID, Set<MembershipType>> addedMemberships, @Nonnull Map<GUID, Set<MembershipType>> removedMemberships) {
    }

    public void groupDeleted(UserGroupInfo groupInfo) {
    }

    public void groupDeactivated(UserGroupInfo groupInfo) {
    }

    @Override
    public void cacheUpdated() {
        TicketVO ticket;
        HashSet<Integer> changedResources = new HashSet<Integer>();
        List<ResourceVO> resources = ResourceManager.getInstance().getAll(false);
        for (ResourceVO resource : resources) {
            ArrayList<PeriodOfTime> previousAttendanceTimes;
            this.resourceEskalationSettings.put(resource.getId(), resource.getEscalationID());
            ArrayList<PeriodOfTime> currentAttendanceTimes = TimelineUtilities.getResourceAttendanceTimes(resource.getId());
            if (TimelineUtilities.compareWorkingHours((List<PeriodOfTime>)currentAttendanceTimes, previousAttendanceTimes = this.resourceAttendanceTimes.get(resource.getId()))) continue;
            this.resourceAttendanceTimes.put(resource.getId(), currentAttendanceTimes);
            changedResources.add(resource.getId());
            if (!LOGGER.isDebug()) continue;
            LOGGER.debug((Object)("Time line cache changed resource " + resource.getDisplayValue() + " working periods " + currentAttendanceTimes.size()));
        }
        HashSet<Integer> changedPriorities = new HashSet<Integer>();
        List priorities = PriorityManager.getInstance().getAll(false);
        for (PriorityVO priority : priorities) {
            Integer id;
            Double previousEscalationPeriod;
            Double currentEscalationPeriod = priority.isDeleted() ? 0.0 : priority.getEscalationTimeout();
            if (currentEscalationPeriod.equals(previousEscalationPeriod = this.priorityEskalationSettings.get(id = Integer.valueOf(priority.getId())))) continue;
            this.priorityEskalationSettings.put(id, currentEscalationPeriod);
            changedPriorities.add(id);
            if (!LOGGER.isDebug()) continue;
            LOGGER.debug((Object)("Time line cache changed priority " + priority.getDisplayValue() + " escalation time " + currentEscalationPeriod));
        }
        if (changedPriorities.size() > 0) {
            int affectedTickets = 0;
            for (int ticketId : this.escalationsData.keySet()) {
                ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
                if (ticket == null) {
                    this.escalationsData.remove(ticketId);
                    continue;
                }
                if (!changedPriorities.contains(ticket.getPriorityID())) continue;
                this.checkEscalationForTicket(ticket, this.escalationsData.get(ticketId));
                ++affectedTickets;
            }
            if (affectedTickets > 0) {
                LOGGER.info((Object)("New escalation times for " + changedPriorities.size() + " priorities. Affected tickets: " + affectedTickets));
                ++this.metaDataChangeCounter;
            }
        }
        if (changedResources.size() > 0) {
            int affectedCalculations = 0;
            for (int ticketId : this.deadlineTickets.keySet()) {
                ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
                if (ticket != null) {
                    int resID = TimelineDataHandlerImpl.getResourceIdFromTicket(ticket);
                    if (!changedResources.contains(resID)) continue;
                    this.calculateDeadlineThresholdsForTicket(ticketId, resID, this.deadlineTickets.get(ticketId));
                    ++affectedCalculations;
                    continue;
                }
                LOGGER.debug((Object)("REMOVE(TicketVO null) " + ticketId));
                this.deadlineTickets.remove(ticketId);
            }
            for (int ticketId : this.escalationsData.keySet()) {
                ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
                if (ticket != null) {
                    int resID = TimelineDataHandlerImpl.getResourceIdFromTicket(ticket);
                    if (!changedResources.contains(resID)) continue;
                    this.checkEscalationForTicket(ticket, this.escalationsData.get(ticketId));
                    ++affectedCalculations;
                    continue;
                }
                LOGGER.debug((Object)("REMOVE(TicketVO null) " + ticketId));
                this.escalationsData.remove(ticketId);
            }
            if (affectedCalculations > 0) {
                LOGGER.info((Object)("New attendance times for " + changedResources.size() + " resources. Affected time lines: " + affectedCalculations));
                ++this.metaDataChangeCounter;
            }
        }
    }

    @Override
    public double getPriorityEscalationTime(Integer priorityId) {
        return this.priorityEskalationSettings.get(priorityId);
    }

    @Override
    public ArrayList<PeriodOfTime> getResourceAttendanceTimes(Integer resourceId) {
        ArrayList<PeriodOfTime> times = this.resourceAttendanceTimes.get(resourceId);
        if (times == null) {
            return TimelineUtilities.createDefaultWorkingPeriods();
        }
        return times;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetEscalationData() {
        Map<Integer, TicketTimelineInformations> map = this.escalationsData;
        synchronized (map) {
            for (int id : this.escalationsData.keySet()) {
                try {
                    TicketVO ticket = TicketManager.getReaderForSystem().getTicket(id);
                    this.checkEscalationForTicket(ticket, this.escalationsData.get(id));
                }
                catch (Exception ex) {
                    LOGGER.error((Throwable)ex);
                }
            }
        }
        ++this.metaDataChangeCounter;
        LOGGER.info((Object)"Recalculation of all escalations");
    }

    @Override
    public int getMetaDataChangeCount() {
        return this.metaDataChangeCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetDeadlineData() {
        Map<Integer, TicketTimelineInformations> map = this.deadlineTickets;
        synchronized (map) {
            for (int id : this.deadlineTickets.keySet()) {
                try {
                    TicketTimelineInformations tl = this.deadlineTickets.get(id);
                    this.calculateDeadlineThresholdsForTicket(id, TimelineDataHandlerImpl.getResourceIdFromTicket(id), tl);
                }
                catch (Exception ex) {
                    LOGGER.error((Throwable)ex);
                }
            }
        }
        ++this.metaDataChangeCounter;
        LOGGER.info((Object)"Recalculation of all deadline warnings");
    }

    @Override
    public TicketTimelineInformations getDeadlineData(int ticketId) {
        TicketTimelineInformations tl = this.deadlineTickets.get(ticketId);
        if (tl == null) {
            return null;
        }
        return tl;
    }

    @Override
    public TicketTimelineInformations getEscalationData(int ticketId) {
        return this.escalationsData.get(ticketId);
    }

    @Override
    public ArrayList<TicketTimelineInformations> getTimelinesFor(int[] ticketIds) {
        ArrayList<TicketTimelineInformations> list = new ArrayList<TicketTimelineInformations>();
        for (int ticketId : ticketIds) {
            TicketTimelineInformations esca;
            TicketTimelineInformations dead = this.getDeadlineData(ticketId);
            if (dead != null) {
                list.add(dead);
            }
            if ((esca = this.getEscalationData(ticketId)) == null) continue;
            list.add(esca);
        }
        return list;
    }

    protected Job checkForExecuteableJob(TicketVO ticket, TicketTimelineInformations currentData, TicketTimelineInformations prevData, long compareTime, TimelineUtilities.ExecutionType[] execTypes) {
        Job job = null;
        if (currentData.getTargetTime() > 0L) {
            if (currentData.getTargetTime() < compareTime || this.isCritical(currentData.getTargetTime(), compareTime)) {
                job = new Job(ticket, execTypes[0]);
            } else if (currentData.getSecondThreshold() > 0L && (this.isCritical(currentData.getSecondThreshold(), compareTime) || prevData.getSecondThreshold() > 0L && prevData.getSecondThreshold() > compareTime && currentData.getSecondThreshold() < compareTime)) {
                job = new Job(ticket, execTypes[1]);
            } else if (currentData.getFirstThreshold() > 0L && (this.isCritical(currentData.getFirstThreshold(), compareTime) || prevData.getFirstThreshold() > 0L && prevData.getFirstThreshold() > compareTime && currentData.getFirstThreshold() < compareTime)) {
                job = new Job(ticket, execTypes[2]);
            }
            if (job != null && !job.stillValid(false)) {
                LOGGER.debug((Object)("NO JOB CREATION " + String.valueOf(job)));
                job = null;
            }
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEscalationForTicket(TicketVO ticket, TicketTimelineInformations ticketEscalationData) {
        Map<Integer, TicketTimelineInformations> map = this.escalationsData;
        synchronized (map) {
            LOGGER.info((Object)("ESCALATION CALCULATION FOR TICKET: " + ticket.getID()));
            double redThreshold = TimelineUtilities.getThresholdPeriodFor(TimelineUtilities.ExecutionType.ESCALATION_WARNING_RED);
            Integer resourceId = TimelineDataHandlerImpl.getResourceIdFromTicket(ticket);
            if (ticketEscalationData == null || redThreshold <= 0.0 && (resourceId == null || resourceId == 0)) {
                LOGGER.debug((Object)("ESCALATION REMOVE TICKET: " + ticket.getID()));
                this.escalationsData.remove(ticket.getID());
            } else {
                ResourceTimelineManager rtm = ResourceTimelineManager.getInstance();
                long currentTime = System.currentTimeMillis();
                TicketTimelineInformations copy = ticketEscalationData.clone();
                Timestamp startOfEscalation = ticketEscalationData.getReferenceTime();
                SpecificThresholdValues stv = rtm.calculateEscalation(resourceId, ticket.getPriorityID(), startOfEscalation);
                if (!stv.isValidValue()) {
                    LOGGER.info((Object)("Can not calculate escalation time " + String.valueOf(startOfEscalation) + " for ticket " + ticket.getBundleID()));
                }
                ticketEscalationData.setTargetTime(stv.getTarget().getTime());
                ticketEscalationData.setSecondThreshold(stv.getCriticalThreshold().getTime());
                ticketEscalationData.setFirstThreshold(stv.getRelevantThreshold().getTime());
                ticketEscalationData.setCalculationResource(resourceId);
                LOGGER.debug((Object)("ESCALATION ADD TICKET: " + ticket.getID()));
                LOGGER.debug((Object)("ESCALATION Data: " + String.valueOf(ticketEscalationData)));
                this.escalationsData.put(ticket.getID(), ticketEscalationData);
                Job job = this.checkForExecuteableJob(ticket, ticketEscalationData, copy, currentTime, TimelineUtilities.ESCALATION_TYPES);
                if (job != null) {
                    new Thread(() -> {
                        LOGGER.info((Object)("NEW ESCALATION JOB: " + String.valueOf(job)));
                        TimelineJobExecuter.getInstance().addJob(job);
                    }).start();
                }
            }
        }
    }

    private void calculateDeadlineThresholdsForTicket(int ticket, int resID, TicketTimelineInformations ticketDeadlineData) {
        try {
            LOGGER.debug((Object)("Deadline CHECK FOR TICKET: " + ticket));
            if (ticketDeadlineData == null) {
                LOGGER.debug((Object)("REMOVE(TimeLine null) " + ticket));
                this.deadlineTickets.remove(ticket);
            } else {
                TicketTimelineInformations copy = ticketDeadlineData.clone();
                long deadlineValue = ticketDeadlineData.getReferenceTime().getTime();
                double redThreshold = TimelineUtilities.getThresholdPeriodFor(TimelineUtilities.ExecutionType.DEADLINE_WARNING_RED);
                if (redThreshold <= 0.0) {
                    ticketDeadlineData.setTargetTime(deadlineValue);
                    ticketDeadlineData.setFirstThreshold(deadlineValue);
                    ticketDeadlineData.setSecondThreshold(deadlineValue);
                } else {
                    ticketDeadlineData.setTargetTime(deadlineValue);
                    LOGGER.debug((Object)("DEADLINE " + String.valueOf(new Date(deadlineValue))));
                    if (deadlineValue < System.currentTimeMillis()) {
                        ticketDeadlineData.setFirstThreshold(deadlineValue);
                        ticketDeadlineData.setSecondThreshold(deadlineValue);
                        LOGGER.debug((Object)"water under the bridge");
                    } else {
                        Timestamp deadline = ticketDeadlineData.getReferenceTime();
                        SpecificThresholdValues stv = ResourceTimelineManager.getInstance().calculateDeadlineThresholdValues(resID, deadline);
                        if (stv.isValidValue()) {
                            LOGGER.info((Object)("Can not calculate deadline time " + String.valueOf(deadline) + " for ticket " + ticket));
                        }
                        ticketDeadlineData.setFirstThreshold(stv.getRelevantThreshold().getTime());
                        ticketDeadlineData.setSecondThreshold(stv.getCriticalThreshold().getTime());
                    }
                    if (LOGGER.isDebug()) {
                        LOGGER.debug((Object)("DEADLINE Values: " + String.valueOf(new Date(ticketDeadlineData.getTargetTime())) + " " + String.valueOf(new Date(ticketDeadlineData.getSecondThreshold())) + String.valueOf(new Date(ticketDeadlineData.getFirstThreshold()))));
                    }
                }
                Job job = this.checkForExecuteableJob(TicketManager.getReaderForSystem().getTicket(ticket), ticketDeadlineData, copy, System.currentTimeMillis(), TimelineUtilities.DEADLINE_TYPES);
                if (job != null) {
                    LOGGER.info((Object)("NEW DEADLINE JOB: " + String.valueOf(job)));
                    TimelineJobExecuter.getInstance().addJob(job);
                }
                ticketDeadlineData.setCalculationResource(resID);
                this.deadlineTickets.put(ticket, ticketDeadlineData);
                LOGGER.info((Object)("PUT TO DEADLINE TICKET: " + ticket));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkDeadlineDataForExecutions(Connection con) {
        HashSet<Integer> currentDeadLines = new HashSet<Integer>();
        for (int currentDeadTicket : this.deadlineTickets.keySet()) {
            currentDeadLines.add(currentDeadTicket);
        }
        Statement writeStatus = null;
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("SELECT tblBuendel_1.DeadLine, tblAuftraege.AufID, tblAuftraege.BunID, tblAuftraege.ResID, tblAuftraege.DeadlineZeit FROM tblAuftraege INNER JOIN tblBuendel ON tblAuftraege.BunID = tblBuendel.BunID INNER JOIN tblBuendel tblBuendel_1 ON tblAuftraege.AufID = tblBuendel_1.BunID WHERE tblAuftraege.DeadlineZeit IS NOT NULL AND tblAuftraege.AutorisierenReaID IS NOT NULL AND tblBuendel.Status >= 100 AND tblBuendel.Status < 300");){
            while (rs.next()) {
                boolean active;
                int bunId = rs.getInt("BunID");
                int aufId = rs.getInt("AufID");
                int resId = rs.getInt("ResID");
                Timestamp dl = rs.getTimestamp("DeadlineZeit");
                boolean expired = dl.getTime() < System.currentTimeMillis();
                boolean bl = active = rs.getInt("DeadLine") == 0;
                if (active && expired) {
                    LOGGER.info((Object)("DEADLINE ALREADY EXPIRED FOR TICKET bundle " + bunId + " ticket-id " + aufId));
                    this.executeDeadlineFailed(aufId);
                }
                if (aufId != bunId) continue;
                this.checkDeadlineData(aufId, resId, dl, expired);
                currentDeadLines.remove(aufId);
            }
        }
        catch (SQLException er) {
            LOGGER.error((Throwable)er);
        }
        finally {
            if (writeStatus != null) {
                try {
                    writeStatus.close();
                }
                catch (Throwable er) {}
            }
        }
        for (Integer id : currentDeadLines) {
            LOGGER.info((Object)("REMOVE LEFTOVER " + id));
            this.deadlineTickets.remove(id);
        }
    }

    private void executeDeadlineFailed(int aufId) {
        try (UserAccountScope scope = UserAccountScope.createPrivileged();){
            ActionVO action = (ActionVO)ActionManager.getInstance().get(-5);
            MutableReaStepData reaStepData = new MutableReaStepData();
            reaStepData.put(ReaStepVO.FIELD_DESC, "Deadline!!");
            TicketManager.getManipulator().applyAction(aufId, reaStepData, ReaStepTextVO.empty(), action, ExtensionArguments.create());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Internal statement with no user values")
    private void checkForEscalation(TicketVO ticket) {
        GUID resID = ticket.getResourceID();
        if (resID == null) {
            return;
        }
        UserGroupInfo resource = UserGroupManager.getInstance().getGroup(resID);
        Integer resourceId = (Integer)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
        Integer escaResourceId = (Integer)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ESC_RES_ID);
        if (resourceId == null || resourceId == 0 || (escaResourceId == null || escaResourceId == 0) && (Integer)TimelineUtilities.ESCALATION_WARNING_ACTION.get() <= 0) {
            LOGGER.debug((Object)("NO ESCALATION CHECK NEEDED FOR TICKET " + ticket.getID()));
            this.escalationsData.remove(ticket.getID());
            return;
        }
        Map<Integer, TicketTimelineInformations> map = this.escalationsData;
        synchronized (map) {
            ConnectionFactory cf = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
            try (Connection con = cf.getConnection("HDS");
                 Statement st = con.createStatement();
                 ResultSet rs = st.executeQuery("SELECT * FROM qryEscalation WHERE BunID = " + ticket.getID());){
                if (rs.next()) {
                    TimelineDataHandlerImpl.checkEscalationStates(rs.getInt("Status"));
                    TicketTimelineInformations escaTl = this.getEscalationData(ticket.getID());
                    Timestamp baseTime = this.findLastAccess(con, ticket.getID());
                    if (baseTime == null) {
                        LOGGER.error((Object)("In inconsistent data " + ticket.getID()));
                        return;
                    }
                    if (escaTl != null && escaTl.getReferenceTime().equals(baseTime)) {
                        this.checkEscalationForTicket(ticket, escaTl);
                    } else {
                        escaTl = new TicketTimelineInformations(ticket.getID(), baseTime, TicketTimelineInformations.TimelineType.ESCALATION);
                        this.checkEscalationForTicket(ticket, escaTl);
                    }
                } else {
                    TimelineDataHandlerImpl.setEscalationCheckedState(ticket.getStatusID());
                    this.escalationsData.remove(ticket.getID());
                }
                LOGGER.debug((Object)("ESCALATION DATA CHECKED " + ticket.getID()));
            }
            catch (SQLException er) {
                LOGGER.error((Throwable)er);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Internal statement with no user values")
    private int getEscalationWarningActionID(Connection con) {
        ResultSet rs = null;
        int resultId = -1;
        if ((Integer)TimelineUtilities.ESCALATION_WARNING_ACTION.get() > 0) {
            try (Statement st = con.createStatement();){
                rs = st.executeQuery("SELECT AktID FROM tblAktionen INNER JOIN tblStatus ON tblAktionen.Status = tblStatus.Status WHERE tblStatus.Status > 100 AND tblStatus.Status < 300 AND tblStatus.intern = 0 AND AktID = " + String.valueOf(TimelineUtilities.ESCALATION_WARNING_ACTION.get()));
                if (rs.next()) {
                    resultId = (Integer)TimelineUtilities.ESCALATION_WARNING_ACTION.get();
                }
            }
            catch (SQLException er) {
                LOGGER.error((Throwable)er);
            }
            finally {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return resultId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void checkEscalationDataForExecutions(Connection con) {
        long time = System.currentTimeMillis();
        this.nextEscalationCheck = time + 600000L;
        ResultSet rs = null;
        int[] currentEscaTickets = null;
        int newEscalationWarningActionId = this.getEscalationWarningActionID(con);
        boolean evalAll = escalationWarningActionId != newEscalationWarningActionId;
        escalationWarningActionId = newEscalationWarningActionId;
        currentEscaTickets = this.escalationsData.keySet().stream().mapToInt(Integer::intValue).toArray();
        try (Statement st = con.createStatement();){
            rs = st.executeQuery("SELECT * FROM qryEscalation");
            while (rs.next()) {
                int ticketID = rs.getInt("BunID");
                TimelineDataHandlerImpl.checkEscalationStates(rs.getInt("Status"));
                int escaResID = rs.getInt("Eskalation");
                TicketTimelineInformations escalationData = this.getEscalationData(ticketID);
                if (!evalAll && escalationData != null) {
                    if (escalationData.getTargetTime() < time) {
                        LOGGER.info((Object)("Escalation for ticket is overdue " + ticketID));
                        this.executeTicketEscalation(con, TicketManager.getReaderForSystem().getTicket(ticketID), escaResID);
                        continue;
                    }
                    if (escalationData.getTargetTime() < this.nextEscalationCheck || this.isCritical(escalationData.getFirstThreshold(), time) || this.isCritical(escalationData.getSecondThreshold(), time)) {
                        TimelineUtilities.ExecutionType type = escalationData.getTargetTime() < this.nextEscalationCheck ? TimelineUtilities.ExecutionType.ESCALATION : (this.isCritical(escalationData.getSecondThreshold(), time) ? TimelineUtilities.ExecutionType.ESCALATION_WARNING_RED : TimelineUtilities.ExecutionType.ESCALATION_WARNING_YELLOW);
                        Job toExceute = new Job(TicketManager.getReaderForSystem().getTicket(ticketID), type);
                        if (toExceute.stillValid(false)) {
                            TimelineJobExecuter.getInstance().addJob(toExceute);
                        }
                    }
                    this.addOrMarkAsInUse(ticketID, currentEscaTickets, escalationData);
                    continue;
                }
                Timestamp baseTime = escaResID > 0 || escalationWarningActionId > 0 ? this.findLastAccess(con, ticketID) : null;
                if (baseTime == null) continue;
                if (baseTime.after(new Timestamp(time))) {
                    LOGGER.warn((Object)("Invalid escalation start time " + String.valueOf(baseTime)));
                    continue;
                }
                TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketID);
                LOGGER.debug((Object)("Escalation " + ticketID + " start of calculation " + String.valueOf(baseTime)));
                escalationData = new TicketTimelineInformations(ticket.getID(), baseTime, TicketTimelineInformations.TimelineType.ESCALATION);
                this.checkEscalationForTicket(ticket, escalationData);
                this.addOrMarkAsInUse(ticketID, currentEscaTickets, escalationData);
            }
            for (int key : currentEscaTickets) {
                if (key == -1) continue;
                LOGGER.info((Object)("ESCALATION REMOVE TICKET (NOT IN VIEW): " + key));
                this.escalationsData.remove(key);
            }
        }
        catch (SQLException er) {
            LOGGER.error((Throwable)er);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
        }
        LOGGER.info((Object)("Escalations checked for " + this.escalationsData.size() + " tickets in " + (System.currentTimeMillis() - time) + "ms"));
    }

    private void addOrMarkAsInUse(int ticketID, int[] currentEscaTickets, TicketTimelineInformations escalationData) {
        int currentTicketPos = this.isOnPosition(ticketID, currentEscaTickets);
        if (currentTicketPos == -1) {
            LOGGER.debug((Object)("ESCALATION ADD NEW TICKET: " + ticketID));
            this.escalationsData.put(ticketID, escalationData);
        } else {
            currentEscaTickets[currentTicketPos] = -1;
        }
    }

    private int isOnPosition(int key, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != key) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Internal statement with no user values")
    private void executeTicketEscalation(Connection connection, TicketVO ticket, int targetResource) throws SQLException {
        block47: {
            if (this.ticketIsBeingEditedBySupporter(ticket.getID())) {
                LOGGER.warn((Object)("No escalation of ticket " + ticket.getID() + " because ticket is being modified."));
                return;
            }
            if (targetResource == -1) {
                Statement st;
                ResultSet rs = null;
                try {
                    st = connection.createStatement();
                    rs = st.executeQuery("SELECT * FROM qryEscalation WHERE BunID = " + ticket.getID());
                    if (rs.next()) {
                        targetResource = rs.getInt("Eskalation");
                        Timestamp letzterZugriff = this.findLastAccess(connection, ticket.getID());
                        TicketTimelineInformations escaData = this.getEscalationData(ticket.getID());
                        if (escaData == null || !escaData.getReferenceTime().equals(letzterZugriff)) {
                            LOGGER.error((Object)("Timeline data changed for ticket " + ticket.getID()));
                            return;
                        }
                        break block47;
                    }
                    this.escalationsData.remove(ticket.getID());
                }
                catch (Exception er) {
                    LOGGER.error((Throwable)er);
                    break block47;
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Throwable er) {}
                }
                return;
                {
                    finally {
                        if (st != null) {
                            st.close();
                        }
                    }
                }
            }
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        if (targetResource > 0) {
            try (UserAccountScope scope = UserAccountScope.createPrivileged();){
                UserGroupInfo newResource = HDUsersAndGroups.getResource(targetResource);
                ExtensionArguments extensionArgs = ExtensionArguments.create();
                ExtensionArguments.ResourceActionExtensionData resActionExtData = ExtensionArguments.ResourceActionExtensionData.forEscalationOfActiveTicket(newResource.getID(), true);
                extensionArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, resActionExtData);
                TicketManager.getManipulator().applyAction(ticket.getID(), new MutableReaStepData(), ReaStepTextVO.empty(), (ActionVO)ActionManager.getInstance().get(6), extensionArgs);
            }
            LOGGER.debug((Object)("ESCALATION REMOVE TICKET (escalation): " + ticket.getID()));
            this.escalationsData.remove(ticket.getID());
        } else if (targetResource != -1 && escalationWarningActionId != -1) {
            try {
                ActionVO escalationAction = (ActionVO)ActionManager.getInstance().get(escalationWarningActionId);
                int resettingStatus = escalationAction.getStatusID();
                if (resettingStatus <= 103 || resettingStatus >= 300) {
                    return;
                }
            }
            catch (RuntimeException e) {
                LOGGER.error((Throwable)e);
                return;
            }
            try (UserAccountScope scope = UserAccountScope.createPrivileged();){
                MutableReaStepData reaStepData = new MutableReaStepData();
                ReaStepTextVO reaStepText = ReaStepTextVO.empty();
                ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(escalationWarningActionId);
                TicketManager.getManipulator().applyAction(ticket.getID(), reaStepData, reaStepText, actionVO, null);
            }
            LOGGER.debug((Object)("ESCALATION REMOVE TICKET (warning status): " + ticket.getID()));
            this.escalationsData.remove(ticket.getID());
        } else {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Internal statement with no user values")
    private Timestamp findLastAccess(Connection con, int bunid) {
        Timestamp result = null;
        String sql = "SELECT tblAktionen.AktID, tblAktionen.Status, tblRealisierung.EndZeit, tblRealisierung.OrgBunID FROM tblAktionen INNER JOIN tblRealisierung ON tblAktionen.AktID = tblRealisierung.AktID WHERE BunID = " + bunid + " ORDER BY ReaID DESC";
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            boolean beforeBundleTicket = false;
            while (rs.next()) {
                int status = rs.getInt("Status");
                int aktID = rs.getInt("AktID");
                int realBunID = rs.getInt("OrgBunID");
                if (!beforeBundleTicket || bunid == realBunID) {
                    if (status < 100 && status != -100 || status > 100 && !TimelineDataHandlerImpl.isEscalatableStatus(status)) {
                        if (!LOGGER.isDebug()) return result;
                        LOGGER.debug((Object)("findLastAccess break " + status + " " + TimelineDataHandlerImpl.isEscalatableStatus(status) + " " + String.valueOf(result)));
                        return result;
                    }
                    if (TimelineDataHandlerImpl.isEscalatableStatus(status)) {
                        result = rs.getTimestamp("EndZeit");
                    }
                }
                if (LOGGER.isDebug()) {
                    LOGGER.debug((Object)("findLastAccess " + status + " " + TimelineDataHandlerImpl.isEscalatableStatus(status) + " " + String.valueOf(result)));
                }
                if (aktID == -1) {
                    beforeBundleTicket = true;
                    continue;
                }
                if (beforeBundleTicket && bunid != realBunID) continue;
                if (aktID == 5) return result;
                if (aktID == -24) return result;
                if (aktID == 6) return result;
                if (aktID == 8) return result;
                if (aktID == -11) return result;
            }
            return result;
        }
        catch (SQLException er) {
            LOGGER.error((Throwable)er);
        }
        return result;
    }

    private boolean isCritical(long threshold, long compareTime) {
        return threshold > compareTime && threshold < compareTime + 600000L;
    }

    private static Integer getResourceIdFromTicket(int ticketID) {
        return TimelineDataHandlerImpl.getResourceIdFromTicket(TicketManager.getReaderForSystem().getTicket(ticketID));
    }

    private static Integer getResourceIdFromTicket(TicketVO ticket) {
        if (ticket != null) {
            GUID resID = ticket.getResourceID();
            if (resID == null) {
                return null;
            }
            UserGroupInfo resource = UserGroupManager.getInstance().getGroup(resID);
            return (Integer)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
        }
        return null;
    }

    @Override
    public void validateNonWorkingPeriods() {
        int testTicketID = -1;
        if (this.deadlineTickets.size() > 0) {
            testTicketID = this.deadlineTickets.keySet().iterator().next();
        } else if (this.escalationsData.size() > 0) {
            testTicketID = this.escalationsData.keySet().iterator().next();
        }
        if (testTicketID > -1) {
            Integer resID = TimelineDataHandlerImpl.getResourceIdFromTicket(testTicketID);
            ResourceTimelineManager.getInstance().isResourceAccessibleNow(resID);
        }
    }

    private boolean ticketIsBeingEditedBySupporter(int ticketId) {
        TicketAccessInfo info = ((TicketAccessInformationsProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAccessInformationsProvider.class)).getTicketAccessInfo(ticketId);
        return info != null && info.getWriteSession() != null && HDUsersAndGroups.isSupporter(UserManager.getInstance().getUserAccount(info.getWriteSession().getUser()));
    }

    private <T> T sendEventForDeadline(int ticketId, Supplier<T> task) {
        return this.sendEventForDeadline(ticketId, null, task);
    }

    private <T> T sendEventForDeadline(int ticketId, TicketAttributeDeadlineLight.Value oldLight, Supplier<T> task) {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
        if (ticket == null) {
            return task.get();
        }
        if (oldLight == null) {
            oldLight = ticket.getAttribute(Tickets.ATTRIBUTE_DEADLINE_LIGHT);
        }
        T result = task.get();
        HashMap<GeneratedTicketAttribute, Object> oldValues = new HashMap<GeneratedTicketAttribute, Object>();
        oldValues.put(Tickets.ATTRIBUTE_DEADLINE_LIGHT, (Object)oldLight);
        TicketManager.extending().getGeneratedAttributeEventSender().sendEventForGeneratedAttributeChanged(ticketId, oldValues);
        return result;
    }

    private <T> T performActionAndSendEventForEscalation(int ticketId, Supplier<T> task) {
        return this.performActionAndSendEventForEscalation(ticketId, null, task);
    }

    private <T> T performActionAndSendEventForEscalation(int ticketId, TicketAttributeEscalationLight.Value oldLight, Supplier<T> task) {
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
        if (ticket == null) {
            return task.get();
        }
        if (oldLight == null) {
            oldLight = ticket.getAttribute(Tickets.ATTRIBUTE_ESCALATION_LIGHT);
        }
        Long oldTime = ticket.getAttribute(Tickets.ATTRIBUTE_ESCALATION_TIME);
        T result = task.get();
        HashMap<GeneratedTicketAttribute, Object> oldValues = new HashMap<GeneratedTicketAttribute, Object>();
        oldValues.put(Tickets.ATTRIBUTE_ESCALATION_LIGHT, (Object)oldLight);
        oldValues.put(Tickets.ATTRIBUTE_ESCALATION_TIME, oldTime);
        TicketManager.extending().getGeneratedAttributeEventSender().sendEventForGeneratedAttributeChanged(ticketId, oldValues);
        return result;
    }

    @Override
    public Date calcMomentUsingResourceWorkingHours(Date begin, double timePeriodInHours, Integer resourceId) {
        WorkingHourTimeline rct = ResourceTimelineManager.getInstance().getTimelineForResource(resourceId, timePeriodInHours);
        return rct.calculatePeriodUp(begin, timePeriodInHours);
    }

    public static void setEscalationCheckedState(int status) {
        escalationCheckedStatus.add(status);
    }

    public static boolean isEscalationCheckedState(int status) {
        return escalationCheckedStatus.contains(status);
    }

    public static boolean isEscalatableStatus(int status) {
        for (int eskalationsStatu : eskalationsStatus) {
            if (eskalationsStatu != status) continue;
            return true;
        }
        return false;
    }

    public static void checkEscalationStates(int status) {
        for (int eskalationsStatu : eskalationsStatus) {
            if (eskalationsStatu != status) continue;
            return;
        }
        TimelineDataHandlerImpl.setEscalationCheckedState(status);
        int[] newEskalations = new int[eskalationsStatus.length + 1];
        System.arraycopy(eskalationsStatus, 0, newEskalations, 0, eskalationsStatus.length);
        newEskalations[TimelineDataHandlerImpl.eskalationsStatus.length] = status;
        eskalationsStatus = newEskalations;
        HDLogger.debug("New escalation status: " + status);
    }

    private class DeadlineMap
    extends ConcurrentHashMap<Integer, TicketTimelineInformations> {
        private DeadlineMap() {
        }

        @Override
        public TicketTimelineInformations put(Integer key, TicketTimelineInformations value) {
            return TimelineDataHandlerImpl.this.sendEventForDeadline(key, () -> super.put(key, value));
        }

        @Override
        public TicketTimelineInformations remove(Object key) {
            int ticketId = (Integer)key;
            return TimelineDataHandlerImpl.this.sendEventForDeadline(ticketId, () -> (TicketTimelineInformations)super.remove(key));
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    }

    private class EscalationMap
    extends ConcurrentHashMap<Integer, TicketTimelineInformations> {
        private EscalationMap() {
        }

        @Override
        public TicketTimelineInformations put(Integer key, TicketTimelineInformations value) {
            return TimelineDataHandlerImpl.this.performActionAndSendEventForEscalation(key, () -> super.put(key, value));
        }

        @Override
        public TicketTimelineInformations remove(Object key) {
            int ticketId = (Integer)key;
            return TimelineDataHandlerImpl.this.performActionAndSendEventForEscalation(ticketId, () -> (TicketTimelineInformations)super.remove(key));
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }
    }

    public class Job
    implements TimelineJob {
        private TicketVO ticket;
        private final TicketAttributeEscalationLight.Value escalationLight;
        private final TicketAttributeDeadlineLight.Value deadlineLight;
        private final TimelineUtilities.ExecutionType type;
        private long lastChanged;

        private Job(TicketVO ticket, TimelineUtilities.ExecutionType type) {
            LOGGER.debug((Object)("New timeline job for ticket " + ticket.getID() + " Type: " + String.valueOf((Object)type)));
            this.ticket = ticket;
            this.type = type;
            this.lastChanged = ticket.getLastChanged();
            this.escalationLight = ticket.getAttribute(Tickets.ATTRIBUTE_ESCALATION_LIGHT);
            this.deadlineLight = ticket.getAttribute(Tickets.ATTRIBUTE_DEADLINE_LIGHT);
        }

        @Override
        public boolean stillValid(boolean reload) {
            if (reload) {
                int id = this.ticket.getID();
                TicketVO newTicket = TicketManager.getReaderForSystem().getTicket(id);
                if (newTicket == null) {
                    LOGGER.error((Object)("INVALID JOB ticket not available " + id));
                    return false;
                }
                this.ticket = newTicket;
            }
            boolean valid = false;
            if (TimelineDataHandlerImpl.isEscalatableStatus(this.ticket.getStatusID()) && (this.type == TimelineUtilities.ExecutionType.ESCALATION || this.type == TimelineUtilities.ExecutionType.ESCALATION_WARNING_RED || this.type == TimelineUtilities.ExecutionType.ESCALATION_WARNING_YELLOW)) {
                TicketTimelineInformations timeline = TimelineDataHandlerImpl.this.getEscalationData(this.ticket.getID());
                if (timeline != null && this.lastChanged == this.ticket.getLastChanged()) {
                    valid = true;
                } else {
                    LOGGER.debug((Object)("INVALID JOB status " + String.valueOf(timeline) + " " + String.valueOf((Object)this.type) + " " + (this.lastChanged == this.ticket.getLastChanged())));
                }
            } else if (this.ticket.getStatusID() < 300 && (this.type == TimelineUtilities.ExecutionType.DEADLINE || this.type == TimelineUtilities.ExecutionType.DEADLINE_WARNING_RED || this.type == TimelineUtilities.ExecutionType.DEADLINE_WARNING_YELLOW)) {
                boolean bl = valid = this.ticket.getDeadline() != null && this.getExecutionTime() + 60000L > System.currentTimeMillis() && this.getExecutionTime() > System.currentTimeMillis() - 600000L;
                if (!valid) {
                    LOGGER.debug((Object)("INVALID JOB deadline " + this.ticket.getDeadline() + " " + (this.getExecutionTime() + 60000L > System.currentTimeMillis()) + " " + (this.getExecutionTime() > System.currentTimeMillis() - 600000L) + " " + String.valueOf(new Date(this.getExecutionTime()))));
                }
            } else {
                LOGGER.debug((Object)("INVALID JOB status " + this.ticket.getStatusID() + " " + String.valueOf((Object)this.type)));
            }
            return valid;
        }

        protected TimelineUtilities.ExecutionType getExecutionType() {
            return this.type;
        }

        @Override
        public long getExecutionTime() {
            TicketTimelineInformations tl = this.getTimeline();
            if (tl != null) {
                if (this.type == TimelineUtilities.ExecutionType.ESCALATION || this.type == TimelineUtilities.ExecutionType.DEADLINE) {
                    return tl.getTargetTime();
                }
                if (this.type == TimelineUtilities.ExecutionType.ESCALATION_WARNING_RED || this.type == TimelineUtilities.ExecutionType.DEADLINE_WARNING_RED) {
                    return tl.getSecondThreshold();
                }
                if (this.type == TimelineUtilities.ExecutionType.ESCALATION_WARNING_YELLOW || this.type == TimelineUtilities.ExecutionType.DEADLINE_WARNING_YELLOW) {
                    return tl.getFirstThreshold();
                }
            }
            return -1L;
        }

        private TicketTimelineInformations getTimeline() {
            switch (this.type) {
                case ESCALATION: 
                case ESCALATION_WARNING_RED: 
                case ESCALATION_WARNING_YELLOW: {
                    return TimelineDataHandlerImpl.this.getEscalationData(this.ticket.getID());
                }
                case DEADLINE: 
                case DEADLINE_WARNING_RED: 
                case DEADLINE_WARNING_YELLOW: {
                    return TimelineDataHandlerImpl.this.getDeadlineData(this.ticket.getID());
                }
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Job) {
                Job compare = (Job)obj;
                return this.ticket.getID() == compare.ticket.getID() && this.type == compare.type;
            }
            return false;
        }

        @Override
        public void execute() {
            List ticketWarningListeners = ServerPluginManager.getInstance().get(TicketWarningListener.class);
            String producerEmail = null;
            if (this.type == TimelineUtilities.ExecutionType.ESCALATION) {
                ConnectionFactory cf = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                try (Connection con = cf.getConnection("HDS");){
                    TimelineDataHandlerImpl.this.executeTicketEscalation(con, this.ticket, -1);
                }
                catch (SQLException er) {
                    LOGGER.error((Throwable)er);
                }
            } else if (this.type == TimelineUtilities.ExecutionType.ESCALATION_WARNING_RED) {
                TimelineDataHandlerImpl.this.performActionAndSendEventForEscalation(this.ticket.getID(), this.escalationLight, () -> null);
                AutoMailSender.sendIfNeeded(this.ticket.getID(), 22, producerEmail);
            } else if (this.type == TimelineUtilities.ExecutionType.ESCALATION_WARNING_YELLOW) {
                TimelineDataHandlerImpl.this.performActionAndSendEventForEscalation(this.ticket.getID(), this.escalationLight, () -> null);
                AutoMailSender.sendIfNeeded(this.ticket.getID(), 21, producerEmail);
            } else if (this.type == TimelineUtilities.ExecutionType.DEADLINE) {
                TimelineDataHandlerImpl.this.executeDeadlineFailed(this.ticket.getID());
                TimelineDataHandlerImpl.this.sendEventForDeadline(this.ticket.getID(), this.deadlineLight, () -> null);
            } else if (this.type == TimelineUtilities.ExecutionType.DEADLINE_WARNING_RED) {
                AutoMailSender.sendIfNeeded(this.ticket.getID(), 24, producerEmail);
                TimelineDataHandlerImpl.this.sendEventForDeadline(this.ticket.getID(), this.deadlineLight, () -> null);
            } else if (this.type == TimelineUtilities.ExecutionType.DEADLINE_WARNING_YELLOW) {
                AutoMailSender.sendIfNeeded(this.ticket.getID(), 23, producerEmail);
                TimelineDataHandlerImpl.this.sendEventForDeadline(this.ticket.getID(), this.deadlineLight, () -> null);
            }
        }

        public String toString() {
            long time = this.getExecutionTime();
            return this.ticket.getID() + " " + String.valueOf((Object)this.type) + " " + (time > 0L ? new Date(time).toString() : "no time available");
        }
    }
}

