/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data.step;

import com.inet.annotations.JsonData;
import com.inet.http.upload.AttachmentDescription;
import com.inet.shared.http.upload.AttachmentType;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonData
@Schema(description="Response data for an attachment in a ticket reaction step")
public class AttachmentResponseData
extends AttachmentDescription {
    @Schema(description="The ID of the reaction step this attachment belongs to", hidden=true)
    private transient Integer stepId;
    @Schema(description="The size of the attachment file in bytes")
    private long fileLength;
    @Schema(description="The relative URL to access this attachment")
    private String url;

    public AttachmentResponseData(Integer stepId, String fileName, long fileLength, long lastModified, String url, boolean isEmbedded) {
        super(fileName, lastModified, isEmbedded ? AttachmentType.EmbeddedImage : AttachmentType.Attachment);
        this.stepId = stepId;
        this.fileLength = fileLength;
        this.url = url;
    }

    public Integer getStepId() {
        return this.stepId;
    }
}

