/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.logging;

import com.inet.classloader.I18nMessages;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.logging.EventLog;
import java.util.Locale;

public enum MailErrorEventLog {
    EmailsCouldNotBeFetched,
    EmailCouldNotBeSent,
    EmailBouncedAfterSending,
    ConnectionRestored;

    private static final EventLog<MailErrorEventLog> EVENT_LOG;
    public static final I18nMessages MSG;

    public void log(EmailAccount account, String extraInfo) {
        String msg = MSG.getMsg(Locale.getDefault(), "eventlog." + this.name(), new Object[0]);
        String emailAccount = account == null ? "" : account.getAccount();
        EVENT_LOG.log((Enum)this, null, msg, null, new Object[]{emailAccount, extraInfo});
    }

    static {
        EVENT_LOG = EventLog.register((String)"helpdeskmail");
        MSG = new I18nMessages("com.inet.helpdesk.logging.LanguageResources", MailErrorEventLog.class);
    }
}

