/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.error;

import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.IllegalStateExceptionWithErrorCode;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.permissions.AccessDeniedException;

public class HDErrors {
    public static IllegalStateException createIllegalTicketStateException(String message) {
        return (IllegalStateException)HDErrors.createExceptionForCode(message, HelpDeskErrorCodes.TICKET_OPERATION_NOT_POSSIBLE_WRONG_STATE);
    }

    public static RuntimeException createExceptionForCode(ActionCheckError error) {
        return HDErrors.createExceptionForCode(error.getErrorMessage(), error.getErrorCode());
    }

    public static RuntimeException createExceptionForCode(String message, ErrorCode code) {
        if (code == HelpDeskErrorCodes.TICKET_OPERATION_NOT_POSSIBLE_WRONG_SETTING) {
            return new IllegalStateExceptionWithErrorCode(message, code);
        }
        if (code == HelpDeskErrorCodes.TICKET_OPERATION_NOT_POSSIBLE_CORRUPTED_SETTING) {
            return new IllegalStateExceptionWithErrorCode(message, code);
        }
        if (code == HelpDeskErrorCodes.TICKET_OPERATION_NOT_POSSIBLE_WRONG_STATE) {
            return new IllegalStateExceptionWithErrorCode(message, code);
        }
        if (code == BaseErrorCode.forbidden || code == BaseErrorCode.UserLoginRequired || code == BaseErrorCode.UserNotLoggedIn) {
            return new AccessDeniedException(message, code);
        }
        if (code == HelpDeskErrorCodes.FATAL_ERROR) {
            return new IllegalArgumentException(message);
        }
        HDLogger.warn("[Server] Unknown error type: " + String.valueOf(code));
        return new IllegalStateExceptionWithErrorCode(message, code);
    }
}

