/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.attachmentdisplay;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.attachmentdisplay.AttachmentDisplayProvider;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class PlainTextAttachmentDisplayProvider
implements AttachmentDisplayProvider {
    private static final List<String> EXTENSIONS = Arrays.asList("txt", "log", "properties", "css", "less", "js", "csv", "json", "yml", "yaml", "delivery-status", "rfc822-headers");
    private static final List<String> MIME_TYPES = Arrays.asList("text/plain; charset=utf-8", "application/json; charset=utf-8", "text/css", "text/x-comma-separated-values", "message/delivery-status", "text/rfc822-headers");

    @Override
    public String getType() {
        return "plaintext";
    }

    @Override
    public String getSourceOrContent(String mimeType, AttachmentRow attachment) {
        block20: {
            String string;
            block22: {
                int index;
                PersistenceEntry file;
                AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
                AttachmentFileRow attachmentFile = attService.getAttachmentFile(attachment.getChecksum(), attachment.getFileLength());
                if (attachmentFile == null || !(file = AppDataLocation.getAttachmentFile(attachmentFile.getFilePath())).exists()) break block20;
                Charset charSet = StandardCharsets.UTF_8;
                if (mimeType != null && (index = mimeType.indexOf("; charset=")) > 0) {
                    String cs = mimeType.substring(index + 10);
                    try {
                        charSet = Charset.forName(cs);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try (Closeable input = new BufferedReader(new InputStreamReader(file.getInputStream()));){
                    char[] buffer = new char[3];
                    int length = ((Reader)input).read(buffer);
                    if (length >= 2) {
                        if (buffer[0] == '\u00ff' && buffer[1] == '\u00fe') {
                            charSet = StandardCharsets.UTF_16LE;
                        }
                        if (buffer[0] == '\u00fe' && buffer[1] == '\u00ff') {
                            charSet = StandardCharsets.UTF_16BE;
                        }
                    }
                    if (length >= 3 && buffer[0] == '\u00ef' && buffer[1] == '\u00bb' && buffer[2] == '\u00bf') {
                        charSet = StandardCharsets.UTF_8;
                    }
                }
                input = file.getInputStream();
                try {
                    String content;
                    string = content = IOFunctions.readString((InputStream)input, (Charset)charSet);
                    if (input == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                ((InputStream)input).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        LogManager.getApplicationLogger().error(t);
                    }
                }
                ((InputStream)input).close();
            }
            return string;
        }
        return "";
    }

    @Override
    public boolean isResponsible(String mimeType, AttachmentRow attachment) {
        Optional<String> hasMime;
        if (attachment.getFileLength() > 0x200000L) {
            return false;
        }
        if (mimeType != null && (hasMime = MIME_TYPES.stream().filter(m -> mimeType.equals(m) || mimeType.startsWith(m + ";")).findAny()).isPresent()) {
            return true;
        }
        String fileName = attachment.getFileName();
        if (fileName != null) {
            String fileNameLowerCase = fileName.toLowerCase();
            Optional<String> hasExtension = EXTENSIONS.stream().filter(e -> fileNameLowerCase.endsWith("." + e)).findAny();
            if (hasExtension.isPresent()) {
                return true;
            }
        }
        return false;
    }
}

