/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.jobrunner.jobs;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.jobrunner.JobStructure;
import com.inet.dbupdater.jobrunner.jobs.IJob;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.ResultSet;
import java.util.List;

public class JobVersionScript
implements IJob {
    private static Logger logger = LogManager.getLogger((String)"DB Updater");
    private final boolean isUpdate;
    private final DatabaseInfos sourceCon;

    public JobVersionScript(boolean isUpdate, DatabaseInfos sourceCon) {
        this.isUpdate = isUpdate;
        this.sourceCon = sourceCon;
    }

    @Override
    public JobStructure createCommands(DatabaseInfos targetCon, Node version) {
        if (version.getName() != NodeFactory.TAG.version) {
            throw new IllegalArgumentException("The JobCreateView can be used only for versiond scripts!");
        }
        for (Node node : version.getAllChildren()) {
            if (node.getName() != NodeFactory.TAG.condition || this.checkCondition(node, this.sourceCon != null ? this.sourceCon : targetCon)) continue;
            return null;
        }
        JobStructure commands = new JobStructure();
        for (Node node : version.getAllChildren()) {
            if (node.getName() != NodeFactory.TAG.script) continue;
            IDatabaseCommand.TIME execTime = IDatabaseCommand.TIME.executescripts;
            String time = node.getParameter(IDatabaseInfos.SCRIPT_PARAM.executiontime.name());
            if (time != null) {
                try {
                    execTime = IDatabaseCommand.TIME.valueOf(time.toLowerCase());
                }
                catch (Exception e) {
                    logger.warn((Object)("Unknown execution time '" + time + "' in update script"));
                }
            }
            this.createCommandsForTime(node.getAllChildren(), execTime, commands, targetCon, this.mayFail(node));
        }
        return commands;
    }

    private boolean mayFail(Node scriptNode) {
        String fail = scriptNode.getParameter(IDatabaseInfos.SCRIPT_PARAM.mayfail.name());
        if (fail == null) {
            return false;
        }
        if (fail.equalsIgnoreCase("always")) {
            return true;
        }
        return this.isUpdate && fail.equalsIgnoreCase("onupdate");
    }

    private boolean checkCondition(Node condition, DatabaseInfos targetCon) {
        boolean hasResult;
        String sql = condition.getContent();
        String expectString = condition.getParameter(IDatabaseInfos.CONDITION_PARAM.expect.name());
        boolean expectSuccess = true;
        if (expectString != null) {
            if ((expectString = expectString.toLowerCase().trim()).equals("fail")) {
                expectSuccess = false;
            } else if (!expectString.equals("success")) {
                logger.warn((Object)("Unknown condition expect '" + expectString + "', expection condition to be fulfilled."));
            }
        }
        if (sql == null || sql.trim().length() == 0) {
            logger.info((Object)("Condition returned '" + expectSuccess + "' since the condition string is empty"));
            return expectSuccess;
        }
        try {
            ResultSet result = targetCon.getDBConnection().executeQuery(sql);
            hasResult = result.next();
        }
        catch (Exception e) {
            logger.info((Object)("Condition '" + sql + "' returned '" + !expectSuccess + "', expected was '" + expectSuccess));
            return !expectSuccess;
        }
        boolean result = expectSuccess && hasResult || !expectSuccess && !hasResult;
        logger.info((Object)("Condition '" + sql + "' returned '" + result + "', expected was '" + expectSuccess));
        return result;
    }

    private void createCommandsForTime(List<? extends Node> statements, IDatabaseCommand.TIME time, JobStructure commandList, DatabaseInfos targetCon, boolean mayFail) {
        if (statements == null) {
            return;
        }
        ICommandFactory factory = targetCon.getCommandFactory();
        for (Node node : statements) {
            String sql;
            if (node.getName() != NodeFactory.TAG.sql || (sql = node.getContent()) == null || sql.trim().length() == 0) continue;
            commandList.add(factory.getPresetCommand(sql, true, time, mayFail, false));
        }
    }
}

