/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITableCommand;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.dbupdater.model.NodeReference;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.SQLException;
import java.util.List;

public class DefaultAddReferenceCommand
implements ITableCommand {
    private DatabaseInfos dbInfo;
    private final Node name;
    private String reference;
    private final String prefix;
    private String refName;
    private static Logger LOGGER = LogManager.getLogger((String)"DB Updater");

    public DefaultAddReferenceCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node name) {
        this.name = name;
        this.dbInfo = dbInfo;
        this.prefix = "ALTER TABLE " + ((ISchemaNode)((Object)name)).getSourceName(dbInfo);
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public String getSqlStatement() {
        return this.reference;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return action == ICommandFactory.COMMAND_TYPE.create && element != null && element.getName() == NodeFactory.TAG.reference && this.reference == null;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.addreferences;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        AttributeMap<String> attributes = element.getAttributeMap();
        String tabName = ((ISchemaNode)((Object)this.name)).getSourceName(this.dbInfo);
        if (!attributes.containsKey((Object)IDatabaseInfos.REFERENCE_PARAM.fk_name)) {
            throw new SQLException("Cannot create an unnamed reference in table " + tabName);
        }
        if (!attributes.containsKey((Object)IDatabaseInfos.REFERENCE_PARAM.fkcolumn_name)) {
            throw new SQLException("Cannot create an reference without a column in table " + tabName);
        }
        if (!attributes.containsKey((Object)IDatabaseInfos.REFERENCE_PARAM.pkcolumn_name)) {
            throw new SQLException("Cannot create an reference wihtout a referenced column in table " + tabName);
        }
        if (!attributes.containsKey((Object)IDatabaseInfos.REFERENCE_PARAM.pktable_name)) {
            throw new SQLException("Cannot create an reference without a referenced table in table " + tabName);
        }
        StringBuilder b = new StringBuilder();
        b.append(this.prefix);
        String fkName = this.dbInfo.getQuote(attributes.get((Object)IDatabaseInfos.REFERENCE_PARAM.fk_name));
        b.append(" ADD CONSTRAINT ").append(fkName);
        b.append(" FOREIGN KEY (").append(this.dbInfo.getQuote(attributes.get((Object)IDatabaseInfos.REFERENCE_PARAM.fkcolumn_name)));
        this.refName = this.dbInfo.getSchemaPrefix(this.name) + this.dbInfo.getQuote(attributes.get((Object)IDatabaseInfos.REFERENCE_PARAM.pktable_name));
        b.append(") REFERENCES ").append(this.refName);
        b.append(" (").append(this.dbInfo.getQuote(attributes.get((Object)IDatabaseInfos.REFERENCE_PARAM.pkcolumn_name)));
        b.append(")");
        b.append(this.getOnDeleteOnUpdate(element));
        this.reference = b.toString();
        return null;
    }

    public String getOnDeleteOnUpdate(Node referenceElement) {
        NodeReference.onChange action;
        StringBuilder b = new StringBuilder();
        if (referenceElement.isDefined(IDatabaseInfos.REFERENCE_PARAM.ondelete.name())) {
            String onDelete = referenceElement.getParameter(IDatabaseInfos.REFERENCE_PARAM.ondelete.name());
            try {
                action = NodeReference.onChange.valueOf(onDelete != null ? onDelete.toLowerCase() : "");
                b.append(this.dbInfo.getOnChangeDirective(IDatabaseInfos.REFERENCE_PARAM.ondelete, action));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)("Unknown reference 'onDelete' directive: " + onDelete));
            }
        }
        if (referenceElement.isDefined(IDatabaseInfos.REFERENCE_PARAM.onupdate.name())) {
            String onUpdate = referenceElement.getParameter(IDatabaseInfos.REFERENCE_PARAM.onupdate.name());
            try {
                action = NodeReference.onChange.valueOf(onUpdate != null ? onUpdate.toLowerCase() : "");
                b.append(this.dbInfo.getOnChangeDirective(IDatabaseInfos.REFERENCE_PARAM.onupdate, action));
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)("Unknown reference 'onUpdate' directive: " + onUpdate));
            }
        }
        return b.toString();
    }

    public String getRefName() {
        return this.refName;
    }
}

