/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.cache.internal.HardDiskExternalDataWriterFactory;
import com.inet.config.ConfigurationManager;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerInitializerStatus;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.utils.ClientScriptsWriter;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.veto.VetoManager;
import com.inet.plugin.veto.VetoPower;
import com.inet.plugin.veto.VetoSemaphore;
import com.inet.plugin.veto.VetoStatus;
import com.inet.plugin.veto.VetoType;
import com.inet.search.veto.UserSearchIndexVetoPower;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import srv.HdLicenseObserver;
import srv.ServerUtilities;

public class ServerInitializer
implements ServerInitializerStatus,
ServerPluginManagerListener,
VetoPower {
    private final VetoSemaphore dbConnectionVeto = new VetoSemaphore(ServerUtilities.hdsMessages);
    protected static ServerInitializer instance;
    protected boolean serverInterrupted;
    private boolean isConnectionInitted;

    protected ServerInitializer() {
        this.dbConnectionVeto.setStatusMessage("NoConnYet", new String[0]);
        this.dbConnectionVeto.setStatusPercentage(10);
    }

    public static ServerInitializer getInstance() {
        if (instance == null) {
            instance = new ServerInitializer();
        }
        return instance;
    }

    @Override
    public VetoStatus getCurrentVeto() {
        if (this.serverInterrupted) {
            return new VetoStatus(ServerUtilities.getLangMsg("ServerStopped", new Object[0]), 0);
        }
        VetoManager vetoManager = VetoManager.getInstance();
        if (!vetoManager.isCurrentlyVetoed()) {
            return null;
        }
        return vetoManager.getCurrentVeto();
    }

    @Override
    public void interruptExecution() {
        this.serverInterrupted = true;
    }

    public void start() {
        try {
            if (this.serverInterrupted) {
                return;
            }
            this.setPortNo();
        }
        catch (Throwable e) {
            HDLogger.error(e);
        }
        if (this.serverInterrupted) {
            return;
        }
        HDLogger.info("TCP/IP port: " + String.valueOf(ServerUtilities.GUI_PORT.get()) + "\n");
        this.dbConnectionVeto.setStatusPercentage(30);
        try {
            long freeSpace = HardDiskExternalDataWriterFactory.freeSpace((File)HardDiskExternalDataWriterFactory.getDefaultDir());
            if (freeSpace > 0L && freeSpace < 0x40000000L) {
                throw new IllegalStateException("Not enough free disk space. 1GB is minimum for hard disk cache. Current free space is: " + freeSpace + " Location: " + String.valueOf(HardDiskExternalDataWriterFactory.getDefaultDir()));
            }
        }
        catch (Throwable e) {
            HDLogger.error(e);
            ServerUtilities.serverInterface.errorExit(616, "Server start failed");
        }
    }

    public void vetoFinished(VetoType type) {
        if (type == null) {
            this.startAdditionalParts();
        } else if (type == UserSearchIndexVetoPower.TYPE) {
            HdLicenseObserver.addLicenseData(new Properties(), null);
        }
    }

    protected void startAdditionalParts() {
    }

    private void notifyConnectionListeners() {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        try {
            ConnectionFactory conFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
            try (Connection con = conFactory.getConnection();){
                HDLogger.debug("initialized connection factory with valid connection");
            }
        }
        catch (SQLException e) {
            HDLogger.error(e);
        }
        List listeners = spm.get(ConnectionCreationListener.class);
        for (ConnectionCreationListener l : listeners) {
            l.connectionCreated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean init() {
        int counter = 0;
        Connection con = null;
        boolean started = false;
        while (true) {
            try {
                ServerUtilities.systemOut(counter + 1 + ". Versuch eine Verbindung zur Datenbank aufzubauen.", null, "");
                ConnectionFactory cf = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                con = cf.getConnection("HDS");
                DatabaseMetaData dbmd = con.getMetaData();
                Statement st = null;
                ResultSet rs = null;
                try {
                    st = con.createStatement();
                    rs = st.executeQuery("SELECT * FROM tblOptionen");
                    rs.next();
                    int release = rs.getInt("Release");
                    HDLogger.debug("Release: " + release + " - 267");
                    if (release != 267) {
                        HDLogger.error("Error database version is incompatible to program version!");
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            st.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            con.close();
                            throw new IllegalStateException(ServerUtilities.getLangMsg("DienstNotInitDBMsg", new Object[0]));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw new IllegalStateException(ServerUtilities.getLangMsg("DienstNotInitDBMsg", new Object[0]));
                    }
                    HDLogger.info("Database:         " + dbmd.getDatabaseProductName() + "  " + dbmd.getDatabaseProductVersion());
                    HDLogger.info("Driver:           " + dbmd.getDriverName() + "  " + dbmd.getDriverVersion() + "\n");
                    started = true;
                    break;
                }
                catch (SQLException e) {
                    HDLogger.error(new HelpDeskServerException((Throwable)e, (ErrorCode)HelpDeskErrorCodes.SQL_CONNECTION_INIT_ERROR));
                    throw new IllegalStateException(ServerUtilities.getLangMsg("DienstNotInitDBMsg", new Object[0]));
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        st.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (Throwable e) {
                try {
                    ServerUtilities.systemOut(++counter + ". Aufbauversuch gescheitert.", new HelpDeskServerException(e, (ErrorCode)HelpDeskErrorCodes.SQL_CONNECTION_INIT_ERROR), "");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (instance == this) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            con.close();
            return started;
        }
        catch (Throwable throwable) {
            return started;
        }
    }

    private void setPortNo() {
        int listenerPort = (Integer)ServerUtilities.GUI_PORT.get();
        if (!ConfigurationManager.isRecoveryMode()) {
            ClientScriptsWriter.setClientPorts(String.valueOf(listenerPort));
        }
    }

    public VetoSemaphore checkForVeto() {
        if (this.serverInterrupted) {
            return null;
        }
        new Thread(() -> {
            block5: {
                try {
                    this.isConnectionInitted = this.init();
                    if (this.serverInterrupted) {
                        return;
                    }
                    if (!this.isConnectionInitted) break block5;
                    this.notifyConnectionListeners();
                    try {
                        this.dbConnectionVeto.setStatusPercentage(70);
                    }
                    catch (Throwable e) {
                        HDLogger.error(e);
                    }
                    this.dbConnectionVeto.setStatusPercentage(100);
                    this.dbConnectionVeto.complete(null);
                }
                catch (Throwable th) {
                    HDLogger.fatal("Critical error on server-start, database-veto still blocking:");
                    HDLogger.fatal(th);
                }
            }
        }, "HelpDesk Server Initializer").start();
        return this.dbConnectionVeto;
    }

    @Nonnull
    public VetoType getType() {
        return HelpdeskServerPlugin.HD_SERVER_START;
    }

    public boolean isConnectionInitialized() {
        return this.isConnectionInitted;
    }
}

