/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.extensions;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusManager;
import com.inet.helpdesk.core.ticketmanager.fields.status.StatusVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.Date;
import srv.controller.ticket.timeline.ResourceTimelineManager;

public class ReactivateTicketActionExtensionFactory
implements TicketActionExtensionFactory {
    @Override
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        if (action.getId() == -2) {
            return new ReactivateTicketActionExtension();
        }
        return null;
    }

    @Override
    public String checkActionPreconditions(TicketVO ticket, ActionVO action, TicketPermissionContext ticketPermissionInfo) {
        if (action.getId() == -2) {
            int ticketStatus = ticket.getStatusID();
            if (ticketStatus < 300 || ticketStatus >= 360 && ticketStatus <= 364) {
                String statusName = "?";
                StatusVO statusVO = (StatusVO)StatusManager.getInstance().get(ticketStatus);
                if (statusVO != null && !statusVO.isDeleted()) {
                    statusName = statusVO.getDisplayValue();
                }
                String statusID = "" + ticket.getStatusID();
                return Tickets.MSG.getMsg(Tickets.serverLocale(), "action.reactivate.wrongstatus", new Object[]{statusName, statusID});
            }
            boolean isDispatcher = ticketPermissionInfo.isDispatcher();
            if (ticketStatus >= 365 && ticketStatus <= 369 && !isDispatcher) {
                return Tickets.MSG.getMsg(Tickets.serverLocale(), "action.reactivate.onlydispatcher", new Object[0]);
            }
        }
        return null;
    }

    private class ReactivateTicketActionExtension
    implements TicketActionExtension {
        @Override
        public void extendTicketAction(ActionVO action, OperationChangedTicket opTicket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            TicketVO ticket = opTicket.getOldTicket().get();
            new ServerOptions();
            if (ServerOptions.isOptionSet(128)) {
                GUID resUUID;
                OperationChangedTicket ticketToUpdateDeadline = opTicket;
                TicketVO ticketWithDeadline = ticket;
                if (ticket.isSlaveInBundle()) {
                    ticketToUpdateDeadline = opTicket.getParentModel().changeExistingTicket(ticket.getBundleID());
                    ticketWithDeadline = ticketToUpdateDeadline.getOldTicket().get();
                }
                if (ticketWithDeadline.getDeadline() != null && (resUUID = ticketWithDeadline.getResourceID()) != null) {
                    UserGroupInfo res = UserGroupManager.getInstance().getGroup(resUUID);
                    if (res == null) {
                        HDLogger.error(new Throwable("User Group representing resource with ID =\"" + String.valueOf(resUUID) + "\" could not be found."));
                    } else {
                        int resIntID = (Integer)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
                        ResourceTimelineManager rtm = ResourceTimelineManager.getInstance();
                        Date deadlineTime = rtm.calcDeadline(resIntID, ticketWithDeadline.getPriorityID());
                        Long newDeadline = deadlineTime != null ? Long.valueOf(deadlineTime.getTime()) : null;
                        ticketToUpdateDeadline.getNewTicketData().put(Tickets.FIELD_DEADLINE, newDeadline);
                    }
                }
            }
            if (StringFunctions.isEmpty((String)reaStep.getFields().get(ReaStepVO.FIELD_DESC))) {
                String oldStatusName = ((StatusVO)StatusManager.getInstance().get(ticket.getStatusID())).getDisplayValue();
                reaStep.getFields().put(ReaStepVO.FIELD_DESC, Tickets.MSG.getMsg(Tickets.serverLocale(), "action.reactivate", new Object[]{oldStatusName}));
            }
        }
    }
}

