/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.dbupdater.UpdaterCore;
import com.inet.dbupdater.UpdaterListener;
import com.inet.dbupdater.data.StateDescription;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.DatabaseInfosMariaDB;
import com.inet.dbupdater.databases.DatabaseInfosMsSQL;
import com.inet.dbupdater.databases.DatabaseInfosMySQL;
import com.inet.dbupdater.databases.DatabaseInfosOracle;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.DBUpdateBackdoor;
import com.inet.lib.io.SupplierWithIOException;
import com.inet.lib.json.Json;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DBUpdateComponent
implements DBUpdateBackdoor {
    @Override
    public void updateDB(DatabaseConfigInfo sourceInfo, String systemUser, String systemPassword, UpdaterListener ulistener, List<SupplierWithIOException<InputStream>> pluginStructures) throws SQLException {
        this.updateorMigrateDBWithDefaultStructure(sourceInfo, null, systemUser, systemPassword, ulistener, pluginStructures);
    }

    @Override
    public void updateDB(DatabaseConfigInfo sourceInfo, Class<? extends ServerPlugin> rootPlugin, String systemUser, String systemPassword, UpdaterListener ulistener) throws SQLException {
        this.updateorMigrateDB(sourceInfo, null, (SupplierWithIOException<InputStream>)((SupplierWithIOException)() -> rootPlugin.getResource("setup/databasestructure.xml").openStream()), systemUser, systemPassword, ulistener, new ArrayList<SupplierWithIOException<InputStream>>());
    }

    @Override
    public void migrateDB(DatabaseConfigInfo sourceInfo, DatabaseConfigInfo targetInfo, String systemUser, String systemPassword, UpdaterListener ulistener, List<SupplierWithIOException<InputStream>> pluginStructures) throws SQLException {
        this.updateorMigrateDBWithDefaultStructure(sourceInfo, targetInfo, systemUser, systemPassword, ulistener, pluginStructures);
    }

    private void updateorMigrateDBWithDefaultStructure(DatabaseConfigInfo sourceInfo, DatabaseConfigInfo targetInfo, String systemUser, String systemPassword, UpdaterListener ulistener, List<SupplierWithIOException<InputStream>> pluginStructures) throws SQLException {
        this.updateorMigrateDB(sourceInfo, targetInfo, (SupplierWithIOException<InputStream>)((SupplierWithIOException)() -> this.getClass().getClassLoader().getResource("cmd/installHD71.xml").openStream()), systemUser, systemPassword, ulistener, pluginStructures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateorMigrateDB(DatabaseConfigInfo sourceInfo, DatabaseConfigInfo targetInfo, SupplierWithIOException<InputStream> structureData, String systemUser, String systemPassword, UpdaterListener ulistener, List<SupplierWithIOException<InputStream>> pluginStructures) throws SQLException {
        String url = sourceInfo.getUrl();
        String user = sourceInfo.getUser();
        String pwd = sourceInfo.getDecodedPassword();
        if (user == null) {
            user = "";
        }
        if (pwd == null) {
            pwd = "";
        }
        Connection dbCon = null;
        try {
            StateDescription targetState;
            StateDescription currentDB;
            try {
                ConnectionFactory cf = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                dbCon = cf.getConnection(url, pwd, user, sourceInfo.getDriverClassName(), "HDS");
                HDLogger.info("Db Update: source info " + (sourceInfo == null ? "null" : new Json().toJson((Object)sourceInfo)));
                HDLogger.info("Db Update: target info " + (targetInfo == null ? "null" : new Json().toJson((Object)targetInfo)));
                HDLogger.info("Db Update: got connection @ url " + url);
                currentDB = this.createCurrentStateDescription(sourceInfo, dbCon, null);
            }
            catch (SQLException sql) {
                String accountPassword;
                String accountUser;
                String jdbcPassword;
                String jdbcUser;
                HDLogger.info("Db Update: did not get connection @ url " + url + "...doesn't exist yet or is not valid");
                if (systemUser == null || systemUser.isEmpty() || systemPassword == null) {
                    if (DatabaseConfigInfo.DatabaseType.inetora.equals((Object)sourceInfo.getDriver())) {
                        throw sql;
                    }
                    jdbcUser = user;
                    jdbcPassword = pwd;
                    accountUser = null;
                    accountPassword = null;
                } else {
                    jdbcUser = systemUser;
                    jdbcPassword = systemPassword;
                    accountUser = user;
                    accountPassword = pwd;
                }
                String catalog = DatabaseConfigInfo.DatabaseType.inetora.equals((Object)sourceInfo.getDriver()) ? sourceInfo.getUser() : sourceInfo.getCatalogForConnection();
                currentDB = new StateDescription(catalog, sourceInfo.getDriverClassName(), jdbcUser, jdbcPassword, sourceInfo.getUrlWithoutDB(), null, null, accountUser, accountPassword);
            }
            if (structureData == null) {
                throw new IllegalStateException("DB-Update: missing primary database structure script");
            }
            if (targetInfo == null) {
                targetState = new StateDescription(null, null, null, null, null, structureData, null, null, null);
            } else {
                String accountPassword;
                String accountUser;
                String jdbcPassword;
                String jdbcUser;
                String catalog;
                String string = catalog = DatabaseConfigInfo.DatabaseType.inetora.equals((Object)targetInfo.getDriver()) ? targetInfo.getUser() : targetInfo.getCatalogForConnection();
                if (systemUser == null || systemUser.isEmpty()) {
                    jdbcUser = targetInfo.getUser();
                    jdbcPassword = targetInfo.getDecodedPassword();
                    accountUser = null;
                    accountPassword = null;
                } else {
                    jdbcUser = systemUser;
                    jdbcPassword = systemPassword == null ? "" : systemPassword;
                    accountUser = targetInfo.getUser();
                    accountPassword = targetInfo.getDecodedPassword();
                }
                targetState = new StateDescription(catalog, targetInfo.getDriverClassName(), jdbcUser, jdbcPassword, targetInfo.getUrlWithoutDB(), structureData, null, accountUser, accountPassword);
            }
            pluginStructures.forEach(s -> targetState.addSourceSupplier((SupplierWithIOException<InputStream>)s));
            UpdaterCore updater = new UpdaterCore(currentDB, targetState);
            if (ulistener != null) {
                updater.addUpdaterListener(ulistener);
            }
            updater.prepare();
            HDLogger.info("Db Update: executing");
            boolean success = updater.execute();
            HDLogger.info("Db Update: " + (success ? "success" : "FAILED"));
            if (!success) {
                List<Exception> ex = updater.getCatchedExceptions();
                if (ex != null && !ex.isEmpty()) {
                    throw new SQLException(ex.get(0));
                }
                throw new SQLException("Db Update failed");
            }
        }
        finally {
            if (dbCon != null) {
                try {
                    dbCon.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private StateDescription createCurrentStateDescription(DatabaseConfigInfo dbInfo, Connection dbCon, File modelFile) {
        DBConnection connectionInfo = new DBConnection(dbCon);
        DatabaseConfigInfo.DatabaseType driver = dbInfo.getDriver();
        connectionInfo.setDatabaseName(DatabaseConfigInfo.DatabaseType.inetora.equals((Object)driver) ? dbInfo.getUser() : dbInfo.getCatalogForConnection());
        connectionInfo.setJdbcDriverClass(null);
        connectionInfo.setJdbcPassword(dbInfo.getDecodedPassword());
        connectionInfo.setJdbcUrl(dbInfo.getUrl());
        connectionInfo.setJdbcUser(dbInfo.getUser());
        DatabaseInfos dbInfos = switch (driver) {
            case DatabaseConfigInfo.DatabaseType.mysql -> new DatabaseInfosMySQL(connectionInfo);
            case DatabaseConfigInfo.DatabaseType.mariadb -> new DatabaseInfosMariaDB(connectionInfo);
            case DatabaseConfigInfo.DatabaseType.inetora -> new DatabaseInfosOracle(connectionInfo);
            case DatabaseConfigInfo.DatabaseType.inetdae7 -> new DatabaseInfosMsSQL(connectionInfo);
            default -> new DatabaseInfos(connectionInfo);
        };
        StateDescription currentDB = modelFile == null ? new StateDescription(dbInfos) : new StateDescription(dbInfos, modelFile);
        return currentDB;
    }
}

