/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.operation;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationAfterWriteAction;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface OperationChangedTicket {
    public void remove(OperationNewReaStep var1);

    public int getTicketId();

    @Nonnull
    public TicketOperationModel getParentModel();

    public <X> X getAttributeValue(TicketAttribute<X> var1);

    public <X> X getFieldValue(TicketField<X> var1);

    public boolean isNew();

    public Optional<TicketVO> getOldTicket();

    public List<OperationAfterWriteAction> getAfterWriteOperations();

    public OperationChangedReaStep changeReaStep(int var1, MutableReaStepText var2);

    public OperationChangedReaStep changeReaStep(int var1);

    public List<OperationChangedReaStep> getChangedReaSteps();

    public OperationNewReaStep addReaStep(@Nonnull MutableReaStepAttributes var1, @Nonnull MutableReaStepData var2, @Nullable MutableReaStepText var3);

    public OperationNewReaStep addReaStep(int var1, @Nonnull MutableReaStepData var2, @Nullable MutableReaStepText var3);

    public List<OperationNewReaStep> getAddedReaSteps();

    public MutableTicketAttributes getNewTicketAttributes();

    public MutableTicketData getNewTicketData();

    public void createFieldChangeReaStepsIfNeeded(MutableReaStepData var1);

    default public TicketVO createIntermediateTicketVO() {
        if (this.isNew()) {
            return TicketVOSingle.create(this.getTicketId(), this.getNewTicketAttributes(), this.getNewTicketData());
        }
        TicketVO oldTicket = this.getOldTicket().get();
        if (this.getNewTicketAttributes().isEmpty() && this.getNewTicketData().isEmpty()) {
            return oldTicket;
        }
        MutableTicketData updatedFields = new MutableTicketData();
        oldTicket.getIncludedFields().stream().forEach(field -> updatedFields.put(field, oldTicket.getValue(field)));
        updatedFields.putAll(this.getNewTicketData());
        MutableTicketAttributes updatedAttributes = new MutableTicketAttributes();
        oldTicket.getIncludedAttributes().stream().forEach(att -> updatedAttributes.put(att, oldTicket.getAttribute(att)));
        updatedAttributes.putAll(this.getNewTicketAttributes());
        return TicketVOSingle.create(this.getTicketId(), updatedAttributes, updatedFields);
    }

    default public ReaStepTextVO createIntermediateInitialReaStepTextVO() {
        Integer initialId = this.getAttributeValue(Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID);
        if (initialId == null) {
            throw new IllegalStateException("Cannot call this method before adding the initial reaStep with text!");
        }
        if (this.isNew()) {
            OperationNewReaStep initStep = this.getAddedReaSteps().get(0);
            if (initialId.intValue() != initStep.getReaStepId()) {
                throw new IllegalStateException("initial reaId is wrong: " + initialId + " vs " + initStep.getReaStepId());
            }
            return initStep.getText().toVO();
        }
        Optional<OperationChangedReaStep> changedInitStep = this.getChangedReaSteps().stream().filter(ocrs -> ocrs.getReaStepId() == initialId.intValue()).findFirst();
        if (changedInitStep.isPresent() && changedInitStep.get().getText() != null) {
            return changedInitStep.get().getText().toVO();
        }
        return TicketManager.getReaderForSystem().getReaStepText(initialId);
    }
}

