/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.resource;

import com.inet.helpdesk.core.ticketmanager.fields.Deletable;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;

public class ResourceVO
extends FieldVO
implements Deletable {
    private int ParentRes;
    private String ResBezeichnung;
    private String Email;
    private boolean geloescht;
    private int Eskalation;
    private double Stundensatz;
    private int Msg;
    private long Rechte;

    public ResourceVO(int id, String name) {
        super(id);
        this.ResBezeichnung = name;
    }

    public ResourceVO(int id, String name, int parentResourceID, String email, int escalationResourceID, double hourlyRate, int message, long permissions, boolean deleted) {
        super(id);
        this.ResBezeichnung = name;
        this.ParentRes = parentResourceID;
        this.Email = email;
        this.Eskalation = escalationResourceID;
        this.Stundensatz = hourlyRate;
        this.Msg = message;
        this.Rechte = permissions;
        this.geloescht = deleted;
    }

    private ResourceVO() {
    }

    @Override
    public boolean isDeleted() {
        return this.geloescht;
    }

    @Override
    public String getDisplayValue() {
        return this.ResBezeichnung;
    }

    public String getEmail() {
        return this.Email;
    }

    public int getParentID() {
        return this.ParentRes;
    }

    public int getEscalationID() {
        return this.Eskalation;
    }

    public int getMsg() {
        return this.Msg;
    }

    public double getHourlyRate() {
        return this.Stundensatz;
    }

    public long getPermissionFlags() {
        return this.Rechte;
    }

    @Override
    public String toString() {
        return "ResourceVO(" + super.toString() + " [ParentRes=" + this.ParentRes + ", ResBezeichnung=" + this.ResBezeichnung + ", Email=" + this.Email + ", geloescht=" + this.geloescht + ", Eskalation=" + this.Eskalation + ", Stundensatz=" + this.Stundensatz + ", Msg=" + this.Msg + ", Rechte=" + this.Rechte + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.Email == null ? 0 : this.Email.hashCode());
        result = 31 * result + this.Eskalation;
        result = 31 * result + this.Msg;
        result = 31 * result + this.ParentRes;
        result = 31 * result + (int)(this.Rechte ^ this.Rechte >>> 32);
        result = 31 * result + (this.ResBezeichnung == null ? 0 : this.ResBezeichnung.hashCode());
        long temp = Double.doubleToLongBits(this.Stundensatz);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.geloescht ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceVO other = (ResourceVO)obj;
        if (this.Email == null ? other.Email != null : !this.Email.equals(other.Email)) {
            return false;
        }
        if (this.Eskalation != other.Eskalation) {
            return false;
        }
        if (this.Msg != other.Msg) {
            return false;
        }
        if (this.ParentRes != other.ParentRes) {
            return false;
        }
        if (this.Rechte != other.Rechte) {
            return false;
        }
        if (this.ResBezeichnung == null ? other.ResBezeichnung != null : !this.ResBezeichnung.equals(other.ResBezeichnung)) {
            return false;
        }
        if (Double.doubleToLongBits(this.Stundensatz) != Double.doubleToLongBits(other.Stundensatz)) {
            return false;
        }
        return this.geloescht == other.geloescht;
    }
}

