/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.annotations.InternalApi;
import com.inet.field.Field;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionHDCore;
import com.inet.lib.util.StringFunctions;
import java.net.URL;
import javax.annotation.Nullable;

@InternalApi
public abstract class AbstractTicketFieldDefinitionWithGenericFieldsManager
extends TicketFieldDefinition
implements TicketFieldDefinitionHDCore {
    private GenericFieldsManager<?> fieldsManager;
    private Field<Integer> fieldInstance;

    public AbstractTicketFieldDefinitionWithGenericFieldsManager(TicketAttribute<Integer> fieldInstance, GenericFieldsManager<?> fieldsManager, int prio) {
        super(fieldInstance, true, true, prio);
        this.fieldInstance = fieldInstance;
        this.fieldsManager = fieldsManager;
    }

    public AbstractTicketFieldDefinitionWithGenericFieldsManager(TicketField<Integer> fieldInstance, GenericFieldsManager<?> fieldsManager, int prio) {
        super(fieldInstance, true, true, prio);
        this.fieldInstance = fieldInstance;
        this.fieldsManager = fieldsManager;
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        Integer value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        if (this.fieldInstance instanceof TicketField) {
            return ((TicketField)this.fieldInstance).valueToString(value);
        }
        Object entry = this.fieldsManager.get(value);
        if (entry == null) {
            return null;
        }
        return ((FieldVO)entry).getDisplayValue();
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        Integer value = ticket.getFieldOrAttributeValue(this.fieldInstance);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if (StringFunctions.isEmpty((String)valueAsString)) {
            return null;
        }
        return this.fieldsManager.getIcon(Integer.parseInt(valueAsString), size);
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation(this.fieldInstance.getKey(), sortGroupKey -> {
            Object entry = this.fieldsManager.get(Integer.parseInt(sortGroupKey));
            String displayName = null;
            boolean iconAvailable = false;
            if (entry != null && !StringFunctions.isEmpty((String)((FieldVO)entry).getDisplayValue())) {
                displayName = ((FieldVO)entry).getDisplayValue();
                iconAvailable = true;
            } else {
                displayName = Tickets.MSG.getMsg("value.unset", new Object[0]);
            }
            String iconKey = sortGroupKey;
            return new SortGroup(displayName, iconAvailable, iconKey);
        });
    }

    @Override
    public String getLabel() {
        return this.fieldInstance.getLabel();
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return FieldSettingsType.TYPE_SELECT;
    }

    public TicketField<Integer> getField() {
        if (!(this.fieldInstance instanceof TicketField)) {
            throw new IllegalStateException(this.getKey());
        }
        return (TicketField)this.fieldInstance;
    }

    @Nullable
    protected Integer defaultValue() {
        return (Integer)this.fieldInstance.getDefaultValue();
    }
}

