/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.reporting.server.dataview;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.reporting.HDReporting;
import com.inet.helpdesk.core.reporting.server.datasource.ITicketDataSourceConfiguration;
import com.inet.helpdesk.core.reporting.server.dataview.TemplateDataViewDefaultsHD;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FieldElement;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.adhoc.server.api.datasource.DataSourceUtils;
import com.inet.report.adhoc.server.api.datasource.DataViewConditions;
import com.inet.report.adhoc.server.api.datasource.UserDataSourceConfiguration;
import com.inet.report.adhoc.server.api.dataview.DataFilter;
import com.inet.report.adhoc.server.api.dataview.DataView;
import com.inet.report.adhoc.server.api.dataview.SimpleDataView;
import com.inet.report.adhoc.server.api.dataview.TemplateDataViewDefaults;
import com.inet.report.adhoc.server.api.dataview.user.DataView_Users;
import com.inet.report.adhoc.server.api.renderer.AbstractFormatableColumn;
import com.inet.report.adhoc.server.api.renderer.GroupData;
import com.inet.report.adhoc.server.api.renderer.RendererPropertyKey;
import com.inet.report.adhoc.server.api.renderer.table.TableColumnData;
import com.inet.report.adhoc.server.api.renderer.table.TableSortingData;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DataFactory;
import com.inet.search.SearchTag;
import com.inet.search.SuggestedValuesFilter;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class DataView_TicketsWithUser
extends TemplateDataViewDefaultsHD {
    private static final String COLUMN_TICKET_TEXT_FULL = "TicketAdhoc.ticketText";
    private static final String COLUMN_PRIO_FULL = "TicketAdhoc.priorityid";

    @Nonnull
    public @Nonnull List<// Could not load outer class - annotation placement on inner may be incorrect
     @Nonnull TemplateDataViewDefaults.Column> getAvailableColumns() {
        DataSourceConfiguration configuration = DataSourceConfigurationManager.getDataSource((String)"HelpDeskTickets");
        if (configuration == null) {
            throw new IllegalStateException("Datasource HelpDeskTickets is missing");
        }
        try {
            Engine engine = RDC.createEmptyEngine((String)"java");
            return this.getFields(engine);
        }
        catch (ReportException ex) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)ex);
        }
    }

    @Nullable
    public <T> T get(@Nonnull RendererPropertyKey<T> key) {
        if (key == TABLE_COLUMNS) {
            return (T)this.getPreselectedColumns().toArray(new TableColumnData[0]);
        }
        if (key == TABLE_SORTING) {
            return (T)this.getPreselectedSorting().toArray(new TableSortingData[0]);
        }
        if (key == TABLE_GROUPS) {
            return (T)this.getPreselectedGrouping().toArray(new GroupData[0]);
        }
        if (key == FILTER_DEFINITION) {
            return (T)this.getPreselectedFilter();
        }
        return null;
    }

    @Nonnull
    protected List<GroupData> getPreselectedGrouping() {
        return List.of();
    }

    protected static boolean ticketFieldIsVisible(String column) {
        TicketFieldDefinition def = Tickets.getFieldDefinitionByKey(column);
        if (def == null) {
            return true;
        }
        return def.isAvailable();
    }

    @Nonnull
    protected List<TableColumnData> getPreselectedColumns() {
        ArrayList<TableColumnData> list = new ArrayList<TableColumnData>();
        if (DataView_TicketsWithUser.ticketFieldIsVisible(Tickets.ATTRIBUTE_TICKET_ID.getKey())) {
            list.add(new TableColumnData("TicketAdhoc." + Tickets.ATTRIBUTE_TICKET_ID.getKey(), AbstractFormatableColumn.ValueFormat.NUMBER_FORMAT_INTEGER, List.of()));
        }
        if (DataView_TicketsWithUser.ticketFieldIsVisible(Tickets.ATTRIBUTE_INQUIRY_DATE.getKey())) {
            list.add(new TableColumnData("TicketAdhoc." + Tickets.ATTRIBUTE_INQUIRY_DATE.getKey(), AbstractFormatableColumn.ValueFormat.DATE_FORMAT_MEDIUM, List.of()));
        }
        if (DataView_TicketsWithUser.ticketFieldIsVisible(Tickets.FIELD_SUBJECT.getKey())) {
            list.add(new TableColumnData("TicketAdhoc." + Tickets.FIELD_SUBJECT.getKey()));
        }
        if (DataView_TicketsWithUser.ticketFieldIsVisible(Tickets.FIELD_CATEGORY_ID.getKey())) {
            list.add(new TableColumnData("TicketAdhoc." + Tickets.FIELD_CATEGORY_ID.getKey()));
        }
        if (DataView_TicketsWithUser.ticketFieldIsVisible(Tickets.FIELD_OWNER_GUID.getKey())) {
            list.add(new TableColumnData("TicketAdhoc." + Tickets.FIELD_OWNER_GUID.getKey()));
        }
        if (DataSourceUtils.userFieldIsVisible((UserField)UsersAndGroups.FIELD_EMAIL)) {
            list.add(new TableColumnData("UserAdhoc." + UsersAndGroups.FIELD_EMAIL.getKey()));
        }
        return list;
    }

    @Nullable
    public DataFilter getPreselectedFilter() {
        return null;
    }

    @Nonnull
    protected List<TableSortingData> getPreselectedSorting() {
        ArrayList<TableSortingData> list = new ArrayList<TableSortingData>();
        if (DataView_TicketsWithUser.ticketFieldIsVisible(Tickets.ATTRIBUTE_TICKET_ID.getKey())) {
            list.add(new TableSortingData("TicketAdhoc." + Tickets.ATTRIBUTE_TICKET_ID.getKey(), true));
        }
        return list;
    }

    @Nonnull
    protected @Nonnull List<// Could not load outer class - annotation placement on inner may be incorrect
     @Nonnull TemplateDataViewDefaults.Column> getFields(@Nonnull Engine engine) throws ReportException {
        DataSourceUtils.ColumnInfoWithLabel column;
        int dataType;
        String name;
        DataSourceConfiguration ticketSourceCfg = DataSourceConfigurationManager.getDataSource((String)"HelpDeskTickets");
        if (ticketSourceCfg == null) {
            throw new IllegalStateException("Datasource HelpDeskTickets is missing");
        }
        DataSourceConfiguration userSourceCfg = DataSourceConfigurationManager.getDataSource((String)"Users");
        if (userSourceCfg == null) {
            throw new IllegalStateException("Datasource Users is missing");
        }
        DatabaseTables dbTables = engine.getDatabaseTables();
        Datasource ticketSource = dbTables.getDatasource(0);
        ticketSource.setDataSourceConfiguration(ticketSourceCfg);
        Datasource userSource = dbTables.createDatasource("");
        userSource.setDataSourceConfiguration(userSourceCfg);
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
         @Nonnull TemplateDataViewDefaults.Column> dataFields = new ArrayList<TemplateDataViewDefaults.Column>();
        DataFactory dataFactory = ticketSource.getDataFactory();
        TableSource ts = ticketSource.createTableSource("TicketAdhoc");
        List columns = dataFactory.getColumns(ts);
        String alias = ts.getAlias() + ".";
        block8: for (ColumnInfo col : columns) {
            name = col.getName();
            dataType = col.getDataType();
            ts.addColumn(name, dataType);
            switch (name) {
                case "ticketTextIsHtml": 
                case "ticketownerid": 
                case "priorityidValue": {
                    continue block8;
                }
            }
            if (col.getColumnType() != 3) continue;
            column = (DataSourceUtils.ColumnInfoWithLabel)col;
            dataFields.add(new TemplateDataViewDefaults.Column(alias + name, column.getLabel(), dataType));
        }
        dataFactory = userSource.getDataFactory();
        ts = userSource.createTableSource("UserAdhoc");
        columns = dataFactory.getColumns(ts);
        alias = ts.getAlias() + ".";
        for (ColumnInfo col : columns) {
            name = col.getName();
            dataType = col.getDataType();
            ts.addColumn(name, dataType);
            if (col.getColumnType() != 3) continue;
            column = (DataSourceUtils.ColumnInfoWithLabel)col;
            dataFields.add(new TemplateDataViewDefaults.Column(alias + name, column.getLabel(), dataType));
        }
        return dataFields;
    }

    @Nonnull
    public DataView createDataView(@Nonnull Engine engine, @Nullable DataFilter filter) {
        try {
            List<// Could not load outer class - annotation placement on inner may be incorrect
             @Nonnull TemplateDataViewDefaults.Column> dataFields = this.getFields(engine);
            DatabaseTables dbTables = engine.getDatabaseTables();
            TableSource fromTS = dbTables.getTablesource("TicketAdhoc");
            DatabaseField fromField = fromTS.getDatabaseField("ticketownerid");
            TableSource toTS = dbTables.getTablesource("UserAdhoc");
            DatabaseField toField = toTS.getDatabaseField("userGUID");
            if (this.filterContainsUserFilters(filter)) {
                dbTables.addJoin(fromTS, fromField, toTS, toField, 21, 1);
            } else {
                dbTables.addJoin(fromTS, fromField, toTS, toField, 23, 1);
            }
            this.setSearchPhrasePrompt(engine, filter);
            this.setSelectionFormula(engine, filter);
            return new SimpleDataView(dataFields, engine);
        }
        catch (ReportException ex) {
            throw (RuntimeException)ErrorCode.throwAny((Throwable)ex);
        }
    }

    private boolean filterContainsUserFilters(@Nullable DataFilter filter) {
        if (filter == null) {
            return false;
        }
        for (List len : filter.getFilterLists()) {
            for (DataFilter.DataFilterEntry en : len) {
                if (!en.getColumnKey().startsWith("UserAdhoc")) continue;
                switch (en.getOperation()) {
                    case equals: 
                    case contains: 
                    case endswith: 
                    case greaterthan: 
                    case greaterthanequals: 
                    case inrange: 
                    case lessthan: 
                    case lessthanequals: 
                    case startswith: {
                        return !StringFunctions.isEmpty((String)en.getValue());
                    }
                    case notcontains: 
                    case notequals: 
                    case notendswith: 
                    case notinrange: 
                    case notstartswith: {
                        return StringFunctions.isEmpty((String)en.getValue());
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void setSearchPhrasePrompt(@Nonnull Engine engine, @Nullable DataFilter filter) throws ReportException {
        DataFilter filterForIndex;
        DataFilter dataFilter = filterForIndex = filter == null ? new DataFilter(new ArrayList()) : (DataFilter)new Json().fromJson(new Json().toJson((Object)filter), DataFilter.class);
        if (filter != null) {
            DataViewConditions wrapperToRemoveConditionsUsedByIndex = new DataViewConditions(filter, List.of());
            ITicketDataSourceConfiguration.buildSearchPhraseForTicketTable(wrapperToRemoveConditionsUsedByIndex, "TicketAdhoc", HDReporting.joinTokenInfoForTicketTable());
            UserDataSourceConfiguration.buildSearchExpressionFromFilter((DataViewConditions)wrapperToRemoveConditionsUsedByIndex);
        }
        List<DataFilter.DataFilterEntry> templateSpecificConditions = this.getTemplateSpecificConditions();
        DataViewConditions dataViewConditions = new DataViewConditions(filterForIndex, templateSpecificConditions);
        String json = new Json().toJson((Object)dataViewConditions);
        TableSource ticketSource = engine.getDatabaseTables().getTablesource("TicketAdhoc");
        DataSourceUtils.setInputParameter((TableSource)ticketSource, (String)"TicketSearchPhrase", (String)json);
        TableSource userSource = engine.getDatabaseTables().getTablesource("UserAdhoc");
        DataSourceUtils.setInputParameter((TableSource)userSource, (String)"UserSearchPhrase", (String)json);
    }

    protected abstract List<DataFilter.DataFilterEntry> getTemplateSpecificConditions();

    public void applySpecialFormat(@Nonnull FieldElement el) throws ReportException {
        Field field = el.getField();
        if (COLUMN_TICKET_TEXT_FULL.equals(field.getName())) {
            Fields fields = el.getEngine().getFields();
            FormulaField formula = fields.addFormulaField("", "IIF( {TicketAdhoc.ticketTextIsHtml}, advancedHtmlText, uninterpretedText )", 3);
            el.setTextInterpretationFormula(formula);
            formula = fields.addFormulaField("", "getUrlPrefixString();", 3);
            el.setBaseUrlFormula(formula);
        }
    }

    @Nullable
    public String getSortField(@Nonnull String name) {
        return switch (name) {
            case COLUMN_PRIO_FULL -> "TicketAdhoc.priorityidValue";
            default -> null;
        };
    }

    @Nullable
    public List<LocalizedKey> getFilterSuggestions(@Nonnull Engine engine, @Nonnull String filterColumn, @Nonnull String filterText) {
        if (filterColumn.startsWith("TicketAdhoc")) {
            String key = filterColumn.substring("TicketAdhoc".length() + 1);
            return DataView_TicketsWithUser.getFilterSuggestionsForTickets(key, filterText);
        }
        if (filterColumn.startsWith("UserAdhoc")) {
            return DataView_Users.getSuggestedValuesForUserColumn((String)filterColumn, (String)filterText);
        }
        return List.of();
    }

    public static List<LocalizedKey> getFilterSuggestionsForTickets(String key, String filterText) {
        if (DataView_TicketsWithUser.ticketFieldIsVisible(key)) {
            TicketFieldDefinition def = Tickets.getFieldDefinitionByKey(key);
            FieldEditDefinition editDefinition = def.getEditDefinition();
            if (!(editDefinition instanceof SelectEditDefinition)) {
                Object term = def.getLabel() + ":" + filterText;
                term = ((String)term).trim();
                if (def.getFieldKey().equals(Tickets.FIELD_OWNER_GUID.getKey())) {
                    String displayName = UserManager.getInstance().getSearchEngine().getTag("useraccountdisplayname").getDisplayName();
                    term = displayName + "-(" + def.getLabel() + "):" + filterText;
                } else {
                    TicketField ticketField = Tickets.getFieldByKey(key);
                    if (ticketField != null && !ticketField.getSearchTag().isSuggestedTag()) {
                        Iterator valuesIterator = TicketManager.getReader().getSearchEngine().createValuesIterator(ticketField.getSearchTag(), true);
                        ArrayList<LocalizedKey> result = new ArrayList<LocalizedKey>();
                        while (result.size() < 50 && valuesIterator.hasNext()) {
                            String val;
                            String next = (String)valuesIterator.next();
                            String string = val = next == null ? "" : next.toString();
                            if (!val.toLowerCase().startsWith(filterText)) continue;
                            result.add(new LocalizedKey(val, val));
                        }
                        return result;
                    }
                }
                final IndexSearchEngine<Integer> searchEngine = TicketManager.getReader().getSearchEngine();
                final boolean isSupporter = HDUsersAndGroups.isSupporter();
                final GUID accountId = UserManager.getInstance().getCurrentUserAccountID();
                SuggestedValuesFilter<Integer> filter = new SuggestedValuesFilter<Integer>(){

                    public Collection<SearchTag> getSearchTags() {
                        Set fieldIdsVisible = Tickets.getFieldsVisibleForUser().stream().map(TicketFieldDefinition::getKey).collect(Collectors.toCollection(HashSet::new));
                        if (fieldIdsVisible.contains(Tickets.FIELD_ITIL_ID.getKey())) {
                            fieldIdsVisible.add("itilLinks");
                        }
                        if (isSupporter) {
                            fieldIdsVisible.add("attachmentnames");
                            fieldIdsVisible.add("bundleslave");
                        }
                        Set<SearchTag> tags = searchEngine.getTags();
                        tags = tags.stream().filter(tag -> fieldIdsVisible.contains(tag.getTag())).collect(Collectors.toSet());
                        return tags;
                    }

                    public Collection<TokenMatcher<Integer>> getTokenMatchers() {
                        if (isSupporter) {
                            return null;
                        }
                        return Collections.emptySet();
                    }

                    @Nonnull
                    public Predicate<Integer> getCondition() {
                        return new Predicate<Integer>(){
                            private Collection<Integer> tickets;
                            private boolean canSeeAll = false;

                            @Override
                            public boolean test(Integer t) {
                                if (this.canSeeAll) {
                                    return true;
                                }
                                if (this.tickets == null) {
                                    SearchExpression globalSearchExpressionForAllVisibleTickets = TicketManager.getReader().getGlobalSearchExpressionForAllVisibleTickets(accountId, ClientLocale.getThreadLocale());
                                    if (globalSearchExpressionForAllVisibleTickets == null) {
                                        this.canSeeAll = true;
                                        return true;
                                    }
                                    this.tickets = searchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{globalSearchExpressionForAllVisibleTickets}));
                                }
                                return this.tickets.contains(t);
                            }
                        };
                    }

                    public int getMaxValues() {
                        return 100;
                    }
                };
                List suggestions = searchEngine.getSuggestedValues((String)term, (SuggestedValuesFilter)filter);
                return suggestions.stream().map(sv -> new LocalizedKey(sv.getDisplayName(), sv.getDisplayName())).toList();
            }
            if (filterText.isEmpty()) {
                filterText = null;
            }
            List options = ((SelectEditDefinition)editDefinition).getSelectOptions(List.of(), filterText, 100, 0).getOptions();
            return DataSourceUtils.selectOptionsToLocalizedKeys((List)options, (String)key);
        }
        return List.of();
    }
}

