/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.jobrunner.jobs;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.jobrunner.JobStructure;
import com.inet.dbupdater.jobrunner.jobs.IJob;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.SQLException;

public class JobCreateTable
implements IJob {
    @Override
    public JobStructure createCommands(DatabaseInfos targetCon, Node model) {
        if (model.getName() != NodeFactory.TAG.table) {
            throw new IllegalArgumentException("The JobCreateTable can be used only for tables!");
        }
        JobStructure commands = new JobStructure();
        String name = model.getParameter(model.getKeyParamNames()[0]);
        if (name == null) {
            return null;
        }
        IComposedCommand command = targetCon.getCommandFactory().getCommand(ICommandFactory.COMMAND_TYPE.create, NodeFactory.TAG.table, null, model, null);
        commands.add(command);
        try {
            for (Node node : model.getAllChildren()) {
                commands.addCommands(command.addDataset(node, ICommandFactory.COMMAND_TYPE.create));
            }
        }
        catch (SQLException e) {
            Logger logger = LogManager.getLogger((String)"DB Updater");
            logger.error((Object)"Job create table failed");
            logger.error((Throwable)e);
            return null;
        }
        return commands;
    }
}

