/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.lib.json.JsonException;

public class HelpDeskReindexKeyGenerator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String createReindexKey(boolean useOriginalInRecoveryMode) {
        DatabaseConfigInfo hds;
        Configuration config;
        ConfigurationManager cfgManager = ConfigurationManager.getInstance();
        if (useOriginalInRecoveryMode) {
            String recoveryCfgName = ConfigurationManager.getRecoveryConfiguration();
            if (recoveryCfgName == null) return null;
            config = cfgManager.get(recoveryCfgName);
            if (config == null) {
                return null;
            }
        } else {
            config = cfgManager.getCurrent();
        }
        String dbConfigString = config.get(HDConfigKeys.DB_CONFIGS.getKey());
        try {
            hds = DatabaseConfigInfoList.valueOf(dbConfigString).get("HDS");
        }
        catch (JsonException | IllegalArgumentException ex) {
            HDLogger.error(ex);
            return null;
        }
        String reindexKey = null;
        if (hds == null) return reindexKey;
        return hds.getUrl() + ";" + hds.getUser();
    }
}

