/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.config.ConfigValue;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.IllegalStateExceptionWithErrorCode;
import com.inet.helpdesk.core.ticketmanager.fields.DefaultValuesManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.ticketmanager.TicketManipulatorInternal;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Date;
import srv.controller.ticket.timeline.ResourceTimelineManager;

public class DefaultValueManagerImpl
implements DefaultValuesManager {
    private static ConfigValue<Integer> CONF_PRIO_SELECTION = new ConfigValue(HDConfigKeys.DEFAULT_PRIO_SELECTION);
    private static ConfigValue<String> CONF_IDENTIFIER_SELECTION = new ConfigValue(HDConfigKeys.DEFAULT_IDENTIFIER_SELECTION);

    public static DefaultValueManagerImpl getInstance() {
        return (DefaultValueManagerImpl)ServerPluginManager.getInstance().getSingleInstance(DefaultValuesManager.class);
    }

    @Override
    public Integer getPriorityDefault() {
        return (Integer)Tickets.FIELD_PRIORITY_ID.getDefaultValue();
    }

    @Override
    public boolean hasSlaSettings() {
        Integer val = (Integer)CONF_PRIO_SELECTION.get();
        return val != null && val > 0;
    }

    @Override
    public Integer getSlaSettings() {
        return (Integer)CONF_PRIO_SELECTION.get();
    }

    @Override
    public UserField<Object> getFieldForIdentifierValue() {
        String fieldKey = (String)CONF_IDENTIFIER_SELECTION.get();
        if (StringFunctions.isEmpty((String)fieldKey)) {
            return null;
        }
        return UsersAndGroups.getFieldByKey((String)fieldKey);
    }

    @Override
    public Integer getDefaultPriorityID(UserAccount userAccount) {
        PriorityVO privo;
        UserClassVO userGroup;
        Integer usergroupID;
        Integer slaPrid = null;
        int slaSettings = 0;
        Integer integer = (Integer)CONF_PRIO_SELECTION.get();
        if (integer != null) {
            slaSettings = integer;
        }
        if (slaSettings == 1) {
            LocationVO location;
            Integer locationID;
            if (userAccount != null && (locationID = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)) != null && (location = (LocationVO)LocationManager.getInstance().get(locationID)) != null) {
                slaPrid = location.getSLA_PriID();
            }
        } else if (slaSettings == 2 && userAccount != null && (usergroupID = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID)) != null && (userGroup = (UserClassVO)UserClassManager.getInstance().get(usergroupID)) != null) {
            slaPrid = userGroup.getSLAID();
        }
        if (slaPrid != null && (privo = (PriorityVO)PriorityManager.getInstance().get(slaPrid)) != null && !privo.isDeleted()) {
            return slaPrid;
        }
        return this.getPriorityDefault();
    }

    @Override
    public void setDefaultValuesForNewTicket(ReaStepTextVO ticketText, MutableTicketData ticketData, UserAccount ticketOwner) {
        GUID resUUID;
        UserGroupInfo resourceGroup;
        Integer categoryID;
        UserField<Object> field;
        String identifier;
        UserAccount currentUser;
        if (!ticketData.hasValue(Tickets.FIELD_PRIORITY_ID)) {
            Integer defaultPrio;
            Integer n = defaultPrio = ticketOwner == null ? this.getPriorityDefault() : this.getDefaultPriorityID(ticketOwner);
            if (defaultPrio != null) {
                ticketData.put(Tickets.FIELD_PRIORITY_ID, defaultPrio);
            } else {
                throw new IllegalStateExceptionWithErrorCode(Tickets.MSG.getMsg("error.noDefaultPrioSet", new Object[0]), (ErrorCode)HelpDeskErrorCodes.TICKET_OPERATION_NOT_POSSIBLE_CORRUPTED_SETTING);
            }
        }
        if (!(HDUsersAndGroups.isDispatcher(currentUser = UserManager.getInstance().getCurrentUserAccount()) || ticketOwner == null || HDUsersAndGroups.isSupporter(currentUser) || ticketData.hasValue(Tickets.FIELD_IDENTIFIER) || this.getFieldForIdentifierValue() == null || (identifier = (field = this.getFieldForIdentifierValue()).getFieldType().asString(ticketOwner.getValue(field))) == null || identifier.length() <= 0)) {
            ticketData.put(Tickets.FIELD_IDENTIFIER, identifier);
        }
        if (!ticketData.hasValue(Tickets.FIELD_RESOURCE_GUID) && CategoryManager.RESOURCE_TAKEOVER_SETTING.get() != CategoryManager.RESOURCE_TAKEOVER.never && (categoryID = ticketData.get(Tickets.FIELD_CATEGORY_ID)) != null) {
            while (categoryID != null && categoryID > 0) {
                CategoryVO category = (CategoryVO)CategoryManager.getInstance().get(categoryID);
                if (category != null && category.getResourceID() > 0 && (resourceGroup = HDUsersAndGroups.getResource(category.getResourceID())).isActive()) {
                    ticketData.put(Tickets.FIELD_RESOURCE_GUID, resourceGroup.getID());
                    break;
                }
                if (category == null) break;
                categoryID = category.getParentCategoryID();
            }
        }
        if (!ticketData.hasValue(Tickets.FIELD_RESOURCE_GUID) && ticketOwner != null) {
            Integer bgrObj = (Integer)ticketOwner.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
            UserClassVO usergroup = (UserClassVO)UserClassManager.getInstance().get(bgrObj);
            if (usergroup != null && usergroup.getDefaultAuthorisationResource() > 0 && (resourceGroup = HDUsersAndGroups.getResource(usergroup.getDefaultAuthorisationResource())).isActive()) {
                ticketData.put(Tickets.FIELD_RESOURCE_GUID, resourceGroup.getID());
            }
        }
        if (!ticketData.hasValue(Tickets.FIELD_DEADLINE) && ticketData.containsKey(Tickets.FIELD_RESOURCE_GUID) && (resUUID = ticketData.get(Tickets.FIELD_RESOURCE_GUID)) != null) {
            UserGroupInfo res = UserGroupManager.getInstance().getGroup(resUUID);
            if (res == null) {
                HDLogger.error(new IllegalArgumentException("User Group representing resource with ID =\"" + String.valueOf(resUUID) + "\" could not be found."));
            } else {
                int resIntID = (Integer)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
                ResourceTimelineManager rtm = ResourceTimelineManager.getInstance();
                Date deadline = rtm.calcDeadline(resIntID, ticketData.get(Tickets.FIELD_PRIORITY_ID));
                if (deadline != null) {
                    ticketData.put(Tickets.FIELD_DEADLINE, Long.valueOf(deadline.getTime()));
                }
            }
        }
        for (TicketField field2 : DynamicExtensionManager.getInstance().get(TicketField.class)) {
            this.setDefaultValue(ticketData, field2);
        }
        String subject = TicketManipulatorInternal.createSubjectIfMissing(ticketData.get(Tickets.FIELD_SUBJECT), ticketText.getText(), ticketText.hasHtmlContent());
        ticketData.put(Tickets.FIELD_SUBJECT, subject);
    }

    private <T> void setDefaultValue(MutableTicketData ticketData, TicketField<T> field) {
        Object defaultValue;
        if (!ticketData.hasValue(field) && (defaultValue = field.getDefaultValue()) != null) {
            ticketData.put(field, defaultValue);
        }
    }
}

