/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import java.util.ArrayList;
import java.util.List;

public class SubListTaskExecutor {
    public <T> void executeForEachSubList(List<T> elementsToProcess, int elementsPerExecution, SubListExecutionTask<T> task) throws Exception {
        if (elementsToProcess == null) {
            throw new IllegalArgumentException("list with elements to process must not be null");
        }
        if (elementsPerExecution < 0) {
            throw new IllegalArgumentException("number of elements per execution must not be negative");
        }
        if (task == null) {
            throw new IllegalArgumentException("task must not be null");
        }
        if (elementsToProcess.isEmpty() || elementsPerExecution == 0) {
            return;
        }
        int maxIndex = elementsToProcess.size();
        int fromIndex = 0;
        while (fromIndex < maxIndex) {
            int toIndex = Math.min(fromIndex + elementsPerExecution, maxIndex);
            List<T> subList = elementsToProcess.subList(fromIndex, toIndex);
            fromIndex = toIndex;
            task.execute(subList);
        }
    }

    public <T> void executeParallelForEachSubList(List<T> elementsToProcess, int elementsPerExecution, SubListExecutionTask<T> task) throws Exception {
        this.executeParallelForEachSubList(elementsToProcess, elementsPerExecution, task, -1L);
    }

    public <T> void executeParallelForEachSubList(List<T> elementsToProcess, int elementsPerExecution, SubListExecutionTask<T> task, long timeout) throws Exception {
        if (elementsToProcess == null) {
            throw new IllegalArgumentException("list with elements to process must not be null");
        }
        if (elementsPerExecution < 0) {
            throw new IllegalArgumentException("number of elements per execution must not be negative");
        }
        if (task == null) {
            throw new IllegalArgumentException("task must not be null");
        }
        if (elementsToProcess.isEmpty() || elementsPerExecution == 0) {
            return;
        }
        int maxIndex = elementsToProcess.size();
        int fromIndex = 0;
        ArrayList<List<T>> jobs = new ArrayList<List<T>>(maxIndex / elementsPerExecution + 1);
        while (fromIndex < maxIndex) {
            int toIndex = Math.min(fromIndex + elementsPerExecution, maxIndex);
            jobs.add(elementsToProcess.subList(fromIndex, toIndex));
            fromIndex = toIndex;
        }
        long starttime = timeout < 0L ? 0L : System.currentTimeMillis();
        Exception[] exception = new Exception[1];
        jobs.parallelStream().forEach(subList -> {
            try {
                if (timeout < 0L || System.currentTimeMillis() <= starttime + timeout) {
                    task.execute((List)subList);
                }
            }
            catch (Exception ex) {
                exception[0] = ex;
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    public static interface SubListExecutionTask<T> {
        public void execute(List<T> var1) throws Exception;
    }
}

