/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.utils;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.thread.ThreadUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import javax.annotation.Nonnull;

public class DatabaseTransactionUtils {
    public static final int DEFAULT_SQLTRANSIENT_MAXATTEMPTS = 10;
    public static final int DEFAULT_SQLTRANSIENT_SLEEP_BETWEEN_ATTEMPTS = 100;

    public static <R> R executeAsTransaction(ConnectionFactory connectionFactory, ExecutableAsTransaction<R> executable) throws SQLException {
        Connection con = connectionFactory.getConnection();
        return DatabaseTransactionUtils.executeAsTransaction(con, executable);
    }

    public static <R> R executeAsTransaction(Connection con, ExecutableAsTransaction<R> executable) throws SQLException {
        boolean needTransactionHandling = con.getAutoCommit();
        try {
            if (needTransactionHandling) {
                con.setAutoCommit(false);
                ConnectionFactory.setCurrentConnectionWithTransaction(con);
            }
            R result = executable.execute(con);
            if (needTransactionHandling) {
                con.commit();
            }
            R r = result;
            return r;
        }
        catch (Throwable e) {
            if (needTransactionHandling) {
                try {
                    con.rollback();
                }
                catch (SQLException ex) {
                    HDLogger.error(ex);
                }
            }
            throw e;
        }
        finally {
            if (needTransactionHandling) {
                try {
                    con.setAutoCommit(true);
                }
                catch (SQLException ex) {
                    HDLogger.error(ex);
                }
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
                ConnectionFactory.setCurrentConnectionWithTransaction(null);
            }
        }
    }

    public static <R> R executeWithToleranceOfTransientExceptions(@Nonnull ExecutableWithToleranceOfTransientExceptions<R> executable, int maxAttempts, int timeToSleepBetweenAttemptsInMillis) throws SQLException {
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("maxAttempts must be greater than 0");
        }
        if (timeToSleepBetweenAttemptsInMillis <= 0) {
            throw new IllegalArgumentException("timeToSleepBetweenAttemptsInMillis must be greater than 0");
        }
        int failedAttempts = 0;
        while (true) {
            try {
                return executable.execute();
            }
            catch (Exception ex) {
                if (DatabaseTransactionUtils.isOrCausedByTransientException(ex)) {
                    HDLogger.warn(ex);
                    if (++failedAttempts >= maxAttempts) {
                        if (HDLogger.isDebug()) {
                            try {
                                StringWriter out = new StringWriter();
                                ThreadUtils.threadDump((Writer)out);
                                HDLogger.debug("Thread on timeout:");
                                HDLogger.debug(out.toString());
                            }
                            catch (IOException out) {
                                // empty catch block
                            }
                        }
                        throw ex;
                    }
                    try {
                        Thread.sleep(timeToSleepBetweenAttemptsInMillis);
                    }
                    catch (InterruptedException ie) {
                        HDLogger.error(ie);
                    }
                    continue;
                }
                throw ex;
            }
            break;
        }
    }

    private static boolean isOrCausedByTransientException(Throwable ex) {
        if (ex instanceof SQLTransientException) {
            return true;
        }
        if (ex.getCause() != null) {
            return DatabaseTransactionUtils.isOrCausedByTransientException(ex.getCause());
        }
        return false;
    }

    public static <R> R executeWithToleranceOfTransientExceptions(@Nonnull ExecutableWithToleranceOfTransientExceptions<R> executable) throws SQLException {
        return DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(executable, 10, 100);
    }

    public static interface ExecutableAsTransaction<R> {
        public R execute(Connection var1) throws SQLException;
    }

    public static interface ExecutableWithToleranceOfTransientExceptions<R> {
        public R execute() throws SQLException;
    }
}

