/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.reasteps;

import com.inet.annotations.InternalApi;
import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class ReaStepField<VALUE>
extends Field<VALUE> {
    public ReaStepField(String key) {
        this(key, null);
    }

    public ReaStepField(String key, VALUE defaultValue) {
        super(key, defaultValue, FieldTypeFactory.auto().withoutSearchTag());
    }

    public ReaStepField(String key, VALUE defaultValue, FieldTypeFactory factory) {
        super(key, defaultValue, factory);
    }

    public String getLabel() {
        return Tickets.MSG.getMsg("reafield." + this.getKey() + ".label", new Object[0]);
    }

    public OperationNewReaStep createFieldChangeReaStep(VALUE oldFieldValue, VALUE newFieldValue, OperationChangedTicket ticket) {
        MutableReaStepData data = new MutableReaStepData();
        data.put(ReaStepVO.FIELD_DESC, this.constructReaStepDescriptionForFieldChange(oldFieldValue, newFieldValue));
        return ticket.addReaStep(-22, data, MutableReaStepText.empty());
    }

    protected String constructReaStepDescriptionForFieldChange(@Nullable VALUE oldFieldValue, @Nullable VALUE newFieldValue) {
        Object oldValue = oldFieldValue == null ? "" : this.valueToString(oldFieldValue);
        Object newValue = newFieldValue == null ? "" : this.valueToString(newFieldValue);
        String prefix = this.getLabel() + ": ";
        int max = (245 - prefix.length()) / 2;
        if (((String)oldValue).length() > max) {
            oldValue = ((String)oldValue).substring(0, max - 1) + "...";
        }
        if (((String)newValue).length() > max) {
            newValue = ((String)newValue).substring(0, max - 1) + "...";
        }
        return prefix + (String)oldValue + " -> " + (String)newValue;
    }

    protected String valueToString(@Nonnull VALUE fieldValue) {
        return fieldValue.toString();
    }
}

