/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttribute;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttributeActionId;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttributeBunId;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttributeBundleVisible;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttributeHasText;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttributeHourlyRate;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttributeLumpSum;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttributeOrgBunId;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttributeResId;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttributeUserId;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldActionLabel;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldDescription;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldDisplayName;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldDuplicatedContent;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldEmailAn;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldEmailBCC;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldEmailCC;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldEmailIn;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldEmailUserInfo;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldGroupReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldNoFieldChange;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldParentReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepFieldTaskId;
import com.inet.id.GUID;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReaStepVO {
    public static final ReaStepAttributeActionId ATTRIBUTE_ACTION_ID = new ReaStepAttributeActionId();
    public static final ReaStepAttributeBunId ATTRIBUTE_BUN_ID = new ReaStepAttributeBunId();
    public static final ReaStepAttributeHourlyRate ATTRIBUTE_HOURLY_RATE = new ReaStepAttributeHourlyRate();
    public static final ReaStepAttributeLumpSum ATTRIBUTE_LUMP_SUM = new ReaStepAttributeLumpSum();
    public static final ReaStepAttributeOrgBunId ATTRIBUTE_ORG_BUN_ID = new ReaStepAttributeOrgBunId();
    public static final ReaStepAttributeResId ATTRIBUTE_RES_ID = new ReaStepAttributeResId();
    public static final ReaStepAttributeUserId ATTRIBUTE_USER_ID = new ReaStepAttributeUserId();
    public static final ReaStepAttributeBundleVisible ATTRIBUTE_BUNDLE_VISIBLE = new ReaStepAttributeBundleVisible();
    public static final ReaStepAttributeHasText ATTRIBUTE_HAS_TEXT = new ReaStepAttributeHasText();
    public static final ReaStepFieldDescription FIELD_DESC = new ReaStepFieldDescription();
    public static final ReaStepFieldEmailAn FIELD_EMAIL_AN = new ReaStepFieldEmailAn();
    public static final ReaStepFieldEmailBCC FIELD_EMAIL_BCC = new ReaStepFieldEmailBCC();
    public static final ReaStepFieldEmailCC FIELD_EMAIL_CC = new ReaStepFieldEmailCC();
    public static final ReaStepFieldEmailIn FIELD_EMAIL_IN = new ReaStepFieldEmailIn();
    public static final ReaStepField<String> FIELD_EMAIL_MESSAGE_ID = new ReaStepFieldNoFieldChange<String>("reastepmessageid", null){};
    public static final ReaStepField<String> FIELD_EMAIL_REFERENCE = new ReaStepFieldNoFieldChange<String>("reastepmailreference", null){};
    public static final ReaStepFieldProcessingTime FIELD_PROCESSING_TIME = new ReaStepFieldProcessingTime();
    public static final ReaStepFieldParentReaStep FIELD_PARENT_REASTEP = new ReaStepFieldParentReaStep();
    public static final ReaStepFieldGroupReaStep FIELD_GROUP_REASTEP = new ReaStepFieldGroupReaStep();
    public static final ReaStepFieldTaskId FIELD_TASKPLANNER_TASKID = new ReaStepFieldTaskId();
    public static final ReaStepFieldEmailUserInfo FIELD_EMAIL_USER_INFO = new ReaStepFieldEmailUserInfo();
    public static final ReaStepFieldDisplayName FIELD_USER_DISPLAY_NAME = new ReaStepFieldDisplayName();
    public static final ReaStepFieldDuplicatedContent FIELD_DUPLICATED_CONTENT = new ReaStepFieldDuplicatedContent();
    public static final ReaStepFieldActionLabel FIELD_ACTION_LABEL = new ReaStepFieldActionLabel();
    private final int id;
    private final MutableReaStepData reaStepData;
    private final MutableReaStepAttributes attributes;

    @Nonnull
    public static List<ReaStepAttribute<?>> getAttributesForRegistration() {
        ArrayList attributes = new ArrayList();
        attributes.add(ATTRIBUTE_ACTION_ID);
        attributes.add(ATTRIBUTE_BUN_ID);
        attributes.add(ATTRIBUTE_HOURLY_RATE);
        attributes.add(ATTRIBUTE_LUMP_SUM);
        attributes.add(ATTRIBUTE_ORG_BUN_ID);
        attributes.add(ATTRIBUTE_RES_ID);
        attributes.add(ATTRIBUTE_USER_ID);
        attributes.add(ATTRIBUTE_HAS_TEXT);
        return attributes;
    }

    @Nonnull
    public static List<ReaStepField<?>> getFieldsForRegistration() {
        ArrayList fields = new ArrayList();
        fields.add(FIELD_DESC);
        fields.add(FIELD_EMAIL_AN);
        fields.add(FIELD_EMAIL_BCC);
        fields.add(FIELD_EMAIL_CC);
        fields.add(FIELD_EMAIL_IN);
        fields.add(FIELD_PROCESSING_TIME);
        fields.add(FIELD_USER_DISPLAY_NAME);
        fields.add(FIELD_PARENT_REASTEP);
        fields.add(FIELD_GROUP_REASTEP);
        fields.add(FIELD_TASKPLANNER_TASKID);
        fields.add(FIELD_EMAIL_USER_INFO);
        fields.add(FIELD_DUPLICATED_CONTENT);
        fields.add(FIELD_ACTION_LABEL);
        fields.add(FIELD_EMAIL_MESSAGE_ID);
        fields.add(FIELD_EMAIL_REFERENCE);
        return fields;
    }

    protected ReaStepVO(int reaStepID, @Nonnull MutableReaStepAttributes attributes, @Nonnull MutableReaStepData reaStepData) {
        this.id = reaStepID;
        this.attributes = attributes.copy();
        this.reaStepData = reaStepData.copy();
    }

    public static ReaStepVO create(int reaStepID, @Nonnull MutableReaStepAttributes attributes, @Nonnull MutableReaStepData reaStepData) {
        return new ReaStepVO(reaStepID, attributes, reaStepData);
    }

    public <VALUE> VALUE getAttribute(ReaStepAttribute<VALUE> attribute) {
        VALUE value = this.attributes.get(attribute);
        return (VALUE)(value == null ? null : attribute.copyValue(value));
    }

    public Set<ReaStepAttribute<Object>> getIncludedAttributes() {
        return this.attributes.getIncludedAttributes();
    }

    public <VALUE> VALUE getValue(ReaStepField<VALUE> field) {
        VALUE value = this.reaStepData.get(field);
        return (VALUE)(value == null ? null : field.copyValue(value));
    }

    public Set<ReaStepField<Object>> getIncludedFields() {
        return this.reaStepData.getIncludedFields();
    }

    public int getID() {
        return this.id;
    }

    public int getOrgBunID() {
        return this.getAttribute(ATTRIBUTE_ORG_BUN_ID);
    }

    public int getBunID() {
        return this.getAttribute(ATTRIBUTE_BUN_ID);
    }

    public long getStartDate() {
        return this.getValue(FIELD_PROCESSING_TIME).getStart();
    }

    public long getEndDate() {
        return this.getValue(FIELD_PROCESSING_TIME).getEnd();
    }

    @Nullable
    public GUID getUserID() {
        return this.getAttribute(ATTRIBUTE_USER_ID);
    }

    public int getActionID() {
        return this.getAttribute(ATTRIBUTE_ACTION_ID);
    }

    @Nonnull
    public String getDescription() {
        return this.getValue(FIELD_DESC);
    }

    public double getHourlyRate() {
        return this.getAttribute(ATTRIBUTE_HOURLY_RATE);
    }

    public double getLumpSum() {
        return this.getAttribute(ATTRIBUTE_LUMP_SUM);
    }

    @Nonnull
    public String getEmailBCCAdresses() {
        return this.getValue(FIELD_EMAIL_BCC);
    }

    @Nonnull
    public String getEmailCCAdresses() {
        return this.getValue(FIELD_EMAIL_CC);
    }

    @Nonnull
    public String getEmailReceiverAddresses() {
        return this.getValue(FIELD_EMAIL_AN);
    }

    @Nonnull
    public String getEmailSenderAddress() {
        return this.getValue(FIELD_EMAIL_IN);
    }

    public int getResID() {
        Integer resID = this.getAttribute(ATTRIBUTE_RES_ID);
        return resID == null ? 0 : resID;
    }

    public boolean hasText() {
        return this.getAttribute(ATTRIBUTE_HAS_TEXT);
    }

    public String getActionLabel() {
        return this.getValue(FIELD_ACTION_LABEL);
    }

    public String getDisplayName() {
        return this.getValue(FIELD_USER_DISPLAY_NAME);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReaStepVO other = (ReaStepVO)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        return !(this.reaStepData == null ? other.reaStepData != null : !this.reaStepData.equals(other.reaStepData));
    }

    public boolean isBundleVisible() {
        return this.getAttribute(ATTRIBUTE_BUNDLE_VISIBLE);
    }

    public String toString() {
        return String.format("ReaStep %d, Action=%d, user=%s,bunId=%d", this.getID(), this.getActionID(), this.getUserID(), this.getBunID());
    }

    public MutableReaStepData getReaStepDataCopy() {
        return this.reaStepData.copy();
    }
}

