/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.general;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.shared.model.DataField;
import com.inet.helpdesk.shared.model.Field;
import java.io.Serializable;
import java.util.ArrayList;

@JsonData
public abstract class AbstractData
implements Serializable {
    public static final int TYPE_STATUS = 0;
    public static final int TYPE_RESOURCE = 1;
    public static final int TYPE_PRIORITAET = 2;
    public static final int TYPE_KLASSIFIZIERUNG = 3;
    public static final int TYPE_KATEGORIE = 4;
    public static final int TYPE_ORT = 5;
    public static final int TYPE_BENUTZERKLASSE = 6;
    public static final int TYPE_ITIL = 7;
    public static final int TYPE_FREI = 8;
    public static final int TYPE_LAST_EDITOR = 9;
    public static final int TYPE_PREDEFINED_TICKETFIELD1 = 10;
    public static final int TYPE_PREDEFINED_TICKETFIELD2 = 11;
    public static final int TYPE_PREDEFINED_TICKETFIELD3 = 12;
    public static final int TYP_OWNER = 13;
    public static final int TYPE_DEVICE_TYPE = 14;
    public static final int TYPE_LANGUAGE = 18;
    private static final long serialVersionUID = 1L;
    private int groupType;
    private int typeId;
    private String displayName;
    private ArrayList<DataField> data = new ArrayList();

    public AbstractData() {
    }

    public AbstractData(int typeId, int keyId, String displayName) {
        this.groupType = typeId;
        this.typeId = keyId;
        this.displayName = displayName;
    }

    public int getTypeId() {
        return this.groupType;
    }

    public void setTypeId(int typeId) {
        this.groupType = typeId;
    }

    public int getId() {
        return this.typeId;
    }

    public void setId(int id) {
        this.typeId = id;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return "";
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDeleted(boolean deleted) {
        this.setData(Field.RESOURCE_DELETED, deleted);
    }

    public boolean isDeleted() {
        return (Boolean)this.getData(Field.RESOURCE_DELETED, Boolean.FALSE);
    }

    public void setWriteable(boolean writeable) {
        this.setData(Field.RESOURCE_WRITABLE, writeable);
    }

    public void setReadable(boolean readable) {
        this.setData(Field.RESOURCE_READABLE, readable);
    }

    public void setImageName(String imageName) {
        this.setData(Field.RESOURCE_IMAGEURL, imageName);
    }

    public String getImageName() {
        return (String)this.getData(Field.RESOURCE_IMAGEURL, null);
    }

    public boolean isWriteable() {
        return (Boolean)this.getData(Field.RESOURCE_WRITABLE, Boolean.TRUE);
    }

    public boolean isReadable() {
        return (Boolean)this.getData(Field.RESOURCE_READABLE, Boolean.TRUE);
    }

    public void setStringKey(String key) {
        this.setData(Field.RESOURCE_GROUPTYPEID, key);
    }

    public String getStringKey() {
        return (String)this.getData(Field.RESOURCE_GROUPTYPEID, null);
    }

    public void setDataFields(ArrayList<DataField> datafields) {
        this.data = datafields == null ? new ArrayList() : datafields;
    }

    public ArrayList<DataField> getDataFields() {
        return this.data;
    }

    public Object getData(Field field, Object defaultValue) {
        for (DataField df : this.data) {
            if (df.getField() != field) continue;
            Object value = df.getValue(field.getClassType());
            if (value == null) break;
            return value;
        }
        return defaultValue;
    }

    private void setData(Field field, Object value) {
        for (DataField df : this.data) {
            if (df.getField() != field) continue;
            this.data.remove(df);
            break;
        }
        this.data.add(new DataField(field, value));
    }

    public abstract void updateTreeData(Boolean var1, String var2);

    public String toString() {
        return "Data: type=" + this.groupType + ", id=" + this.getId() + ", name=" + this.getDisplayName();
    }
}

