/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.mailtemplates.handler;

import com.inet.helpdesk.config.mailtemplates.data.MoveMailTemplateRequest;
import com.inet.helpdesk.config.mailtemplates.handler.MailTemplatesHelper;
import com.inet.helpdesk.core.mailtemplates.MailTemplateData;
import com.inet.helpdesk.core.mailtemplates.MailTemplatesManager;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.http.ClientMessageException;
import com.inet.remote.gui.angular.ServiceMethod;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class MoveMailTemplateHandler
extends ServiceMethod<MoveMailTemplateRequest, Void> {
    public String getMethodName() {
        return "mailtemplates.movemailtemplate";
    }

    public short getMethodType() {
        return 1;
    }

    public Void invoke(HttpServletRequest req, HttpServletResponse resp, MoveMailTemplateRequest payload) throws IOException {
        String targetSet = payload.getTargetSet();
        String targetLang = payload.getTargetLang();
        String targetName = payload.getTargetName();
        MailTemplatesHelper.checkInvalidName(targetName);
        MailTemplateData checkTemplate = MailTemplatesManager.getTemplate(targetName, targetSet, targetLang);
        if (checkTemplate.getHtmlData() != null || checkTemplate.getTextData() != null) {
            throw new ClientMessageException(HelpdeskServerPlugin.MSG_CONFIG.getMsg("configpage.configuration.mailtemplates.templateexists", new Object[0]));
        }
        MailTemplateData template = MailTemplatesManager.getTemplate(payload.getSourceName(), payload.getSourceSet(), payload.getSourceLang());
        template.setSet(targetSet);
        template.setLang(targetLang);
        template.setName(targetName);
        MailTemplatesManager.createOrUpdateTemplate(template);
        if (payload.isDeleteSource()) {
            MailTemplatesManager.deleteTemplates(payload.getSourceName(), payload.getSourceSet(), payload.getSourceLang());
        }
        return null;
    }
}

