/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.helpdesk.config.CategoryList;
import com.inet.helpdesk.config.CategoryListConfigProperty;
import com.inet.helpdesk.config.ClassificationList;
import com.inet.helpdesk.config.ClassificationListConfigProperty;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LocalizedKeyListFactory;
import com.inet.helpdesk.config.LocationList;
import com.inet.helpdesk.config.LocationListConfigProperty;
import com.inet.helpdesk.config.PriorityList;
import com.inet.helpdesk.config.PriorityListConfigProperty;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.config.UserClassesListConfigProperty;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationManager;
import com.inet.helpdesk.core.ticketmanager.fields.classification.ClassificationVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.usersandgroups.api.ui.TargetValue;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HDConfigStructureProviderTicketValues
extends AbstractStructureProvider {
    public static final String GROUP_VALUES = "ticketvalues";
    public static final String PROP_GROUP_LOCATIONS = "helpdesk.main.locations.main";
    public static final String PROP_GROUP_LOCATIONS_DEACTIVATED = "helpdesk.main.locations.deactivated";
    private static final String CATEGORY_LOCATIONS = "helpdesk.main.locations";
    public static final String PROP_GROUP_CLASSIFICATIONS = "helpdesk.main.classifications.main";
    public static final String PROP_GROUP_CLASSIFICATIONS_TITLE_LABEL = "helpdesk.classifications.title_label";
    private static final String CATEGORY_CLASSIFICATIONS = "helpdesk.main.classifications";
    public static final String PROP_GROUP_DEFAULT_VALUES_PRIORITY = "helpdesk.main.defaultvalues.prio";
    public static final String PROP_GROUP_PRIORITIES = "helpdesk.main.priorities.main";
    public static final String PROP_GROUP_PRIORITIES_TITLE_LABEL = "helpdesk.priorities.title_label";
    private static final String CATEGORY_PRIORITIES = "helpdesk.main.priorities";
    public static final String PROP_GROUP_CATEGORIES = "helpdesk.main.categories.main";
    public static final String PROP_GROUP_CATEGORIES_TITLE_LABEL = "helpdesk.categories.title_label";
    private static final String CATEGORY_CATEGORIES = "helpdesk.main.categories";
    private static final String CATEGORY_SCHWELLWERTE = "helpdesk.main.schwellwerte";
    public static final String PROP_GROUP_AUTO_ESCALATION = "helpdesk.tickets.autoesca";
    public static final String PROP_GROUP_DEADLINE = "helpdesk.tickets.deadline";
    private static final String CATEGORY_CLASSES = "helpdesk.main.userclasses";
    private static final String PROP_GROUP_CLASSES = "helpdesk.main.userclasses.main";
    private static final String PROP_GROUP_CLASSES_TITLE_LABEL = "helpdesk.userclasses.title_label";
    private final ConnectionFactory connectionFactory;
    private static ConfigValue<Integer> DEFAULT_PRIO_SELECTION = new ConfigValue(HDConfigKeys.DEFAULT_PRIO_SELECTION);
    private static final Set<Integer> STATUSES_TO_NOT_AUTO_SET_FOR_ESCALATION = new HashSet<Integer>(Arrays.asList(101, 102, 103, 109, 211, 260, 293));

    public HDConfigStructureProviderTicketValues(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Permission[] getRequiredPermissions() {
        return new Permission[]{Permission.CONFIGURATION, HdPermissions.TEMPLATE_DEFINITION};
    }

    public void addGroupsTo(Set<ConfigGroup> groups, boolean advanced, ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(125, GROUP_VALUES, this.translate(settings, GROUP_VALUES, new Object[0])));
    }

    public void addCategoriesTo(Set<ConfigCategory> categories, String groupKey, boolean advanced, ConfigStructureSettings settings) {
        switch (groupKey) {
            case "ticketvalues": {
                categories.add(new ConfigCategory(131, CATEGORY_LOCATIONS, this.translate(settings, "Locations", new Object[0]), "ticket.values.locations"));
                categories.add(new ConfigCategory(132, CATEGORY_CLASSES, this.translate(settings, "UserClasses", new Object[0]), "ticket.values.userclasses"));
                categories.add(new ConfigCategory(133, CATEGORY_PRIORITIES, this.translate(settings, "Priorities", new Object[0]), "ticket.values.priorities"));
                categories.add(new ConfigCategory(134, CATEGORY_SCHWELLWERTE, this.translate(settings, "Schwellwerte", new Object[0]), "ticket.settings.schwellwerte"));
                categories.add(new ConfigCategory(135, CATEGORY_CATEGORIES, this.translate(settings, "Categories", new Object[0]), "ticket.values.categories"));
                categories.add(new ConfigCategory(136, CATEGORY_CLASSIFICATIONS, this.translate(settings, "Classifications", new Object[0]), "ticket.values.classifications"));
            }
        }
    }

    public URL getCategoryIcon(String categoryKey) {
        try {
            switch (categoryKey) {
                case "helpdesk.main.locations": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/location_48.png");
                }
                case "helpdesk.main.userclasses": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/userclass_48.png");
                }
                case "helpdesk.main.classifications": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/classification_48.png");
                }
                case "helpdesk.main.categories": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/category_48.png");
                }
                case "helpdesk.main.priorities": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/priority_48.png");
                }
                case "helpdesk.main.schwellwerte": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/threshold_48.png");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void addPropertyGroupsTo(Set<ConfigPropertyGroup> configPropertyGroups, String categoryKey, boolean advanced, ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "helpdesk.main.classifications": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_CLASSIFICATIONS_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_CLASSIFICATIONS));
                break;
            }
            case "helpdesk.main.locations": {
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_LOCATIONS));
                configPropertyGroups.add(new ConfigPropertyGroup(125, PROP_GROUP_LOCATIONS_DEACTIVATED, this.translate(settings, PROP_GROUP_LOCATIONS_DEACTIVATED, new Object[0])));
                break;
            }
            case "helpdesk.main.userclasses": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_CLASSES_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_CLASSES));
                break;
            }
            case "helpdesk.main.priorities": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_PRIORITIES_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_PRIORITIES));
                configPropertyGroups.add(new ConfigPropertyGroup(125, PROP_GROUP_DEFAULT_VALUES_PRIORITY, " "));
                break;
            }
            case "helpdesk.main.categories": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_CATEGORIES_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_CATEGORIES));
                break;
            }
            case "helpdesk.main.schwellwerte": {
                configPropertyGroups.add(new ConfigPropertyGroup(125, PROP_GROUP_AUTO_ESCALATION, this.translate(settings, PROP_GROUP_AUTO_ESCALATION, new Object[0])));
                configPropertyGroups.add(new ConfigPropertyGroup(126, PROP_GROUP_DEADLINE, this.translate(settings, PROP_GROUP_DEADLINE, new Object[0])));
                break;
            }
        }
    }

    public void addPropertiesTo(Set<ConfigProperty> configProperties, String propertyGroupKey, boolean advanced, ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "helpdesk.main.locations.main": {
                this.addTo(configProperties, "locations.title_label", "Label", settings);
                configProperties.add((ConfigProperty)new LocationListConfigProperty(configProperties, settings, t -> this.translate(settings, t), this.connectionFactory, false));
                break;
            }
            case "helpdesk.main.locations.deactivated": {
                this.addTo(configProperties, "helpdesk.locations.deactivates.title_label", "Label", settings);
                configProperties.add((ConfigProperty)new LocationListConfigProperty(configProperties, settings, t -> this.translate(settings, t), this.connectionFactory, true));
                break;
            }
            case "helpdesk.main.userclasses.main": {
                configProperties.add((ConfigProperty)new UserClassesListConfigProperty(settings, t -> this.translate(settings, t), this.connectionFactory));
                break;
            }
            case "helpdesk.userclasses.title_label": {
                this.addTo(configProperties, "classes.title_label", "Label", settings);
                break;
            }
            case "helpdesk.main.classifications.main": {
                configProperties.add((ConfigProperty)new ClassificationListConfigProperty(settings, t -> this.translate(settings, t)));
                configProperties.add(new ConfigProperty(5047, "class.instructions1", "Link", this.translate(settings, "prioLabel", new Object[0]), (Object)this.getTicketFieldSettingsURL(), null, this.translate(settings, "class.instructions1", new Object[0])));
                break;
            }
            case "helpdesk.classifications.title_label": {
                this.addTo(configProperties, "classifications.title_label", "Label", settings);
                break;
            }
            case "helpdesk.main.categories.main": {
                configProperties.add((ConfigProperty)new CategoryListConfigProperty(settings, t -> this.translate(settings, t)));
                configProperties.add(new ConfigProperty(5047, "cat.instructions1", "Link", this.translate(settings, "prioLabel", new Object[0]), (Object)this.getTicketFieldSettingsURL(), null, this.translate(settings, "cat.instructions1", new Object[0])));
                ArrayList<LocalizedKey> takeoverOptions = new ArrayList<LocalizedKey>();
                takeoverOptions.add(new LocalizedKey(CategoryManager.RESOURCE_TAKEOVER.never.name(), this.translate(settings, "category.resource.takeover." + CategoryManager.RESOURCE_TAKEOVER.never.name(), new Object[0])));
                takeoverOptions.add(new LocalizedKey(CategoryManager.RESOURCE_TAKEOVER.newticketnotset.name(), this.translate(settings, "category.resource.takeover." + CategoryManager.RESOURCE_TAKEOVER.newticketnotset.name(), new Object[0])));
                takeoverOptions.add(new LocalizedKey(CategoryManager.RESOURCE_TAKEOVER.ondemand.name(), this.translate(settings, "category.resource.takeover." + CategoryManager.RESOURCE_TAKEOVER.ondemand.name(), new Object[0])));
                takeoverOptions.add(new LocalizedKey(CategoryManager.RESOURCE_TAKEOVER.askifnotempty.name(), this.translate(settings, "category.resource.takeover." + CategoryManager.RESOURCE_TAKEOVER.askifnotempty.name(), new Object[0])));
                takeoverOptions.add(new LocalizedKey(CategoryManager.RESOURCE_TAKEOVER.always.name(), this.translate(settings, "category.resource.takeover." + CategoryManager.RESOURCE_TAKEOVER.always.name(), new Object[0])));
                this.addSelectTo(configProperties, HDConfigKeys.CATEGORY_RESOURCE_TAKEOVER, settings, takeoverOptions);
                break;
            }
            case "helpdesk.categories.title_label": {
                this.addTo(configProperties, "categories.title_label", "Label", settings);
                break;
            }
            case "helpdesk.main.defaultvalues.prio": {
                ArrayList<LocalizedKey> options = new ArrayList<LocalizedKey>();
                options.add(new LocalizedKey("0", this.translate(settings, "sla.standard", new Object[0])));
                options.add(new LocalizedKey("1", this.translate(settings, "sla.location", new Object[0])));
                options.add(new LocalizedKey("2", this.translate(settings, "sla.usergroup", new Object[0])));
                this.addSelectTo(configProperties, HDConfigKeys.DEFAULT_PRIO_SELECTION, settings, options);
                configProperties.add(new ConfigProperty(5047, "prio.instructions1", "Link", this.translate(settings, "prioLabel", new Object[0]), (Object)this.getTicketFieldSettingsURL(), null, this.translate(settings, "prio.instructions1", new Object[0])));
                break;
            }
            case "helpdesk.main.priorities.main": {
                configProperties.add((ConfigProperty)new PriorityListConfigProperty(this.connectionFactory, settings, t -> this.translate(settings, t)));
                break;
            }
            case "helpdesk.priorities.title_label": {
                this.addTo(configProperties, "priorities.title_label", "Label", settings);
                break;
            }
            case "helpdesk.tickets.autoesca": {
                if (advanced) {
                    Integer currentValue = Integer.valueOf(settings.getValue(HDConfigKeys.ESCALATION_WARNING_ACTION));
                    List<LocalizedKey> escaStatuses = this.getActionsWithCustomNonDeletedEndStatusBetweenOrIncludingCurrentValue(101, 149, STATUSES_TO_NOT_AUTO_SET_FOR_ESCALATION, currentValue);
                    escaStatuses.add(new LocalizedKey("-1", ""));
                    if (escaStatuses.size() == 1) {
                        configProperties.add(new ConfigProperty(configProperties.size() * 100, "noEscalationWarningActions", "KeyLabel", this.translate(settings, HDConfigKeys.ESCALATION_WARNING_ACTION.getKey(), new Object[0]), (Object)this.translate(settings, "noEscalationWarningActions", new Object[0]), null, null));
                    } else {
                        this.addSelectTo(configProperties, HDConfigKeys.ESCALATION_WARNING_ACTION.getKey(), String.valueOf(currentValue), "SimpleText", settings, escaStatuses);
                    }
                }
                ArrayList<UnitConfigProperty.Unit> units = new ArrayList<UnitConfigProperty.Unit>();
                units.add(new UnitConfigProperty.Unit(60.0, this.translate(settings, "mail.timer.minutes", new Object[0])));
                units.add(new UnitConfigProperty.Unit(1.0, this.translate(settings, "mail.timer.hours", new Object[0])));
                this.addUnitTo(configProperties, HDConfigKeys.TICKET_WARNING_YELLOW_ESCALATION_THRESHOLD, settings, units);
                this.addUnitTo(configProperties, HDConfigKeys.TICKET_WARNING_RED_ESCALATION_THRESHOLD, settings, units);
                break;
            }
            case "helpdesk.tickets.deadline": {
                ArrayList<UnitConfigProperty.Unit> units = new ArrayList<UnitConfigProperty.Unit>();
                units.add(new UnitConfigProperty.Unit(60.0, this.translate(settings, "mail.timer.minutes", new Object[0])));
                units.add(new UnitConfigProperty.Unit(1.0, this.translate(settings, "mail.timer.hours", new Object[0])));
                this.addUnitTo(configProperties, HDConfigKeys.TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD, settings, units);
                this.addUnitTo(configProperties, HDConfigKeys.TICKET_WARNING_RED_DEADLINE_THRESHOLD, settings, units);
            }
        }
    }

    private String getTicketFieldSettingsURL() {
        Object targetURL = "configmanager/page/configuration.ticket.ticketsettings/dialog/category.fields.tickets";
        String rootURL = SessionStore.getRootURL();
        targetURL = rootURL != null ? rootURL + (String)targetURL : "../" + (String)targetURL;
        return targetURL;
    }

    private List<LocalizedKey> getActionsWithCustomNonDeletedEndStatusBetweenOrIncludingCurrentValue(int min, int max, Set<Integer> toNotSet, Integer currentValue) {
        Set<Integer> deletedStatuses = this.getDeletedStatuses();
        return ActionManager.getInstance().getAll(false).stream().filter(action -> !toNotSet.contains(action.getStatusID()) && action.getStatusID() >= min && action.getStatusID() <= max && (!action.isDeleted() || action.getId() == currentValue.intValue()) && !deletedStatuses.contains(action.getStatusID())).map(action -> new LocalizedKey("" + action.getId(), action.getDisplayValue())).collect(Collectors.toList());
    }

    private Set<Integer> getDeletedStatuses() {
        HashSet<Integer> result = new HashSet<Integer>();
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement st = con.prepareStatement("select Status from tblStatus where geloescht = 1");
             ResultSet rs = st.executeQuery();){
            while (rs.next()) {
                int status = rs.getInt(1);
                result.add(status);
            }
        }
        catch (Throwable e) {
            HDLogger.error(e);
        }
        return result;
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        if (key.equals(LocationListConfigProperty.propertyKey(false))) {
            List changedValueRaw = (List)settings.getChangedValue(LocationListConfigProperty.propertyKey(false), List.class);
            if (changedValueRaw != null) {
                for (Map element : changedValueRaw) {
                    element.remove("hide");
                }
                Json json = new Json();
                LocationList list = (LocationList)json.fromJson(json.toJson((Object)changedValueRaw), LocationList.class);
                LocationManager m = LocationManager.getInstance();
                List all = m.getAll(false);
                ArrayList<Integer> ids = new ArrayList<Integer>(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
                for (LocationVO c : list) {
                    LocationVO old = (LocationVO)m.get(c.getId());
                    try {
                        ids.remove((Object)c.getId());
                        if (old == null) {
                            m.add(c);
                            continue;
                        }
                        m.update(c);
                    }
                    catch (SQLException e) {
                        ids.add(c.getId());
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                }
                return ConfigStructure.SaveState.SAVE;
            }
        } else if (key.equals(LocationListConfigProperty.propertyKey(true))) {
            List changedValueRaw = (List)settings.getChangedValue(LocationListConfigProperty.propertyKey(true), List.class);
            if (changedValueRaw != null) {
                for (Map element : changedValueRaw) {
                    element.remove("hide");
                    element.put("geloescht", "true");
                }
                Json json = new Json();
                LocationList list = (LocationList)json.fromJson(json.toJson((Object)changedValueRaw), LocationList.class);
                LocationManager m = LocationManager.getInstance();
                List all = m.getAll(false);
                ArrayList<Integer> ids = new ArrayList<Integer>(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
                for (LocationVO c : list) {
                    LocationVO old = (LocationVO)m.get(c.getId());
                    try {
                        ids.remove((Object)c.getId());
                        if (old == null) {
                            m.add(c);
                            continue;
                        }
                        m.update(c);
                    }
                    catch (SQLException e) {
                        ids.add(c.getId());
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                }
                return ConfigStructure.SaveState.SAVE;
            }
        } else if (key.equals("UserClasses")) {
            List changedValueRaw = (List)settings.getChangedValue("UserClasses", List.class);
            if (changedValueRaw != null) {
                UserClassManager m = UserClassManager.getInstance();
                List all = m.getAll(false);
                ArrayList ids = new ArrayList(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
                for (Map team : changedValueRaw) {
                    int id = Integer.valueOf((String)team.get("id"));
                    int prio = Integer.valueOf((String)team.get("DefaultPrio"));
                    int res = Integer.valueOf((String)team.get("DefaultResource"));
                    String supervisors = (String)team.get("Supervisors");
                    TargetValue users = (TargetValue)new Json().fromJson(supervisors, TargetValue.class);
                    UserClassVO old = (UserClassVO)m.get(id);
                    UserClassVO newVO = new UserClassVO(id, (String)team.get("ClassName"), prio, res, false);
                    try {
                        if (old == null) {
                            id = m.add(newVO);
                        } else {
                            m.update(newVO);
                        }
                        ids.remove((Object)id);
                        UserClassesListConfigProperty.updateSupervisors(id, users);
                    }
                    catch (SQLException e) {
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                }
                ids.forEach(i -> {
                    try {
                        UserClassVO locationVO = (UserClassVO)m.get((int)i);
                        m.update(new UserClassVO(locationVO.getId(), locationVO.getDisplayValue(), locationVO.getSLAID(), locationVO.getDefaultAuthorisationResource(), true));
                    }
                    catch (SQLException e) {
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                });
                return ConfigStructure.SaveState.SAVE;
            }
        } else if (key.equals("Classifications")) {
            List changedValueRaw = (List)settings.getChangedValue("Classifications", List.class);
            if (changedValueRaw != null) {
                List<String> serializedImageData = TicketValueIconConfigProperty.getSerializedImageData(changedValueRaw);
                for (Map element : changedValueRaw) {
                    element.remove("hide");
                }
                Json json = new Json();
                ClassificationList list = (ClassificationList)json.fromJson(json.toJson((Object)changedValueRaw), ClassificationList.class);
                ClassificationManager m = ClassificationManager.getInstance();
                List all = m.getAll(false);
                ArrayList<Integer> ids = new ArrayList<Integer>(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
                for (ClassificationVO c : list) {
                    ClassificationVO old = (ClassificationVO)m.get(c.getId());
                    try {
                        String relativePath;
                        ids.remove((Object)c.getId());
                        if (old == null) {
                            m.add(c);
                        } else {
                            m.update(c);
                        }
                        if ((relativePath = TicketValueIconConfigProperty.storeIcons(serializedImageData, 3, c.getId(), c.getImageName())) == null) continue;
                        m.update(new ClassificationVO(c.getId(), c.getDisplayValue(), c.getInfo(), relativePath, c.isDeleted()));
                    }
                    catch (SQLException e) {
                        ids.add(c.getId());
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                }
                ids.forEach(i -> {
                    try {
                        ClassificationVO c = (ClassificationVO)m.get((int)i);
                        m.update(new ClassificationVO(c.getId(), c.getDisplayValue(), c.getInfo(), c.getImageName(), true));
                    }
                    catch (SQLException e) {
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                });
                return ConfigStructure.SaveState.SAVE;
            }
        } else {
            if (key.equals("Categories")) {
                List cats = (List)new Json().fromJson(value, List.class);
                if (cats != null) {
                    this.correctCategoryValuesFromClient(cats);
                }
                CategoryList list = (CategoryList)new Json().fromJson(new Json().toJson((Object)cats), CategoryList.class);
                CategoryManager m = CategoryManager.getInstance();
                List all = m.getAll(false);
                ArrayList ids = new ArrayList(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
                HashMap<CallSite, CallSite> oldIdToNewId = new HashMap<CallSite, CallSite>();
                for (CategoryVO c : list) {
                    int originalID = c.getId();
                    CategoryVO old = (CategoryVO)m.get(originalID);
                    try {
                        if (old == null) {
                            if (originalID < 0) {
                                Map map = (Map)new Json().fromJson(new Json().toJson((Object)c), Map.class);
                                map.put("id", -1);
                                c = (CategoryVO)new Json().fromJson(new Json().toJson((Object)map), CategoryVO.class);
                            }
                            if (c.getParentCategoryID() < 0) {
                                Map map = (Map)new Json().fromJson(new Json().toJson((Object)c), Map.class);
                                String newID = (String)oldIdToNewId.get(((Integer)map.get("ParentID")).toString());
                                if (newID != null) {
                                    map.put("ParentID", Integer.valueOf(newID));
                                }
                                c = (CategoryVO)new Json().fromJson(new Json().toJson((Object)map), CategoryVO.class);
                            }
                            int newID = m.add(c);
                            oldIdToNewId.put((CallSite)((Object)("" + originalID)), (CallSite)((Object)("" + newID)));
                        } else {
                            m.update(c);
                        }
                        ids.remove((Object)originalID);
                    }
                    catch (SQLException e) {
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                }
                ids.forEach(i -> {
                    try {
                        CategoryVO categoryVO = (CategoryVO)m.get((int)i);
                        m.update(new CategoryVO(categoryVO.getId(), categoryVO.getDisplayValue(), categoryVO.getParentCategoryID(), categoryVO.getResourceID(), categoryVO.isHidden(), true, categoryVO.getAbsender()));
                    }
                    catch (SQLException e) {
                        HDLogger.error(e);
                        throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                    }
                });
                if (!ids.isEmpty()) {
                    EmailAccountList emailAccountList = (EmailAccountList)new Json().fromJson(settings.getValue(HDConfigKeys.MAIL_ACCOUNTS), EmailAccountList.class);
                    emailAccountList.forEach(account -> {
                        if (account.getCategoryId() != null && ids.contains(account.getCategoryId())) {
                            account.setCategoryId(null);
                        }
                    });
                    settings.save(HDConfigKeys.MAIL_ACCOUNTS, new Json().toJson((Object)emailAccountList));
                }
                return ConfigStructure.SaveState.SAVE;
            }
            if (key.equals(HDConfigKeys.TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD.getKey()) || key.equals(HDConfigKeys.TICKET_WARNING_RED_DEADLINE_THRESHOLD.getKey()) || key.equals(HDConfigKeys.TICKET_WARNING_YELLOW_ESCALATION_THRESHOLD.getKey()) || key.equals(HDConfigKeys.TICKET_WARNING_RED_ESCALATION_THRESHOLD.getKey())) {
                if (value != null && value.trim().length() > 0) {
                    DecimalFormat formatter = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.US));
                    value = formatter.format(Double.valueOf(value));
                } else {
                    value = "";
                }
                settings.save(key, value);
                return ConfigStructure.SaveState.SAVE;
            }
            if (key.equals("Priorities")) {
                List changedValueRaw = (List)settings.getChangedValue("Priorities", List.class);
                if (changedValueRaw != null) {
                    List<String> serializedImageData = TicketValueIconConfigProperty.getSerializedImageData(changedValueRaw);
                    for (Map element : changedValueRaw) {
                        element.remove("IsDefault");
                        element.remove("allids");
                        element.remove("hide");
                        element.remove("isNewlyCreated");
                        if ("".equals(((String)element.get("DeadLine")).trim())) {
                            element.put("DeadLine", "0");
                        }
                        if (!"".equals(((String)element.get("EskaZeit")).trim())) continue;
                        element.put("EskaZeit", "0");
                    }
                    Json json = new Json();
                    PriorityList list = (PriorityList)json.fromJson(json.toJson((Object)changedValueRaw), PriorityList.class);
                    PriorityManager m = PriorityManager.getInstance();
                    List all = m.getAll(false);
                    ArrayList ids = new ArrayList(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
                    for (PriorityVO c : list) {
                        PriorityVO old = (PriorityVO)m.get(c.getId());
                        try {
                            String relativePath;
                            ids.remove((Object)c.getId());
                            if (old == null) {
                                m.add(c);
                            } else {
                                m.update(c);
                            }
                            if ((relativePath = TicketValueIconConfigProperty.storeIcons(serializedImageData, 2, c.getId(), c.getImageName())) == null) continue;
                            m.update(new PriorityVO(c.getId(), c.getDisplayValue(), c.getEscalationTimeout(), c.getDeadline(), relativePath, c.isDeleted()));
                        }
                        catch (SQLException e) {
                            HDLogger.error(e);
                            throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                        }
                    }
                    ids.forEach(i -> {
                        try {
                            PriorityVO p = (PriorityVO)m.get((int)i);
                            m.update(new PriorityVO(p.getId(), p.getDisplayValue(), p.getEscalationTimeout(), p.getDeadline(), p.getImageName(), true));
                        }
                        catch (SQLException e) {
                            HDLogger.error(e);
                            throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                        }
                    });
                    return ConfigStructure.SaveState.SAVE;
                }
            } else if (key.equals(HDConfigKeys.DEFAULT_PRIO_SELECTION.getKey())) {
                ConfigurationManager.getInstance().getCurrent().put(HDConfigKeys.DEFAULT_PRIO_SELECTION.getKey(), value);
                return ConfigStructure.SaveState.SAVE;
            }
        }
        return ConfigStructure.SaveState.NONE;
    }

    private String translate(ConfigStructureSettings settings, String[] t) {
        if (t != null && t.length > 0) {
            if (t.length == 1) {
                return this.translate(settings, t[0], new Object[0]);
            }
            return this.translate(settings, t[0], Arrays.copyOfRange(t, 1, t.length));
        }
        return null;
    }

    public void validate(String categoryKey, ArrayList<ConfigValidationMsg> messages, ArrayList<ConfigConditionAction> conditions, ConfigStructureSettings settings) {
        List cats;
        if ("location.new".equals(categoryKey)) {
            ConfigValidator configValidator = new ConfigValidator(messages, settings);
            configValidator.checkNotEmpty("GebBezeichnung");
            configValidator.validateStringLength("GebBezeichnung", 0, 255);
            configValidator.validateStringLength("Kommentar", 0, 100);
            configValidator.validateStringLength("Adresse", 0, 1000);
        } else if (CATEGORY_LOCATIONS.equals(categoryKey)) {
            List changedValueRaw = (List)settings.getChangedValue("Locations", List.class);
            if (changedValueRaw != null) {
                for (Map element : changedValueRaw) {
                    element.remove("hide");
                }
                Json json = new Json();
                LocationList list = (LocationList)json.fromJson(json.toJson((Object)changedValueRaw), LocationList.class);
                HashSet<String> names = new HashSet<String>();
                for (LocationVO locationVO : list) {
                    String name2 = locationVO.getDisplayValue();
                    if (names.contains(name2)) {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "nameAlreadyExists", new Object[]{name2}), "Locations"));
                        continue;
                    }
                    names.add(name2);
                }
            }
        } else if ("class.new".equals(categoryKey)) {
            ConfigValidator configValidator = new ConfigValidator(messages, settings);
            configValidator.checkNotEmpty("ClassName");
            configValidator.validateStringLength("ClassName", 0, 255);
        } else if (CATEGORY_CLASSES.equals(categoryKey)) {
            List changedValueRaw = (List)settings.getChangedValue("UserClasses", List.class);
            if (changedValueRaw != null) {
                HashSet<String> names = new HashSet<String>();
                for (Map team : changedValueRaw) {
                    String name3 = (String)team.get("ClassName");
                    if (names.stream().anyMatch(n -> n.equalsIgnoreCase(name3))) {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "nameAlreadyExists", new Object[]{name3}), "UserClasses"));
                        continue;
                    }
                    names.add(name3);
                }
            }
        } else if (CATEGORY_CLASSIFICATIONS.equals(categoryKey)) {
            List changedValueRaw = (List)settings.getChangedValue("Classifications", List.class);
            if (changedValueRaw != null) {
                TicketValueIconConfigProperty.getSerializedImageData(changedValueRaw);
                for (Map element : changedValueRaw) {
                    element.remove("hide");
                }
                Json json = new Json();
                ClassificationList list = (ClassificationList)json.fromJson(json.toJson((Object)changedValueRaw), ClassificationList.class);
                HashSet<String> names = new HashSet<String>();
                for (ClassificationVO classificationVO : list) {
                    String name4 = classificationVO.getDisplayValue();
                    if (names.contains(name4)) {
                        messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "nameAlreadyExists", new Object[]{name4}), "Classifications"));
                        continue;
                    }
                    names.add(name4);
                }
            }
        } else if ("classification.new".equals(categoryKey)) {
            if (!"0".equals(settings.getValue("id"))) {
                ConfigValidator validator = new ConfigValidator(messages, settings);
                validator.checkNotEmpty("KlassenName");
                validator.validateStringLength("KlassenName", 0, 50);
            }
        } else if (CATEGORY_SCHWELLWERTE.equals(categoryKey)) {
            ConfigValidator validator = new ConfigValidator(messages, settings);
            if (Double.valueOf(settings.getValue(HDConfigKeys.TICKET_WARNING_RED_DEADLINE_THRESHOLD)) != 0.0 || Double.valueOf(settings.getValue(HDConfigKeys.TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD)) != 0.0) {
                validator.validateUnitNumberRange(HDConfigKeys.TICKET_WARNING_RED_DEADLINE_THRESHOLD.getKey(), settings.getValue(HDConfigKeys.TICKET_WARNING_RED_DEADLINE_THRESHOLD), 0.25, 1000.0, "h");
                double minForYellowDeadline = Double.valueOf(settings.getValue(HDConfigKeys.TICKET_WARNING_RED_DEADLINE_THRESHOLD)) + 0.25;
                validator.validateUnitNumberRange(HDConfigKeys.TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD.getKey(), settings.getValue(HDConfigKeys.TICKET_WARNING_YELLOW_DEADLINE_THRESHOLD), minForYellowDeadline, 1000.0, "h");
            }
            if (Double.valueOf(settings.getValue(HDConfigKeys.TICKET_WARNING_RED_ESCALATION_THRESHOLD)) != 0.0 || Double.valueOf(settings.getValue(HDConfigKeys.TICKET_WARNING_YELLOW_ESCALATION_THRESHOLD)) != 0.0) {
                validator.validateUnitNumberRange(HDConfigKeys.TICKET_WARNING_RED_ESCALATION_THRESHOLD.getKey(), settings.getValue(HDConfigKeys.TICKET_WARNING_RED_ESCALATION_THRESHOLD), 0.25, 1000.0, "h");
                double minForYellowEscalation = Double.valueOf(settings.getValue(HDConfigKeys.TICKET_WARNING_RED_ESCALATION_THRESHOLD)) + 0.25;
                validator.validateUnitNumberRange(HDConfigKeys.TICKET_WARNING_YELLOW_ESCALATION_THRESHOLD.getKey(), settings.getValue(HDConfigKeys.TICKET_WARNING_YELLOW_ESCALATION_THRESHOLD), minForYellowEscalation, 1000.0, "h");
            }
        } else if ("category.new".equals(categoryKey)) {
            ConfigValidator validator = new ConfigValidator(messages, settings);
            validator.validateStringLength("Betreff", 1, 49);
            if (messages.size() == 0) {
                Object label;
                String allcatsJson;
                String absender = settings.getValue("absender");
                if (absender != null && !absender.trim().isEmpty()) {
                    validator.validateEmail(absender, "absender");
                }
                if ((allcatsJson = settings.getChangedValue("allcats")) == null) {
                    allcatsJson = "[]";
                }
                List allcats = (List)new Json().fromJson(allcatsJson, List.class);
                HashSet catNames = new HashSet(allcats);
                String chosenName = settings.getValue("Betreff");
                Object parentPrefix = "";
                String parentID = settings.getValue("ParentID");
                if (parentID != null && parentID.startsWith("{") && !"".equals(label = ((Map)new Json().fromJson(parentID, Map.class)).get("label"))) {
                    parentPrefix = String.valueOf(label) + "\\";
                }
                String parent = parentPrefix;
                Collator collator = Collator.getInstance();
                collator.setStrength(0);
                collator.setDecomposition(1);
                if (catNames.stream().anyMatch(name -> collator.compare((String)name, parent + chosenName) == 0)) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "categoryNameAlreadyExists", new Object[0]), "Name"));
                }
            }
        } else if ("priority.new".equals(categoryKey)) {
            ConfigValidator validator = new ConfigValidator(messages, settings);
            validator.checkNotEmpty("PriBezeichnung");
            validator.validateStringLength("PriBezeichnung", 0, 50);
            validator.checkNotEmpty("id");
            if (validator.checkNotEmpty("DeadLine")) {
                validator.validateUnitNumberRange("DeadLine", settings.getValue("DeadLine"), 0.0, 20000.0, "h");
            }
            if (validator.checkNotEmpty("EskaZeit")) {
                validator.validateUnitNumberRange("EskaZeit", settings.getValue("EskaZeit"), 0.0, 20000.0, "h");
            }
            if ("true".equals(settings.getValue("isNewlyCreated"))) {
                String id = settings.getChangedValue("id");
                validator.validateNumberRange("id", id, 0L, 1000000L);
                String allidsJson = settings.getValue("allids");
                List allids = (List)new Json().fromJson(allidsJson, List.class);
                Set idSet = allids.stream().map(s -> Integer.valueOf(s)).collect(Collectors.toSet());
                if (id != null && !id.trim().isEmpty()) {
                    try {
                        int idInt = Integer.parseInt(id);
                        if (idSet.contains(idInt)) {
                            messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "priorityIDAlreadyExists", new Object[0]), "id"));
                        }
                    }
                    catch (NumberFormatException idInt) {}
                }
            }
        } else if (CATEGORY_CATEGORIES.equals(categoryKey) && (cats = (List)settings.getChangedValue("Categories", List.class)) != null) {
            this.correctCategoryValuesFromClient(cats);
            CategoryList list = (CategoryList)new Json().fromJson(new Json().toJson((Object)cats), CategoryList.class);
            CategoryManager m = CategoryManager.getInstance();
            List all = m.getAll(false);
            ArrayList ids = new ArrayList(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
            for (CategoryVO c : list) {
                int originalID = c.getId();
                ids.remove((Object)originalID);
            }
            if (!ids.isEmpty()) {
                EmailAccountList emailAccountList = (EmailAccountList)new Json().fromJson(settings.getValue(HDConfigKeys.MAIL_ACCOUNTS), EmailAccountList.class);
                StringBuilder accountNames = new StringBuilder();
                ids.forEach(i -> {
                    if (((CategoryVO)m.get((int)i)).isDeleted()) {
                        return;
                    }
                    emailAccountList.forEach(account -> {
                        if (account.getCategoryId() != null && account.getCategoryId().intValue() == i.intValue()) {
                            if (accountNames.length() == 0) {
                                accountNames.append(account.getAccount());
                            } else {
                                accountNames.append(", ").append(account.getAccount());
                            }
                        }
                    });
                });
                if (accountNames.length() > 0) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Confirmation, this.translate(settings, "categoryDeleteWillRemoveFromMailAccount", new Object[]{accountNames.toString()}), "Categories"));
                }
            }
            if (Tickets.FIELD_CATEGORY_ID.getEnduserEditability() != MandatoryFieldVO.MandatoryType.HIDDEN && list.stream().allMatch(vo -> vo.isEffectivelyHidden(child -> list.stream().filter(c -> c.getId() == child.getParentCategoryID().intValue()).findFirst().orElse(null)))) {
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "category.error.allhiddenforEndusers", new Object[0]), "Categories"));
            }
        }
    }

    private void correctCategoryValuesFromClient(List<Map<String, String>> cats) {
        for (Map<String, String> catMap : cats) {
            String parentID = catMap.get("ParentID");
            if (parentID.startsWith("{")) {
                catMap.put("ParentID", (String)((Map)new Json().fromJson(parentID, Map.class)).get("key"));
            }
            if ("".equals(catMap.get("ParentID"))) {
                catMap.put("ParentID", "0");
            }
            String resID = catMap.get("ResID");
            catMap.remove("DisplayResID");
            catMap.remove("DisplayUserInVis");
            catMap.remove("InheritUserInVis");
            catMap.remove("path");
            catMap.remove("level");
            catMap.remove("allcats");
            if (resID.startsWith("{")) {
                catMap.put("ResID", (String)((Map)new Json().fromJson(resID, Map.class)).get("key"));
            }
            catMap.remove("isNewlyCreated");
            catMap.remove("inheritedResource");
        }
    }

    @Nullable
    public List<LocalizedKey> getSelectValues(@Nonnull String key, String filter, ConfigStructureSettings settings) {
        if ("ParentID".equals(key)) {
            String categoriesJson = settings.getValue("Categories");
            if (categoriesJson == null) {
                return new ArrayList<LocalizedKey>();
            }
            List categories = (List)new Json().fromJson(categoriesJson, List.class);
            String myID = settings.getValue("id") == null ? "" : settings.getValue("id");
            String myPath = categories.stream().filter(m -> myID.equals(m.get("id"))).map(m -> (String)m.get("path")).filter(Objects::nonNull).findFirst().orElse("");
            List idsWithMeAsAncestor = categories.stream().filter(m -> m.get("path") != null && ((String)m.get("path")).startsWith(myPath + "\\")).map(m -> (String)m.get("id")).collect(Collectors.toList());
            List<LocalizedKey> result = categories.stream().map(v -> {
                String path;
                String id = (String)v.get("id");
                if (id == null) {
                    id = "";
                }
                if ((path = (String)v.get("path")) == null) {
                    path = "";
                }
                return new LocalizedKey(id, path);
            }).sorted((o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName())).filter(l -> !l.getKey().equals(myID) && !idsWithMeAsAncestor.contains(l.getKey()) && (filter.trim().isEmpty() || l.getDisplayName().toLowerCase().contains(filter.toLowerCase()))).collect(Collectors.toList());
            return result;
        }
        if ("ResID".equals(key)) {
            List<Object> result = LocalizedKeyListFactory.getResources(false);
            result = result.stream().filter(k -> k.getDisplayName().toLowerCase().contains(filter.toLowerCase())).sorted((o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName())).collect(Collectors.toList());
            result.add(0, new LocalizedKey("0", this.translate(settings, "category.inheritFromParent", new Object[0])));
            return result;
        }
        return super.getSelectValues(key, filter, settings);
    }
}

