/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.attachmentdisplay;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.attachmentdisplay.AttachmentDisplayProvider;
import com.inet.helpdesk.plugins.attachments.server.AttachmentService;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentFileRow;
import com.inet.helpdesk.plugins.attachments.server.model.AttachmentRow;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ServerPluginManager;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class HtmlTextAttachmentDisplayProvider
implements AttachmentDisplayProvider {
    @Override
    public String getType() {
        return "htmltext";
    }

    @Override
    public String getSourceOrContent(String mimeType, AttachmentRow attachment) {
        block11: {
            String string;
            block12: {
                PersistenceEntry file;
                AttachmentService attService = (AttachmentService)ServerPluginManager.getInstance().getSingleInstance(AttachmentService.class);
                AttachmentFileRow attachmentFile = attService.getAttachmentFile(attachment.getChecksum(), attachment.getFileLength());
                if (attachmentFile == null || !(file = AppDataLocation.getAttachmentFile(attachmentFile.getFilePath())).exists()) break block11;
                InputStream input = file.getInputStream();
                try {
                    int index;
                    Charset charSet = StandardCharsets.UTF_8;
                    if (mimeType != null && (index = mimeType.indexOf("; charset=")) > 0) {
                        String cs = mimeType.substring(index + 10);
                        try {
                            charSet = Charset.forName(cs);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    String content = IOFunctions.readString((InputStream)input, (Charset)charSet);
                    string = content = TicketTextFunctions.getInlinedHtml(content, true);
                    if (input == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        LogManager.getApplicationLogger().error(t);
                    }
                }
                input.close();
            }
            return string;
        }
        return "";
    }

    @Override
    public boolean isResponsible(String mimeType, AttachmentRow attachment) {
        String fileNameLowerCase;
        if (attachment.getFileLength() > 0x200000L) {
            return false;
        }
        if (mimeType != null && (mimeType.equals("text/html") || mimeType.startsWith("text/html;"))) {
            return true;
        }
        String fileName = attachment.getFileName();
        return fileName != null && ((fileNameLowerCase = fileName.toLowerCase()).endsWith(".htm") || fileNameLowerCase.endsWith(".html"));
    }
}

