/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleDTD {
    private static Map<NodeFactory.TAG, List<NodeFactory.TAG>> children = new HashMap<NodeFactory.TAG, List<NodeFactory.TAG>>();
    private static Map<NodeFactory.TAG, List<List<NodeFactory.TAG>>> parents = new HashMap<NodeFactory.TAG, List<List<NodeFactory.TAG>>>();

    private static void addLink(NodeFactory.TAG parent, NodeFactory.TAG ... children) {
        SimpleDTD.children.put(parent, Arrays.asList(children));
    }

    private static void computeParents(NodeFactory.TAG root, List<NodeFactory.TAG> parentNodes) {
        List<List<NodeFactory.TAG>> parentList = parents.get((Object)root);
        if (parentList == null) {
            parentList = new ArrayList<List<NodeFactory.TAG>>();
            parents.put(root, parentList);
        }
        parentList.add(parentNodes);
        parentNodes = new ArrayList<NodeFactory.TAG>(parentNodes);
        parentNodes.add(root);
        List<NodeFactory.TAG> children = SimpleDTD.children.get((Object)root);
        if (children != null) {
            for (NodeFactory.TAG child : children) {
                SimpleDTD.computeParents(child, parentNodes);
            }
        }
    }

    public static List<List<NodeFactory.TAG>> getParents(NodeFactory.TAG tag) {
        return parents.get((Object)tag);
    }

    public static List<NodeFactory.TAG> getValidChildren(NodeFactory.TAG tag) {
        return children.get((Object)tag);
    }

    static {
        NodeFactory factory = new NodeFactory();
        for (NodeFactory.TAG tag : NodeFactory.TAG.values()) {
            Node node = factory.createNode(tag.toString());
            if (node == null) continue;
            NodeFactory.TAG[] allowedChildren = node.getAllowedChildren();
            if (allowedChildren == null) {
                allowedChildren = new NodeFactory.TAG[]{};
            }
            SimpleDTD.addLink(tag, allowedChildren);
        }
        SimpleDTD.computeParents(NodeFactory.TAG.dbupdater, new ArrayList<NodeFactory.TAG>());
    }
}

