/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.shared.util.TypespecificIntMap;
import java.util.ArrayList;
import java.util.HashMap;
import srv.mail.DeliveryStatusInformation;

public class BlackListHandler {
    protected static final long TWELFE_HOURS = 43200000L;
    protected static final long THREE_HOURS = 10800000L;
    private static final int MAXIMUM_NUMBER_OF_MAILS_PER_ADDRESS_AND_TICKET = 100;
    private static TypespecificIntMap<TicketMailInformations> mailStatistics = new TypespecificIntMap();
    private static HashMap<String, BlackListEntry> addressBlackList = new HashMap();
    private static TypespecificIntMap<ArrayList<BlackListEntry>> ticketBlackList = new TypespecificIntMap();
    private static final BlackListHandler INSTANCE = new BlackListHandler();

    public static BlackListResponseType mailRecieved(int ticketID, String senderAddress) {
        if (senderAddress == null || senderAddress.trim().length() == 0) {
            HDLogger.warn("BlackListHandler no address " + String.valueOf((Object)BlackListResponseType.SUPPRESS_ANSWER));
            return BlackListResponseType.SUPPRESS_ANSWER;
        }
        return INSTANCE.mailRecievedInternal(ticketID, senderAddress.toLowerCase());
    }

    private static void selfCheck() {
        int[] keys;
        for (int key : keys = mailStatistics.getAllKeys()) {
            TicketMailInformations tm = mailStatistics.get(key);
            if (tm.getRelevantMailsCount() != 0) continue;
            mailStatistics.remove(key);
        }
    }

    public static BlackListEntry checkForBlackListEntry(String senderAddress, int ticketID) {
        ArrayList<BlackListEntry> entryList;
        BlackListEntry be;
        BlackListEntry blackListEntry = be = (senderAddress = senderAddress.toLowerCase()).length() > 0 ? addressBlackList.get(senderAddress) : null;
        if (be != null && !BlackListHandler.isValid(be)) {
            addressBlackList.remove(senderAddress);
            be = null;
        }
        if (be == null && (entryList = ticketBlackList.get(ticketID)) != null) {
            for (int i = entryList.size() - 1; i > -1; --i) {
                BlackListEntry entry = entryList.get(i);
                if (BlackListHandler.isValid(entry)) {
                    if (!entry.isSuppressAutomailing() && !senderAddress.equals(entry.getStatusInfo().getRecipient())) continue;
                    be = entry;
                    break;
                }
                entryList.remove(i);
            }
        }
        return be;
    }

    private static boolean isValid(BlackListEntry be) {
        long expiryDate = BlackListHandler.getExpiryDateForEntry(be);
        return expiryDate == -1L || expiryDate > System.currentTimeMillis();
    }

    private static long getExpiryDateForEntry(BlackListEntry be) {
        if (be.isSuppressAutomailing()) {
            return be.getActivatedTime() + 43200000L;
        }
        if (be.getStatusInfo().isServerStorageProblem() || be.getStatusInfo().isTemporaryFailure()) {
            return be.getActivatedTime() + 10800000L;
        }
        return -1L;
    }

    public static void addToBlackList(int ticketID, DeliveryStatusInformation statusInfo) {
        INSTANCE.addToBlackListInternal(ticketID, statusInfo);
    }

    private void addToBlackListInternal(int ticketID, DeliveryStatusInformation statusInfo) {
        BlackListEntry be = new BlackListEntry(statusInfo);
        if (be.isSuppressAutomailing() || statusInfo.isSizeProblem()) {
            this.addToTicketBlackList(ticketID, be);
        } else if (!statusInfo.isContentProblem() && statusInfo.getRecipient() != null && statusInfo.getRecipient().length() > 0) {
            HDLogger.warn("BlackListHandler add address " + statusInfo.getRecipient());
            addressBlackList.put(statusInfo.getRecipient(), be);
        }
    }

    private void addToTicketBlackList(int ticketID, BlackListEntry be) {
        ArrayList<BlackListEntry> entryList = ticketBlackList.get(ticketID);
        if (entryList == null) {
            entryList = new ArrayList();
            HDLogger.warn("BlackListHandler add ticket #" + ticketID);
            ticketBlackList.put(ticketID, entryList);
        }
        entryList.add(be);
    }

    private synchronized BlackListResponseType mailRecievedInternal(int ticketID, String senderAddress) {
        boolean valid;
        BlackListEntry entry = BlackListHandler.checkForBlackListEntry("", ticketID);
        if (entry != null) {
            entry.setActivatedTime(System.currentTimeMillis());
            HDLogger.warn("BlackListHandler Ticket on black list #" + ticketID);
            return BlackListResponseType.BLACK_LIST;
        }
        BlackListHandler.selfCheck();
        TicketMailInformations tm = mailStatistics.get(ticketID);
        if (tm == null) {
            tm = new TicketMailInformations();
            mailStatistics.put(ticketID, tm);
        }
        tm.mailReceived(senderAddress);
        boolean bl = valid = tm.getMailsCountFromSender(senderAddress) <= 100;
        if (!valid) {
            mailStatistics.remove(ticketID);
            BlackListHandler.addToBlackList(ticketID, DeliveryStatusInformation.getAutoMailCountBlocker());
            HDLogger.warn("BlackListHandler to much list #" + ticketID + " " + senderAddress);
            return BlackListResponseType.ERROR;
        }
        return BlackListResponseType.VALID;
    }

    protected static TicketMailInformations getInfosForTicket(int id) {
        return mailStatistics.get(id);
    }

    public static enum BlackListResponseType {
        VALID,
        BLACK_LIST,
        SUPPRESS_ANSWER,
        ERROR;

    }

    protected class TicketMailInformations {
        ArrayList<MailReceivedInformation> ticketMails = new ArrayList();

        protected TicketMailInformations() {
        }

        private void selfCheck() {
            while (this.ticketMails.size() > 0) {
                MailReceivedInformation rm = this.ticketMails.get(0);
                if (rm.recived + 43200000L >= System.currentTimeMillis()) break;
                this.ticketMails.remove(0);
            }
        }

        private void mailReceived(String sender) {
            this.ticketMails.add(new MailReceivedInformation(sender));
        }

        protected int getRelevantMailsCount() {
            this.selfCheck();
            return this.ticketMails.size();
        }

        protected int getMailsCountFromSender(String sender) {
            sender = sender.toLowerCase();
            this.selfCheck();
            int count = 0;
            for (MailReceivedInformation rm : this.ticketMails) {
                if (!sender.equals(rm.sender)) continue;
                ++count;
            }
            return count;
        }

        protected ArrayList<MailReceivedInformation> getInformationList() {
            return this.ticketMails;
        }
    }

    protected class BlackListEntry {
        private long startTime;
        private DeliveryStatusInformation failure;

        private BlackListEntry(DeliveryStatusInformation failure) {
            this.failure = failure;
            this.setActivatedTime(System.currentTimeMillis());
        }

        private void setActivatedTime(long time) {
            this.startTime = time;
        }

        private long getActivatedTime() {
            return this.startTime;
        }

        protected DeliveryStatusInformation getStatusInfo() {
            return this.failure;
        }

        protected boolean isSuppressAutomailing() {
            return "block".equals(this.failure.getAction());
        }

        protected String getBlackListInformation() {
            return this.failure.getDiagnosticCode();
        }

        protected boolean isSizeProblem() {
            return this.failure.isSizeProblem();
        }
    }

    protected class MailReceivedInformation {
        private long recived;
        private String sender;

        private MailReceivedInformation(String sender) {
            this.sender = sender;
            this.setRecievedTime(System.currentTimeMillis());
        }

        protected void setRecievedTime(long time) {
            this.recived = time;
        }
    }
}

