/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.data.HelpDeskTicketApplyActionRequestData;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

@Tag(name="Tickets", description="Operations for managing HelpDesk tickets")
@InternalApi
public class HelpDeskTicketActionApplyHandler
extends RequestHandler.WithParentPathToken<HelpDeskTicketApplyActionRequestData, ReaStepVO, Integer> {
    public static final String APPLY_REQUEST_HANDLER_NAME = "apply";

    public HelpDeskTicketActionApplyHandler() {
        super(new String[]{APPLY_REQUEST_HANDLER_NAME});
    }

    public String getHelpPageKey() {
        return "webapi.ticket.id.apply";
    }

    @Operation(summary="Apply an action to a ticket", description="Applies a specified action to a ticket, optionally updating ticket fields and adding attachments. The action must be available for the ticket and the user must have write access.", responses={@ApiResponse(responseCode="200", description="Action applied successfully", content={@Content(schema=@Schema(description="The ID of the created reaction step", type="integer", format="int32"))}), @ApiResponse(responseCode="400", description="Invalid request data or action not available for ticket"), @ApiResponse(responseCode="401", description="User not logged in or not authorized"), @ApiResponse(responseCode="403", description="User not authorized to apply action or invalid user GUID provided"), @ApiResponse(responseCode="404", description="Ticket not found")})
    public ReaStepVO handle(HttpServletRequest request, HttpServletResponse response, @Nullable HelpDeskTicketApplyActionRequestData requestData, @Nullable Integer ticketId, boolean previewModeEnabled) throws IOException {
        ticketId = HelpDeskWebAPIHelper.checkTicketWriteAccessOrThrow(ticketId, response);
        TicketVO ticket = TicketManager.getReader().getTicket(ticketId);
        if (ticket == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicket", new Object[0]));
        }
        if (requestData == null) {
            throw new ClientMessageException(WebAPIExtension.getI18nMessages().getMsg("webapi.jsonEmptyError", new Object[0]));
        }
        UserManager userManager = UserManager.getInstance();
        UserAccount currentUserAccount = userManager.getCurrentUserAccount();
        if (currentUserAccount == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.step.apply.noUserLoggedIn", new Object[0]));
        }
        if (currentUserAccount.getID().equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID)) {
            GUID userGUID = requestData.getUserGUID();
            if (userGUID != null && userManager.getUserAccount(userGUID) != null) {
                try (UserAccountScope scope = UserAccountScope.create((GUID)userGUID);){
                    ReaStepVO reaStepVO = this.createReaStepInUserAccountScope(request, response, ticket, requestData, previewModeEnabled);
                    return reaStepVO;
                }
            }
        } else if (requestData.getUserGUID() != null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.step.apply.userGUIDMustNotBeGiven", new Object[0]));
        }
        return this.createReaStepInUserAccountScope(request, response, ticket, requestData, previewModeEnabled);
    }

    private ReaStepVO createReaStepInUserAccountScope(HttpServletRequest request, HttpServletResponse response, TicketVO ticket, HelpDeskTicketApplyActionRequestData requestData, boolean previewModeEnabled) throws IOException {
        MutableTicketData mutableTicketData = HelpDeskWebAPIHelper.createMutableTicketData(requestData.getTicketFields(), ticket);
        MutableReaStepData reaStepData = HelpDeskWebAPIHelper.createMutableReaStepData(requestData.getStepFields());
        ExtensionArguments actionArguments = HelpDeskWebAPIHelper.createActionArguments(requestData.getActionArguments());
        HelpDeskWebAPIHelper.addAttachmentsToActionArguments(actionArguments, request, requestData.getAttachments());
        List<ActionVO> allPossibleActionsForTicket = TicketManager.getTicketActionChecker().getAllPossibleActionsForTicket(ticket.getID());
        if (allPossibleActionsForTicket == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.step.apply.actionNotFound", new Object[]{requestData.getActionId()}));
        }
        Optional<ActionVO> actionOptional = allPossibleActionsForTicket.stream().filter(a -> a.getUniqueID().equals(requestData.getActionId())).findFirst();
        if (!actionOptional.isPresent()) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.step.apply.actionNotFound", new Object[]{requestData.getActionId()}));
        }
        ActionVO action = actionOptional.get();
        if (!mutableTicketData.isEmpty()) {
            MutableTicketData data = actionArguments.get(ExtensionArguments.EXTARG_TICKET_DATA);
            if (data != null) {
                data.putAll(mutableTicketData);
                mutableTicketData = data;
            }
            actionArguments.put(ExtensionArguments.EXTARG_TICKET_DATA, mutableTicketData);
        }
        ReaStepTextVO reastepText = ReaStepTextVO.of(requestData.getText(), requestData.isHtmlContent());
        if (previewModeEnabled) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.previewModeEnabledWhileModifyingCreate", new Object[0]));
        }
        int reaStep = TicketManager.getManipulator().applyAction(ticket.getID(), reaStepData, reastepText, action, actionArguments);
        ResponseWriter.json((HttpServletResponse)response, (Object)reaStep);
        return TicketManager.getReader().getReaStep(reaStep);
    }

    public boolean shouldSendJsonResponse() {
        return false;
    }
}

