/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.helpdesk.config.FieldMapping;
import com.inet.helpdesk.config.FieldMappingEntry;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.model.dataimport.DataImportSchedule;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.FieldValueModifier;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class HDUserImportFieldValueModifier
implements FieldValueModifier {
    public void modifyUserFieldValues(UserAccount userAccount, Map<String, FieldValue> fieldValues) {
        String importName;
        if (userAccount == null) {
            return;
        }
        if (ServerPluginManager.getInstance().isPluginLoaded("dataimport") && !StringFunctions.isEmpty((String)(importName = (String)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_IMPORT_NAME)))) {
            DataImportConnector dic = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
            UserImportConfigInfoMap userImports = dic.getUserImports();
            for (String key : userImports.keySet()) {
                List<FieldMappingEntry> listFme;
                DataImportSchedule schedule;
                UserImportConfigInfo userImportConfigInfo = (UserImportConfigInfo)userImports.get(key);
                if (!userImportConfigInfo.getUid().equals(importName) || (schedule = userImportConfigInfo.getSchedule()).getMainOption().equals((Object)DataImportSchedule.MainTimeOption.MANUAL) || (listFme = userImportConfigInfo.getFieldMapping()) == null) continue;
                ArrayList<String> toBeDisabled = new ArrayList<String>();
                List<String> indexList = Arrays.asList(FieldMapping.DB_COLUMNS);
                for (FieldMappingEntry fieldMappingEntry : listFme) {
                    int index;
                    if (fieldMappingEntry.getSelectedColumn() == null || fieldMappingEntry.getSelectedColumn().length() <= 0 || (index = indexList.indexOf(fieldMappingEntry.getDefininitionColumn()) - 1) <= -1) continue;
                    String currentField = DataImportConnector.USER_IMPORT_USERFIELDS[index];
                    toBeDisabled.add(currentField);
                }
                for (Map.Entry entry : fieldValues.entrySet()) {
                    if (!toBeDisabled.contains(entry.getKey())) continue;
                    ((FieldValue)entry.getValue()).setEnabled(false);
                }
            }
        }
    }

    public void modifyGroupFieldValues(UserGroupInfo group, Map<String, FieldValue> fieldValues) {
    }
}

