/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.dupcontent;

import com.inet.helpdesk.ticketmanager.dupcontent.TagPosition;
import javax.annotation.Nonnull;

class LineContent
extends TagPosition {
    private long hash;
    private int wordCount;
    private int charCount;

    LineContent(@Nonnull TagPosition parent, int from) {
        super(parent, from);
    }

    public int hashCode() {
        return (int)(this.hash ^ this.hash >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.lineEquals((LineContent)obj);
    }

    boolean lineEquals(@Nonnull LineContent other) {
        return this.hash == other.hash && this.wordCount == other.wordCount && this.charCount == other.charCount;
    }

    void addText(char[] data) {
        this.addText(data, 0, data.length);
    }

    void addText(char[] data, int offset, int end) {
        for (int i = offset; i < end; ++i) {
            char ch = data[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\u00a0': {
                    if (i > offset) {
                        this.addWord(data, offset, i);
                    }
                    offset = i + 1;
                }
            }
        }
        if (end > offset) {
            this.addWord(data, offset, end);
        }
    }

    private void addWord(char[] data, int offset, int end) {
        ++this.wordCount;
        this.charCount += end - offset;
        this.hash = 31L * this.hash + (long)LineContent.getHash(data, offset, end);
    }

    private static int getHash(char[] data, int offset, int end) {
        int h = 0;
        while (offset < end) {
            h = 31 * h + data[offset];
            ++offset;
        }
        return h;
    }

    void addWordCount(int diff) {
        this.wordCount += diff;
    }

    int getWordCount() {
        return this.wordCount;
    }
}

