/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.dupcontent;

import com.inet.helpdesk.core.ticketmanager.model.argcontainers.DuplicateRange;
import com.inet.helpdesk.ticketmanager.dupcontent.DuplicateContentParserCallback;
import com.inet.helpdesk.ticketmanager.dupcontent.IdContent;
import com.inet.helpdesk.ticketmanager.dupcontent.LineContent;
import com.inet.helpdesk.ticketmanager.dupcontent.LineIterator;
import com.inet.helpdesk.ticketmanager.dupcontent.TagPosition;
import com.inet.id.GUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DuplicateContentFinder {
    static final int MIN_WORD_COUNT = 50;
    static final int MIN_LINE_COUNT = 3;
    static final int MIN_ROW_COUNT = 2;

    @Nullable
    public List<DuplicateRange> findDuplicatePositions(@Nonnull String content, boolean isHtml, @Nonnull Iterator<IdContent> otherContents, @Nonnull Function<String, String> imageNormalizer) {
        HashMap<String, String> altImageIds = new HashMap<String, String>();
        ArrayList<LineContent> currentLines = this.parse(content, isHtml, imageNormalizer, altImageIds);
        HashMap<LineContent, List> lineMap = new HashMap<LineContent, List>();
        for (int i = currentLines.size() - 1; i >= 0; --i) {
            LineContent line = currentLines.get(i);
            if (line.getWordCount() == 0) continue;
            lineMap.computeIfAbsent(line, l -> new ArrayList()).add(i);
        }
        ArrayList<DuplicateRange> lineMatches = new ArrayList<DuplicateRange>();
        while (otherContents.hasNext()) {
            LineContent otherLine;
            IdContent otherContent = otherContents.next();
            ArrayList<LineContent> otherLines = this.parse(otherContent.getContent(), otherContent.isHtml(), imageNormalizer, altImageIds);
            LineIterator otherIterator = new LineIterator(otherLines);
            while ((otherLine = otherIterator.nextNotEmptyLine()) != null) {
                List idxes = (List)lineMap.get(otherLine);
                if (idxes == null) continue;
                int otherIdx = otherIterator.getIdx();
                for (Integer idx : idxes) {
                    this.checkPossibleMatch(lineMatches, idx, currentLines, otherIterator, otherContent.getId());
                    otherIterator.setIdx(otherIdx);
                }
            }
        }
        if (lineMatches.isEmpty()) {
            return null;
        }
        ArrayList<DuplicateRange> result = new ArrayList<DuplicateRange>();
        for (DuplicateRange lineRange : lineMatches) {
            this.appendCharacterRangeTo(result, currentLines, lineRange);
        }
        return result;
    }

    private void appendCharacterRangeTo(@Nonnull ArrayList<DuplicateRange> result, @Nonnull ArrayList<LineContent> currentLines, @Nonnull DuplicateRange lineRange) {
        int fromLine = lineRange.getFrom();
        int toLine = lineRange.getTo();
        int lineCount = currentLines.size();
        LineContent firstDuplicateLine = currentLines.get(fromLine);
        LineContent lastDuplicateLine = currentLines.get(toLine);
        int notIncludedFromPos = fromLine == 0 ? -1 : currentLines.get(fromLine - 1).getTo();
        int notIncludedToPos = toLine == lineCount - 1 ? Integer.MAX_VALUE : currentLines.get(toLine + 1).getFrom();
        TagPosition firstParent = DuplicateContentFinder.findNotIncludedTopmostParent(firstDuplicateLine, notIncludedFromPos, notIncludedToPos);
        TagPosition lastParent = DuplicateContentFinder.findNotIncludedTopmostParent(lastDuplicateLine, notIncludedFromPos, notIncludedToPos);
        if (firstParent.getParent() == lastParent.getParent()) {
            int from = firstParent.getFrom();
            int to = lastParent.getTo();
            DuplicateRange range = new DuplicateRange(from, to, lineRange.getIds(), GUID.generateNew());
            result.add(range);
        } else {
            GUID uid = GUID.generateNew();
            while (true) {
                TagPosition next = null;
                int to = firstParent.getTo();
                TagPosition parent = firstParent.getParent();
                int maxTo = Math.min(notIncludedToPos, parent != null ? parent.getTo() : to);
                int level = firstParent.getLevel();
                for (int i = fromLine; i <= toLine; ++i) {
                    TagPosition line = currentLines.get(i);
                    int currentTo = line.getTo();
                    if (currentTo <= to) continue;
                    if (currentTo > maxTo) {
                        next = line;
                        break;
                    }
                    while (line.getLevel() > level) {
                        line = line.getParent();
                    }
                    currentTo = line.getTo();
                    if (currentTo > maxTo) {
                        next = currentLines.get(i);
                        break;
                    }
                    to = currentTo;
                }
                result.add(new DuplicateRange(firstParent.getFrom(), to, lineRange.getIds(), uid));
                if (next == null) break;
                firstParent = DuplicateContentFinder.findNotIncludedTopmostParent(next, to, lastParent.getTo());
            }
        }
    }

    private void checkPossibleMatch(@Nonnull ArrayList<DuplicateRange> lineMatches, int toLine, @Nonnull ArrayList<LineContent> currentLines, LineIterator otherIterator, int contentId) {
        LineIterator currentIterator = new LineIterator(currentLines, toLine);
        int lineCount = 1;
        int wordCount = currentLines.get(toLine).getWordCount();
        while (true) {
            LineContent line = currentIterator.nextNotEmptyLine();
            LineContent otherLine = otherIterator.nextNotEmptyLine();
            if (line == null || otherLine == null || !line.lineEquals(otherLine)) {
                if (lineCount >= 3 || wordCount >= 50) {
                    HashSet<Integer> ids = new HashSet<Integer>();
                    ids.add(contentId);
                    for (int i = toLine + 1; i < currentLines.size() && currentLines.get(i).getWordCount() == 0; ++i) {
                        ++toLine;
                    }
                    int fromLine = currentIterator.getIdx() + 1;
                    this.mergeLineRangeTo(lineMatches, new DuplicateRange(fromLine, toLine, ids, null));
                }
                if (otherLine == null) break;
                otherIterator.back();
                break;
            }
            ++lineCount;
            wordCount += line.getWordCount();
        }
    }

    private void mergeLineRangeTo(@Nonnull ArrayList<DuplicateRange> lineMatches, @Nonnull DuplicateRange lineRange) {
        int to = lineRange.getTo();
        int from = lineRange.getFrom();
        HashSet<Integer> ids = lineRange.getIds();
        for (int i = 0; i < lineMatches.size(); ++i) {
            DuplicateRange match = lineMatches.get(i);
            if (match.getTo() == to && match.getFrom() == from) {
                ids.addAll(match.getIds());
                match = new DuplicateRange(from, to, ids, null);
                lineMatches.set(i, match);
                return;
            }
            if (match.getTo() >= to && match.getFrom() <= from && match.getIds().containsAll(ids)) {
                return;
            }
            if (match.getTo() < from - 1 || match.getFrom() > to + 1 || !match.getIds().equals(ids)) continue;
            match = new DuplicateRange(Math.min(match.getFrom(), from), Math.max(match.getTo(), to), ids, null);
            lineMatches.set(i, match);
            return;
        }
        lineMatches.add(lineRange);
    }

    @Nonnull
    private static TagPosition findNotIncludedTopmostParent(@Nonnull TagPosition duplicateLine, int notIncludedFromPos, int notIncludedToPos) {
        TagPosition parent;
        while ((parent = duplicateLine.getParent()) != null && parent.getFrom() >= notIncludedFromPos && parent.getTo() <= notIncludedToPos) {
            duplicateLine = parent;
        }
        return duplicateLine;
    }

    @Nonnull
    private ArrayList<LineContent> parse(@Nonnull String content, boolean isHtml, @Nonnull Function<String, String> imageNormalizer, @Nonnull Map<String, String> altImageIds) {
        if (isHtml) {
            DuplicateContentParserCallback callback = new DuplicateContentParserCallback();
            return callback.parse(content, imageNormalizer, altImageIds);
        }
        return this.parsePlainText(content);
    }

    private ArrayList<LineContent> parsePlainText(@Nonnull String content) {
        ArrayList<LineContent> lines = new ArrayList<LineContent>();
        int length = content.length();
        TagPosition root = new TagPosition(null, 0);
        root.setTo(length);
        int idx = 0;
        int lineStart = 0;
        block4: for (int i = 0; i < length; ++i) {
            char ch = content.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    LineContent currentLine = new LineContent(root, lineStart);
                    lines.add(currentLine);
                    if (i > idx) {
                        char[] data = new char[i - idx];
                        content.getChars(idx, i, data, 0);
                        currentLine.addText(data);
                    }
                    if (ch == '\r' && i + 1 < length && content.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    lineStart = idx = i + 1;
                    currentLine.setTo(idx);
                    continue block4;
                }
                case ' ': 
                case '>': {
                    if (i != idx) continue block4;
                    ++idx;
                }
            }
        }
        if (idx < length) {
            LineContent currentLine = new LineContent(root, lineStart);
            currentLine.setTo(length);
            lines.add(currentLine);
            char[] data = new char[length - idx];
            content.getChars(idx, length, data, 0);
            currentLine.addText(data);
        }
        return lines;
    }
}

