/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server;

import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.report.Engine;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.util.Properties;
import javax.annotation.SuppressFBWarnings;

class HelpDeskPropertiesChecker
implements PropertiesChecker {
    private static final String INTERMEDIATE_FILENAME = "hdreportfilename";

    HelpDeskPropertiesChecker() {
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File location is fixed")
    public void checkProperties(Properties props, Object req) throws ReportException {
        String fileNameProperty;
        String report = props.getProperty("report");
        if (report != null && !IOFunctions.isPathTraversal((String)report)) {
            try {
                File reportFile = new File(AppDataLocation.getPrintDirLocationPath().toFile(), report);
                if (reportFile.isFile()) {
                    String url = reportFile.toString();
                    props.put("report", url);
                }
            }
            catch (InvalidPathException reportFile) {
                // empty catch block
            }
        }
        if ((fileNameProperty = props.getProperty(INTERMEDIATE_FILENAME)) != null) {
            props.setProperty("filename", fileNameProperty);
        }
    }

    public void checkProperties(Engine eng, Properties props, Object req) throws ReportException {
        String reportTitle;
        String exportFormat = props.getProperty("export_fmt");
        if (exportFormat == null || StringFunctions.isEmpty((String)exportFormat)) {
            return;
        }
        String _fileName = props.getProperty("filename");
        if (_fileName != null || !StringFunctions.isEmpty((String)_fileName)) {
            return;
        }
        StringBuilder filename = new StringBuilder();
        String ticketId = props.getProperty("promptticketid");
        if (ticketId != null && !StringFunctions.isEmpty((String)ticketId)) {
            filename.append("#");
            filename.append(ticketId);
            TicketVO ticket = TicketManager.getReader().getTicket(Integer.valueOf(ticketId));
            if (ticket != null) {
                filename.append(" - ");
                filename.append(ticket.getSubject());
            }
        }
        if (!StringFunctions.isEmpty((String)(reportTitle = eng.getReportTitle()))) {
            if (filename.length() > 0) {
                filename.append(" - ");
            }
            filename.append(reportTitle);
        }
        if (!filename.isEmpty()) {
            props.setProperty("filename", filename.toString());
            props.setProperty(INTERMEDIATE_FILENAME, filename.toString());
        }
    }
}

