/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.editor.HtmlConverter;
import com.inet.error.PersistenceException;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.MaintenanceConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReaderForSystem;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManager;
import com.inet.permissions.Permission;
import com.inet.permissions.PermissionCheckScope;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.IndexerStatus;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class MaintenanceConnectorImpl
implements MaintenanceConnector {
    private static final int MAX_ENTRIES_TO_LOAD = 1000;
    private ConnectionFactory connectionFactory;

    public MaintenanceConnectorImpl(ConnectionFactory connectionFactory) {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connection factory must not be null");
        }
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void triggerIndexer() {
        TicketReaderForSystem readerForSystem = TicketManager.getReaderForSystem();
        readerForSystem.getSearchEngine().reIndexAsync();
        readerForSystem.getSlaveInfoEngine().reIndexAsync();
        readerForSystem.getReaStepSearchEngine().reIndexAsync();
    }

    @Override
    public IndexerStatus getIndexerStatus() {
        IndexSearchEngine<Integer> searchEngine = TicketManager.getReaderForSystem().getSearchEngine();
        long toBeIndexed = searchEngine.getIndexCountOfIDs();
        return searchEngine.getIndexerStatus(toBeIndexed);
    }

    @Override
    public IndexerStatus getReaStepIndexerStatus() {
        IndexSearchEngine<Integer> searchEngine = TicketManager.getReaderForSystem().getReaStepSearchEngine();
        long toBeIndexed = searchEngine.getIndexCountOfIDs();
        return searchEngine.getIndexerStatus(toBeIndexed);
    }

    @Override
    public synchronized MaintenanceConnector.TicketsToDelete findAllTicketsMarkedAsDeleted() throws ServerDataException {
        String wherePartOfSqlStatement = TicketReadDAOImpl.createWherePartOfSqlStatementThatFindsAllTicketsMarkedAsDeleted();
        return this.findTickets(wherePartOfSqlStatement, null);
    }

    @Override
    public synchronized void deleteAllTicketsMarkedAsDeleted() throws ServerDataException {
        try {
            TicketManager.getMaintenance().deleteAllTicketsMarkedAsDeleted();
        }
        catch (PersistenceException ex) {
            throw new ServerDataException((Exception)((Object)ex));
        }
    }

    @Override
    public synchronized MaintenanceConnector.TicketsToDelete findTicketsByDate(Date lastModified) throws ServerDataException {
        if (lastModified == null) {
            throw new IllegalArgumentException("lastModified must not be null");
        }
        return this.findTickets(TicketReadDAOImpl.createWherePartOfSqlStatementThatFindsTicketsByDate(), lastModified.getTime());
    }

    @Override
    public synchronized void deleteTicketsByDate(Date lastModified) throws ServerDataException {
        if (lastModified == null) {
            throw new IllegalArgumentException("lastModified must not be null");
        }
        try {
            TicketManager.getMaintenance().deleteTicketsByDate(lastModified.getTime());
        }
        catch (PersistenceException ex) {
            throw new ServerDataException((Exception)((Object)ex));
        }
    }

    @Override
    public synchronized MaintenanceConnector.TicketsToDelete findTicketsById(int fromId, int toId) throws ServerDataException {
        String wherePartOfSqlStatement = TicketReadDAOImpl.createWherePartOfSqlStatementThatFindsTicketsById(fromId, toId);
        return this.findTickets(wherePartOfSqlStatement, null);
    }

    @Override
    public synchronized void deleteTicketsById(int fromId, int toId) throws ServerDataException {
        try {
            TicketManager.getMaintenance().deleteTicketsByID(fromId, toId);
        }
        catch (PersistenceException ex) {
            throw new ServerDataException((Exception)((Object)ex));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    private MaintenanceConnector.TicketsToDelete findTickets(String wherePartOfSqlStatement, @Nullable Long lastModified) throws ServerDataException {
        String findTicketsSql = "SELECT tblAuftraege.AufID FROM tblBuendel, tblAuftraege " + wherePartOfSqlStatement + " ORDER BY tblBuendel.BearbeitungsDatum DESC";
        String countMasterTicketsSql = "SELECT COUNT(tblAuftraege.AufID) FROM tblBuendel, tblAuftraege " + wherePartOfSqlStatement + " AND tblAuftraege.AufID = tblBuendel.BunID";
        String countSlaveTicketsSql = "SELECT COUNT(tblAuftraege.AufID) FROM tblBuendel, tblAuftraege " + wherePartOfSqlStatement + " AND tblAuftraege.AufID <> tblBuendel.BunID";
        StringBuilder loadDataSqlBuilder = new StringBuilder();
        loadDataSqlBuilder.append("SELECT tblBuendel.BunID, tblAuftraege.ResID, tblAuftraege.DerBetreff, tblBuendel.BearbeitungsDatum, tblAuftraege.PriID, tblBuendel.Status, ").append("tblAuftraege.AufID, tblAuftraege.ishtml, tblAuftraege.Auftrag, tblAuftraege.BetID, tblBuendel.AnfrageDatum, tblAuftraege.UsrID, ").append("tblBuendel.Bearbeiter, tblAuftraege.EmailEingang, tblAuftraege.WFID, tblBuendel.SummeZeit, tblBuendel.BunFeld1, tblBuendel.BunFeld2, ").append("tblBuendel.BunFeld3, tblBuendel.BunFeld4, tblAuftraege.spezFeld, tblAuftraege.KlaID, tblAuftraege.ItiID, ").append("tblBuendel.SollZeit, tblAuftraege.DeadlineZeit, tblBuendel.Anlagen, tblAuftraege.Master, tblBuendel.subAuftraege, tblBuendel.TerminVereinbarung ").append("FROM tblBuendel, tblAuftraege ").append(wherePartOfSqlStatement).append(" AND tblAuftraege.AufID = ?").append(" ORDER BY tblBuendel.BearbeitungsDatum DESC");
        ArrayList<Ticket> selectedExemplaryTickets = new ArrayList<Ticket>();
        int masterTicketCount = 0;
        int slaveTicketCount = 0;
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(findTicketsSql);
             PreparedStatement countMasterTicketsPstm = con.prepareStatement(countMasterTicketsSql);
             PreparedStatement countSlaveTicketsPstm = con.prepareStatement(countSlaveTicketsSql);){
            Timestamp timestamp = null;
            if (lastModified != null) {
                timestamp = new Timestamp(lastModified);
                pstm.setTimestamp(1, timestamp);
                countMasterTicketsPstm.setTimestamp(1, timestamp);
                countSlaveTicketsPstm.setTimestamp(1, timestamp);
            }
            try (ResultSet rs = countMasterTicketsPstm.executeQuery();){
                if (rs.next()) {
                    masterTicketCount = rs.getInt(1);
                }
            }
            rs = countSlaveTicketsPstm.executeQuery();
            try {
                if (rs.next()) {
                    slaveTicketCount = rs.getInt(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            rs = pstm.executeQuery();
            try (PreparedStatement loadDataPstm = con.prepareStatement(loadDataSqlBuilder.toString());){
                while (rs.next()) {
                    if (selectedExemplaryTickets.size() >= 6) {
                        return new MaintenanceConnector.TicketsToDelete(masterTicketCount, slaveTicketCount, selectedExemplaryTickets);
                    }
                    int aufId = rs.getInt("AufID");
                    if (timestamp != null) {
                        loadDataPstm.setTimestamp(1, timestamp);
                        loadDataPstm.setInt(2, aufId);
                    } else {
                        loadDataPstm.setInt(1, aufId);
                    }
                    ResultSet loadDataRs = loadDataPstm.executeQuery();
                    try {
                        if (!loadDataRs.next()) continue;
                        Ticket ticket = this.getTicketForResultSet(loadDataRs, con, true, -1);
                        selectedExemplaryTickets.add(ticket);
                    }
                    finally {
                        if (loadDataRs == null) continue;
                        loadDataRs.close();
                    }
                }
                return new MaintenanceConnector.TicketsToDelete(masterTicketCount, slaveTicketCount, selectedExemplaryTickets);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new ServerDataException(ex);
        }
    }

    @Override
    public synchronized MaintenanceConnector.EntriesToDelete<MaintenanceConnector.UnrelatedUser> findUnrelatedUsers() throws ServerDataException {
        return this.findUnrelatedUsers(false, Optional.empty());
    }

    @Override
    public synchronized void deleteUnrelatedUsers() throws ServerDataException {
        this.findUnrelatedUsers(true, Optional.empty());
    }

    @Override
    public synchronized void deleteDeactivatedUsers() throws ServerDataException {
        String findUnrelatedUsersSql = "SELECT UsrID, geloescht FROM tblUser Where tblUser.UsrID > 1 AND tblUser.geloescht = 1";
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        UserGroupManager groupManager = UserGroupManager.getRecoveryEnabledInstance();
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstmFindUnrelatedUsers = con.prepareStatement(findUnrelatedUsersSql);
             ResultSet rs = pstmFindUnrelatedUsers.executeQuery();){
            while (rs.next()) {
                boolean isActiveUser;
                int userID = rs.getInt(1);
                int geloescht = rs.getInt(2);
                UserAccount userAccount = HDUsersAndGroups.getUserAccount(userID, userManager);
                if (userAccount == null) {
                    HDLogger.warn("Could not obtain account for user with ID " + userID);
                    continue;
                }
                if (userAccount.getValue((UserField)UsersAndGroups.FIELD_USER_LOCKED) != null || userAccount.getAccountType() == UserAccountType.Temp) continue;
                boolean bl = isActiveUser = geloescht == 0;
                if (isActiveUser) {
                    boolean isDispatcher = SystemPermissionChecker.hasAnyPermission((PermissionCheckScope)new PermissionCheckScope(userAccount, groupManager), (Permission[])new Permission[]{HdPermissions.DISPATCHER});
                    if (isDispatcher) continue;
                    Set groupsForUser = groupManager.getGroupsForUser(userAccount.getID()).stream().map(UserGroupInfo::getID).collect(Collectors.toSet());
                    groupsForUser.remove(UsersAndGroups.GROUPID_ALLUSERS);
                    groupsForUser.remove(HDUsersAndGroups.GROUPID_ENDUSER);
                    if (!groupsForUser.isEmpty()) continue;
                }
                userManager.deleteUserAccount(userAccount.getID());
            }
        }
        catch (SQLException ex) {
            throw new ServerDataException(ex);
        }
    }

    @Override
    public synchronized MaintenanceConnector.EntriesToDelete<MaintenanceConnector.UnrelatedUser> findUnrelatedUsers(String impName) throws ServerDataException {
        return this.findUnrelatedUsers(false, Optional.of(impName));
    }

    @Override
    public synchronized void deleteUnrelatedUsers(String impName) throws ServerDataException {
        this.findUnrelatedUsers(true, Optional.of(impName));
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    private MaintenanceConnector.EntriesToDelete<MaintenanceConnector.UnrelatedUser> findUnrelatedUsers(boolean shouldDeleteFoundUsers, Optional<String> impName) throws ServerDataException {
        Object findUnrelatedUsersSql = "SELECT UsrID, geloescht FROM tblUser Where tblUser.UsrID > 1 AND Not tblUser.UsrID IN(Select tblAuftraege.UsrID AS UsrID1 FROM tblAuftraege WHERE tblAuftraege.UsrID IS NOT NULL group by tblAuftraege.UsrID) AND Not tblUser.UsrID IN(Select tblRessourcenUser.UsrID AS UsrID2 FROM tblRessourcenUser group by tblRessourcenUser.UsrID) AND Not tblUser.UsrID IN(Select tblBGSuperUser.UsrID AS UsrID3 FROM tblBGSuperUser group by tblBGSuperUser.UsrID) ";
        if (this.tblGeraeteBestandExists()) {
            findUnrelatedUsersSql = (String)findUnrelatedUsersSql + "AND Not tblUser.UsrID IN(Select tblGeraeteBestand.UserID AS UsrID5 FROM tblGeraeteBestand WHERE tblGeraeteBestand.UserID IS NOT NULL group by tblGeraeteBestand.UserID)";
        }
        if (impName.isPresent()) {
            findUnrelatedUsersSql = (String)findUnrelatedUsersSql + " AND tblUser.ImpName = '" + impName.get() + "'";
        }
        findUnrelatedUsersSql = (String)findUnrelatedUsersSql + " ORDER BY tblUser.UsrID DESC";
        int processedUserCount = 0;
        ArrayList<MaintenanceConnector.UnrelatedUser> exemplaryUsers = new ArrayList<MaintenanceConnector.UnrelatedUser>();
        boolean foundMore = false;
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        UserGroupManager groupManager = UserGroupManager.getRecoveryEnabledInstance();
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstmFindUnrelatedUsers = con.prepareStatement((String)findUnrelatedUsersSql);
             ResultSet rs = pstmFindUnrelatedUsers.executeQuery();){
            while (rs.next()) {
                boolean isActiveUser;
                if (!shouldDeleteFoundUsers && processedUserCount == 1000) {
                    foundMore = true;
                    break;
                }
                int userID = rs.getInt(1);
                int geloescht = rs.getInt(2);
                UserAccount userAccount = HDUsersAndGroups.getUserAccount(userID, userManager);
                if (userAccount == null) {
                    HDLogger.warn("Could not obtain account for user with ID " + userID);
                    continue;
                }
                if (userAccount.getValue((UserField)UsersAndGroups.FIELD_USER_LOCKED) != null || userAccount.getAccountType() == UserAccountType.Temp) continue;
                boolean bl = isActiveUser = geloescht == 0;
                if (isActiveUser) {
                    boolean isDispatcher = SystemPermissionChecker.hasAnyPermission((PermissionCheckScope)new PermissionCheckScope(userAccount, groupManager), (Permission[])new Permission[]{HdPermissions.DISPATCHER});
                    if (isDispatcher) continue;
                    Set groupsForUser = groupManager.getGroupsForUser(userAccount.getID()).stream().map(UserGroupInfo::getID).collect(Collectors.toSet());
                    groupsForUser.remove(UsersAndGroups.GROUPID_ALLUSERS);
                    groupsForUser.remove(HDUsersAndGroups.GROUPID_ENDUSER);
                    if (!groupsForUser.isEmpty()) continue;
                }
                if (shouldDeleteFoundUsers) {
                    userManager.deleteUserAccount(userAccount.getID());
                } else if (exemplaryUsers.size() < 6) {
                    MaintenanceConnector.UnrelatedUser user = new MaintenanceConnector.UnrelatedUser(userAccount.getID());
                    UserModelConverter.convertUserAccount(userAccount, user);
                    exemplaryUsers.add(user);
                }
                ++processedUserCount;
            }
        }
        catch (SQLException ex) {
            throw new ServerDataException(ex);
        }
        return new MaintenanceConnector.EntriesToDelete<MaintenanceConnector.UnrelatedUser>(processedUserCount, foundMore, exemplaryUsers);
    }

    /*
     * Exception decompiling
     */
    private boolean tblGeraeteBestandExists() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL Statement is fixed")
    public synchronized List<Integer> findUnrelatedLocations() throws ServerDataException {
        String query = "SELECT GebID FROM tblGebaeude " + this.createWherePartOfSqlStatementThatFindsUnrelatedLocations() + " ORDER BY tblGebaeude.GebID DESC";
        ArrayList<Integer> locations = new ArrayList<Integer>();
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(query);
             ResultSet rs = pstm.executeQuery();){
            while (rs.next()) {
                locations.add(rs.getInt("GebID"));
            }
        }
        catch (SQLException ex) {
            throw new ServerDataException(ex);
        }
        return locations;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    public synchronized void deleteUnrelatedLocations(ArrayList<String> additionalSQL) throws ServerDataException {
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("DELETE FROM tblGebaeude ");
        sqlQuery.append(this.createWherePartOfSqlStatementThatFindsUnrelatedLocations());
        for (String querySnipped : additionalSQL) {
            sqlQuery.append(querySnipped);
        }
        try (Connection con = this.connectionFactory.getConnection();
             PreparedStatement pstm = con.prepareStatement(sqlQuery.toString().trim());){
            pstm.executeUpdate();
        }
        catch (SQLException ex) {
            throw new ServerDataException(ex);
        }
    }

    private String createWherePartOfSqlStatementThatFindsUnrelatedLocations() {
        Object sql = "Where Not tblGebaeude.GebID IN(Select tblUser.GebID AS GebID1 FROM tblUser WHERE tblUser.GebID IS NOT NULL group by tblUser.GebID) AND Not tblGebaeude.GebID IN(Select tblOptionen.GebID AS GebID3 FROM tblOptionen WHERE tblOptionen.GebID IS NOT NULL) ";
        if (this.tblGeraeteBestandExists()) {
            sql = (String)sql + "AND Not tblGebaeude.GebID IN(Select tblGeraeteBestand.GebID AS GebID2 FROM tblGeraeteBestand WHERE tblGeraeteBestand.GebID IS NOT NULL group by tblGeraeteBestand.GebID) ";
        }
        sql = (String)sql + " AND tblGebaeude.GebID <> " + (Integer)HDUsersAndGroups.FIELD_LOCATION_ID.getDefaultValue() + " ";
        return sql;
    }

    private Ticket getTicketForResultSet(ResultSet rs, Connection con, boolean requestText, int ticketVersion) throws ServerDataException {
        try {
            Timestamp termin;
            Timestamp timestamp;
            Object dueTime;
            int ticketId = rs.getInt("AufID");
            String subject = rs.getString("DerBetreff");
            boolean htmlContent = rs.getInt("ishtml") != 0;
            String aufText = "";
            if (requestText) {
                aufText = rs.getString("Auftrag");
                aufText = aufText != null && aufText.length() > 0 ? (htmlContent ? HtmlConverter.getCompactHtmlText((String)aufText, null) : aufText.trim()) : "";
            }
            if ((subject == null || subject.trim().length() == 0) && aufText.length() > 0) {
                if (htmlContent) {
                    subject = HtmlConverter.html2text((String)aufText);
                    subject = subject.substring(0, Math.min(50, subject.length()));
                } else {
                    subject = aufText.substring(0, Math.min(50, aufText.length()));
                }
            }
            if (subject == null) {
                subject = "";
            } else {
                subject = subject.replace("\r", "").replace("\n", " ").replace("\t", " ").replaceAll("\\s+", " ");
                subject = subject.trim();
            }
            Date lastModifiedDate = new Date(rs.getTimestamp("BearbeitungsDatum").getTime());
            if (ticketVersion < 0) {
                ticketVersion = (int)(lastModifiedDate.getTime() / 1000L);
            }
            int resID = rs.getInt("ResID");
            Ticket ticket = new Ticket(ticketVersion, ticketId, resID, subject, lastModifiedDate, rs.getInt("Status"), rs.getInt("PriID"));
            Integer categoryId = rs.getInt("BetID");
            if (categoryId == 0) {
                categoryId = null;
            }
            ticket.addData(Field.TICKETDATA_CATEGORYID, categoryId);
            ticket.addData(Field.TICKETDATA_INQUIRYDATE, new Date(rs.getTimestamp("AnfrageDatum").getTime()));
            ticket.setHtmlContent(htmlContent);
            ticket.addData(Field.TICKETDATA_PREVIEW, aufText);
            UserAccount userAccount = this.getUserAccountFromResultSetViaId(rs);
            User ticketOwner = UserModelConverter.convertUserAccount(userAccount);
            ticket.addData(Field.TICKETDATA_OWNER, ticketOwner);
            String lastEditor = rs.getString("Bearbeiter");
            if (lastEditor == null && ticketOwner != null) {
                lastEditor = ticketOwner.getDisplayName();
            }
            ticket.addData(Field.TICKETDATA_LASTTEXTEDITOR, lastEditor);
            ticket.addData(Field.TICKETDATA_REQUESTMAILACCOUNT, rs.getString("EmailEingang"));
            int sumTimes = rs.getInt("SummeZeit");
            if (sumTimes > 0) {
                ticket.addData(Field.TICKETDATA_SUMTIMES, sumTimes);
            }
            ticket.addData(Field.TICKETDATA_TICKETFIELD1, rs.getString("BunFeld1"));
            ticket.addData(Field.TICKETDATA_TICKETFIELD2, rs.getString("BunFeld2"));
            ticket.addData(Field.TICKETDATA_TICKETFIELD3, rs.getString("BunFeld3"));
            ticket.addData(Field.TICKETDATA_TICKETFIELD4, rs.getString("BunFeld4"));
            ticket.addData(Field.TICKETDATA_SPECIALFIELD, rs.getString("spezFeld"));
            ticket.addData(Field.TICKETDATA_CLASSIFICATIONID, rs.getInt("KlaID"));
            ticket.addData(Field.TICKETDATA_ITILID, rs.getInt("ItiID"));
            UserGroupInfo resource = this.getResource(resID);
            if (resource != null) {
                ticket.addData(Field.TICKETDATA_RESOURCEID_DISPLAYNAME, resource.getDisplayName());
            }
            if ((dueTime = rs.getObject("SollZeit")) instanceof Integer && (Integer)dueTime > 0) {
                ticket.addData(Field.TICKETDATA_DUETIME, dueTime);
            }
            if ((timestamp = rs.getTimestamp("DeadlineZeit")) != null) {
                ticket.addData(Field.TICKETDATA_DEADLINE, new Date(timestamp.getTime()));
            }
            if ((termin = rs.getTimestamp("TerminVereinbarung")) != null) {
                ticket.addData(Field.TICKETDATA_TERMINVEREINBARUNG, new Date(termin.getTime()));
            }
            ticket.addData(Field.TICKETDATA_HASATTACHMENTS, rs.getInt("Anlagen") != 0);
            ticket.addData(Field.TICKETDATA_MASTERTICKET, rs.getInt("Master") != 0);
            ticket.addData(Field.TICKETDATA_HASSUBTICKETS, rs.getInt("subAuftraege") != 0);
            return ticket;
        }
        catch (SQLException ex) {
            throw new ServerDataException(ex);
        }
    }

    protected UserGroupInfo getResource(int resID) {
        return HDUsersAndGroups.getResourceFromRecoveryEnabledManager(resID);
    }

    @Nullable
    protected UserAccount getUserAccountFromResultSetViaId(ResultSet rs) throws SQLException {
        UserManager manager = HelpDeskUserManager.getRecoveryEnabledInstance();
        return HDUsersAndGroups.getUserAccount(rs.getInt("UsrID"), manager);
    }
}

