/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigurationManager;
import com.inet.config.RecoveryConfigValue;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import srv.ServerUtilities;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    private static final RecoveryConfigValue<DatabaseConfigInfoList> DATABASE_CONNECTION_INFOS = new RecoveryConfigValue(HDConfigKeys.DB_CONFIGS);
    private static final int DEFAULT_QUERY_TIMEOUT = 30;
    private Boolean hdsValid;

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection("HDS");
    }

    @Override
    public boolean isHelpDeskDatabaseConnectionValid() {
        if (this.hdsValid == null) {
            try {
                Connection con = this.getConnection();
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                return false;
            }
        }
        return this.hdsValid;
    }

    @Override
    public Connection getConnection(String database) throws SQLException {
        if (ConfigurationManager.isHelpCenterMode()) {
            throw new SQLException("No connection in help center mode");
        }
        Connection alreadyExistingConnection = ConnectionFactory.getCurrentConnectionWithTransaction();
        if (alreadyExistingConnection != null && !alreadyExistingConnection.isClosed()) {
            Connection nonCloseableConnection = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (proxy, method, methodArgs) -> {
                if (method.getName().equals("close")) {
                    return null;
                }
                return method.invoke((Object)alreadyExistingConnection, methodArgs);
            });
            return nonCloseableConnection;
        }
        if (database == null) {
            database = "HDS";
        }
        if (database.equals("HDS")) {
            try {
                Connection connection = this.wrappedConnectionWithDefaultQueryTimeout(this.getConnectionFromConfiguration("HDS"));
                this.hdsValid = true;
                return connection;
            }
            catch (SQLException e) {
                this.hdsValid = false;
                throw e;
            }
        }
        Connection connection = this.wrappedConnectionWithDefaultQueryTimeout(this.getConnectionFromConfiguration(database));
        return connection;
    }

    protected Connection wrappedConnectionWithDefaultQueryTimeout(Connection connection) {
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (proxy, method, methodArgs) -> {
            try {
                String methodName = method.getName();
                if (methodName.equals("createStatement") || methodName.equals("prepareStatement") || methodName.equals("prepareCall")) {
                    Statement st = (Statement)method.invoke((Object)connection, methodArgs);
                    try {
                        st.setQueryTimeout(30);
                    }
                    catch (SQLException exc) {
                        HDLogger.debug(exc);
                    }
                    return st;
                }
                return method.invoke((Object)connection, methodArgs);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        });
    }

    private Connection getConnectionFromConfiguration(String connName) throws SQLException {
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)DATABASE_CONNECTION_INFOS.get();
        if (list == null || list.isEmpty()) {
            throw new SQLException("No connection in DB Configuration.");
        }
        DatabaseConfigInfo dbInfo = list.get(connName);
        if (dbInfo == null) {
            throw new SQLException("No HDS connection in Configuration.");
        }
        try {
            LoaderUtils.classForName((String)dbInfo.getDriverClassName(), (Object)this);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e);
        }
        Object url = dbInfo.getUrl();
        if (((String)url).startsWith("jdbc:inetdae7:") && !((String)url).contains("lastUpdateCount")) {
            url = (String)url + "&lastUpdateCount=true";
        }
        if (((String)url).startsWith("jdbc:") && !((String)url).startsWith("jdbc:inetpool:")) {
            url = "jdbc:inetpool:" + ((String)url).substring(5);
        }
        Properties props = ServerUtilities.generateConnectionProperties((String)url, dbInfo.getUser(), dbInfo.getDecodedPassword(), dbInfo.getDriverClassName());
        return DriverManager.getConnection((String)url, props);
    }

    @Override
    public String testDBConnection(String url, String pwd, String user, String driverClassName, String databaseName) {
        return ServerUtilities.testDB(url, pwd, user, driverClassName, databaseName, false);
    }

    @Override
    public Connection getConnection(String url, String pwd, String user, String driverClassName, String databaseName) throws SQLException {
        Properties props = ServerUtilities.generateConnectionProperties(url, user, pwd, driverClassName);
        return DriverManager.getConnection(url, props);
    }
}

