/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess;

import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.additionalaccess.TicketAdditionalAccessValue;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.Hash;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashSet;

public class TicketFieldAdditionalAccess
extends TicketField<TicketAdditionalAccessValue> {
    public static final String KEY = "additionalticketaccess";

    public TicketFieldAdditionalAccess() {
        super(KEY, new TicketAdditionalAccessValue());
    }

    @Override
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(TicketVOSingle master, TicketVOSingle slave) {
        return master;
    }

    public TicketAdditionalAccessValue copyValue(TicketAdditionalAccessValue value) {
        if (value == null) {
            return null;
        }
        return new TicketAdditionalAccessValue(value.getReadAccess(), value.getWriteAccess());
    }

    @Override
    public String valueToString(TicketAdditionalAccessValue fieldValue) {
        return "<Freigabe>";
    }

    @Override
    public int getFieldChangeReaStepActionId() {
        return -38;
    }

    @Override
    protected String constructReaStepDescriptionForFieldChange(TicketAdditionalAccessValue oldFieldValue, TicketAdditionalAccessValue newFieldValue) {
        HashSet<Hash> readAdded = new HashSet<Hash>();
        HashSet<Hash> readRemoved = new HashSet<Hash>();
        HashSet<Hash> writeAdded = new HashSet<Hash>();
        HashSet<Hash> writeRemoved = new HashSet<Hash>();
        HashSet<Hash> writeToRead = new HashSet<Hash>();
        HashSet<Hash> readToWrite = new HashSet<Hash>();
        if (oldFieldValue == null) {
            oldFieldValue = new TicketAdditionalAccessValue();
        }
        if (newFieldValue == null) {
            newFieldValue = new TicketAdditionalAccessValue();
        }
        for (Hash hash2 : oldFieldValue.getReadAccess()) {
            if (newFieldValue.getWriteAccess().contains(hash2)) {
                readToWrite.add(hash2);
                continue;
            }
            if (newFieldValue.getReadAccess().contains(hash2)) continue;
            readRemoved.add(hash2);
        }
        for (Hash hash2 : oldFieldValue.getWriteAccess()) {
            if (newFieldValue.getReadAccess().contains(hash2)) {
                writeToRead.add(hash2);
                continue;
            }
            if (newFieldValue.getWriteAccess().contains(hash2)) continue;
            writeRemoved.add(hash2);
        }
        for (Hash hash2 : newFieldValue.getReadAccess()) {
            if (oldFieldValue.getReadAccess().contains(hash2) || oldFieldValue.getWriteAccess().contains(hash2)) continue;
            readAdded.add(hash2);
        }
        for (Hash hash2 : newFieldValue.getWriteAccess()) {
            if (oldFieldValue.getReadAccess().contains(hash2) || oldFieldValue.getWriteAccess().contains(hash2)) continue;
            writeAdded.add(hash2);
        }
        HashSet allChanges = new HashSet();
        readAdded.forEach(hash -> allChanges.add(Tickets.MSG.getMsg("additionalAccess.fieldchange.addRead", new Object[]{this.name((Hash)hash)})));
        writeAdded.forEach(hash -> allChanges.add(Tickets.MSG.getMsg("additionalAccess.fieldchange.addWrite", new Object[]{this.name((Hash)hash)})));
        readRemoved.forEach(hash -> allChanges.add(Tickets.MSG.getMsg("additionalAccess.fieldchange.removeRead", new Object[]{this.name((Hash)hash)})));
        writeRemoved.forEach(hash -> allChanges.add(Tickets.MSG.getMsg("additionalAccess.fieldchange.removeWrite", new Object[]{this.name((Hash)hash)})));
        readToWrite.forEach(hash -> allChanges.add(Tickets.MSG.getMsg("additionalAccess.fieldchange.readToWrite", new Object[]{this.name((Hash)hash)})));
        writeToRead.forEach(hash -> allChanges.add(Tickets.MSG.getMsg("additionalAccess.fieldchange.writeToRead", new Object[]{this.name((Hash)hash)})));
        int numOfChanges = allChanges.size();
        int alreadyAdded = 0;
        int lengthOfSuffix = Tickets.MSG.getMsg("additionalAccess.fieldchange.many", new Object[]{numOfChanges}).length() + 1;
        StringBuilder sb = new StringBuilder();
        for (String s : allChanges) {
            if (alreadyAdded + 1 == numOfChanges) {
                if (sb.length() + s.length() + 2 <= 255) {
                    if (sb.length() != 0) {
                        sb.append(", ");
                    }
                    sb.append(s);
                    continue;
                }
                sb.append(" " + Tickets.MSG.getMsg("additionalAccess.fieldchange.many", new Object[]{numOfChanges - alreadyAdded}));
                continue;
            }
            if (sb.length() + s.length() + lengthOfSuffix + 2 <= 255) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(s);
                ++alreadyAdded;
                continue;
            }
            sb.append(" " + Tickets.MSG.getMsg("additionalAccess.fieldchange.many", new Object[]{numOfChanges - alreadyAdded}));
            break;
        }
        return sb.toString();
    }

    private String name(Hash hash) {
        if (hash.getType() == Type.user) {
            UserAccount userAccount = UserManager.getInstance().getUserAccount(hash.getId());
            if (userAccount == null) {
                return Tickets.MSG.getMsg("deletedUser", new Object[0]);
            }
            return userAccount.getDisplayName();
        }
        UserGroupInfo group = UserGroupManager.getInstance().getGroup(hash.getId());
        if (group == null) {
            return Tickets.MSG.getMsg("deletedGroup", new Object[0]);
        }
        return UsersAndGroups.getFullGroupDisplayName((UserGroupInfo)group);
    }

    public void validate(TicketAdditionalAccessValue value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
    }
}

