/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model.tickets;

import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketAttributeUnread
extends TicketAttribute<Set<Integer>> {
    public static final String SEARCH_VALUE_READ = "0";
    public static final String SEARCH_VALUE_UNREAD = "1";
    public static final String KEY_SUPPORTER = "TicketUnreadForSupporter";
    public static final String KEY_ENDUSER = "TicketUnreadForEnduser";

    public TicketAttributeUnread(String key) {
        super(key, Set.of(), FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldType<Set<Integer>> createFieldType() {
        return new FieldType<Set<Integer>>(this.getKey(), () -> this.getLabel()){

            @Nullable
            public String getDisplayValue(@Nullable Set<Integer> value) {
                if (value == null) {
                    return "";
                }
                return value.toString();
            }

            @Nullable
            public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
                return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(TicketAttributeUnread.this.getKey(), SearchDataType.ID, false, new SearchTokenizer(){

                    @Nonnull
                    public Set<String> tokens(@Nullable Object value, int type) {
                        switch (type) {
                            case 1: {
                                return value == null ? Set.of() : Set.of(value.toString());
                            }
                            case 3: {
                                return Collections.singleton(value == null ? TicketAttributeUnread.SEARCH_VALUE_READ : (((Set)value).isEmpty() ? TicketAttributeUnread.SEARCH_VALUE_READ : TicketAttributeUnread.SEARCH_VALUE_UNREAD));
                            }
                        }
                        return Collections.emptySet();
                    }
                }, 100, labelProvider, false));
            }
        };
    }

    @Override
    @Nonnull
    public TicketVOSingle getValueSourceForSlaveTicketForEnduser(@Nonnull TicketVOSingle master, @Nonnull TicketVOSingle slave) {
        return this.getKey().equals(KEY_ENDUSER) ? slave : master;
    }

    public Set<Integer> copyValue(Set<Integer> value) {
        return value == null ? null : new HashSet<Integer>(value);
    }

    @Override
    public String getLabel() {
        return this.getKey();
    }
}

