/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketfieldsettings;

import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator2;
import com.inet.field.SelectOption;
import com.inet.fieldsettings.api.FieldSettingsSelectValueProvider;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettingsManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.SuppressFBWarnings;

public class SqlQuerySelectValueProvider
implements FieldSettingsSelectValueProvider {
    public static final String PROP_USE_SQL_CONNECTION = "usesqlconnection";
    public static final String PROP_SQL_CONNECTION_NAME = "sqlconnectionname";
    public static final String PROP_SQL_QUERY = "sqlquery";
    public static final String PROP_TICKET_CUSTOM3 = "ticketCustom3";

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="constat string with parameter method is used")
    public List<SelectOption> loadSelectValues(String fieldKey, Map<String, String> specificProperties) {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        if ("true".equalsIgnoreCase(specificProperties.get(PROP_USE_SQL_CONNECTION))) {
            String db = specificProperties.get(PROP_SQL_CONNECTION_NAME);
            String command = specificProperties.get(PROP_SQL_QUERY);
            ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
            try (Connection c2 = factory.getConnection(db);
                 PreparedStatement pstQuery = c2.prepareStatement(command);
                 ResultSet rsQuery = pstQuery.executeQuery();){
                while (rsQuery.next()) {
                    String key = rsQuery.getString(1);
                    if (StringFunctions.isEmpty((String)key)) continue;
                    options.add(new SelectOption(key, key));
                }
            }
            catch (SQLException e) {
                HDLogger.warn("Exception in query for field " + fieldKey + ": " + e.getMessage());
                HDLogger.debug(e);
            }
        }
        if ("true".equalsIgnoreCase(specificProperties.get(PROP_TICKET_CUSTOM3)) && UserManager.getInstance().getCurrentUserAccountID() != null) {
            UserAccount account = UserManager.getInstance().getCurrentUserAccount();
            final boolean isSupporter = HDUsersAndGroups.isSupporter();
            Predicate<String> predicate = new Predicate<String>(){

                @Override
                public boolean test(String line) {
                    return isSupporter && line.startsWith("*") || line.startsWith("#");
                }
            };
            ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
            try (Connection con = connectionFactory.getConnection();
                 PreparedStatement stm = con.prepareStatement("SELECT Werte FROM tblGebaeude WHERE GebID=?");){
                stm.setInt(1, (Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID));
                try (ResultSet rs = stm.executeQuery();){
                    String gebTxt;
                    if (rs.next() && (gebTxt = rs.getString(1)) != null) {
                        List labels = Arrays.stream(gebTxt.split("\\n")).filter(predicate).collect(Collectors.toList());
                        for (String string : labels) {
                            string = string.substring(1).trim();
                            options.add(new SelectOption(string, string));
                        }
                    }
                }
            }
            catch (SQLException e) {
                HDLogger.error(e);
            }
        }
        return options;
    }

    public static void setDefaultValuesForSqlProperties(Map<String, String> properties) {
        properties.putIfAbsent(PROP_USE_SQL_CONNECTION, "false");
        properties.putIfAbsent(PROP_SQL_CONNECTION_NAME, "");
        properties.putIfAbsent(PROP_SQL_QUERY, "");
    }

    public static List<LocalizedKey> getAllDatabases() {
        DatabaseConfigInfoList dbConfigs = (DatabaseConfigInfoList)HDConfigKeys.DB_CONFIGS.getCurrent();
        return dbConfigs.stream().map(c -> new LocalizedKey(c.getDbName(), c.getDbName())).collect(Collectors.toList());
    }

    public static void structure_addPropertiesAndConditionsInRowAction(List<ConfigConditionAction> conditions, List<ConfigProperty> propertyList) {
        ConfigCondition isSelectType = ConditionGenerator2.prop((String)"type").equalTo((Object)FieldSettingsType.TYPE_SELECT.toString());
        conditions.add(ConditionGenerator2.prop((String)PROP_USE_SQL_CONNECTION).visibleIf(isSelectType));
        conditions.add(ConditionGenerator2.prop((String)PROP_SQL_CONNECTION_NAME).visibleIf(isSelectType.and(ConditionGenerator2.prop((String)PROP_USE_SQL_CONNECTION).equalTo((Object)"true"))));
        conditions.add(ConditionGenerator2.prop((String)PROP_SQL_QUERY).visibleIf(isSelectType.and(ConditionGenerator2.prop((String)PROP_USE_SQL_CONNECTION).equalTo((Object)"true"))));
        Optional<ConfigProperty> selectModeProp = propertyList.stream().filter(p -> p.getKey().equals("selectstaticoptions")).findFirst();
        int index = selectModeProp.isPresent() ? propertyList.indexOf(selectModeProp.get()) : -1;
        propertyList.add(++index, (ConfigProperty)new BooleanConfigProperty(0, PROP_USE_SQL_CONNECTION, "BooleanReloadSelectInputs", TicketFieldSettingsManager.MSG.getMsg("fields.usesqlquery", new Object[0]), null, null, (Object)"false"));
        List<LocalizedKey> connections = SqlQuerySelectValueProvider.getAllDatabases();
        propertyList.add(++index, (ConfigProperty)new SelectConfigProperty(0, PROP_SQL_CONNECTION_NAME, "SimpleTextReloadSelectInputs", TicketFieldSettingsManager.MSG.getMsg("fields.sqlconnectionname", new Object[0]), (Object)"", "", connections));
        propertyList.add(++index, new ConfigProperty(0, PROP_SQL_QUERY, "MultiLineTextReloadSelectInputs", TicketFieldSettingsManager.MSG.getMsg("fields.sqlquery", new Object[0]), (Object)"", "", "SELECT <column> FROM <table> WHERE <condition> ORDER BY <column>"));
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Is intended to execute user's query")
    public static void validateSQLQuery(Map<String, String> properties, List<ConfigValidationMsg> result) {
        FieldSettingsType type;
        String typeString = properties.get("type");
        if (typeString != null && (type = FieldSettingsType.valueOf((String)typeString)) == FieldSettingsType.TYPE_SELECT && "true".equalsIgnoreCase(properties.get(PROP_USE_SQL_CONNECTION))) {
            if (StringFunctions.isEmpty((String)properties.get(PROP_SQL_CONNECTION_NAME)) || StringFunctions.isEmpty((String)properties.get(PROP_SQL_QUERY))) {
                result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, TicketFieldSettingsManager.MSG.getMsg("fields.validation.mustsetValidSQLConnectionAndQuery", new Object[0]), PROP_USE_SQL_CONNECTION));
            } else {
                ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
                try (Connection c2 = factory.getConnection(properties.get(PROP_SQL_CONNECTION_NAME));
                     PreparedStatement pstQuery = c2.prepareStatement(properties.get(PROP_SQL_QUERY));
                     ResultSet rsQuery = pstQuery.executeQuery();){
                    if (rsQuery.next()) {
                        String key = rsQuery.getString(1);
                        try {
                            rsQuery.getObject(2);
                            result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, TicketFieldSettingsManager.MSG.getMsg("fields.validation.sqlquery.canonlyhaveonecolumn", new Object[0]), PROP_SQL_QUERY));
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                catch (SQLException e) {
                    result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, TicketFieldSettingsManager.MSG.getMsg("fields.validation.sqlqueryerror", new Object[]{e.getMessage()}), PROP_SQL_QUERY));
                }
            }
        }
    }
}

