/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.model.dataimport.DataImportSchedule;
import java.util.HashMap;
import java.util.Map;

@JsonData
public class DeviceImportConfigInfo {
    private boolean indirekt;
    private boolean ignoreuser;
    private int gertyp;
    private String selektionusermain = "";
    private String selektionuserref1 = "";
    private String selektionuserref2 = "";
    private String selektionuserref3 = "";
    @Deprecated
    private String selektionlist = "";
    private Map<String, String> selectionMap = new HashMap<String, String>();
    private boolean loeschen;
    private DataImportSchedule schedule;
    private String selektion1 = "";
    private String uniqueident = "";
    private String uid;
    private boolean ldap;
    private String connectionName = "";

    public int getGerTyp() {
        return this.gertyp;
    }

    public void setGerTyp(int gertyp) {
        this.gertyp = gertyp;
    }

    public boolean isIndirekt() {
        return this.indirekt && !this.ignoreuser;
    }

    public void setIndirekt(boolean indirect) {
        this.indirekt = indirect;
    }

    public String getSelektionUserMain() {
        return this.selektionusermain;
    }

    public void setSelektionUserMain(String selektionusermain) {
        this.selektionusermain = selektionusermain;
    }

    public String getIndirectUserReferenceObject() {
        return this.selektionuserref1;
    }

    public void setIndirectUserReferenceObject(String selectionuserref1) {
        this.selektionuserref1 = selectionuserref1;
    }

    public String getIndirectUserKeyReference() {
        return this.selektionuserref2;
    }

    public void setIndirectUserKeyReference(String indirectUserKeyReference) {
        this.selektionuserref2 = indirectUserKeyReference;
    }

    public String getIndirectUsernameReference() {
        return this.selektionuserref3;
    }

    public void setIndirectUsernameReference(String selektionUserRef3) {
        this.selektionuserref3 = selektionUserRef3;
    }

    public boolean isDelete() {
        return this.loeschen;
    }

    public void setDelete(boolean delete) {
        this.loeschen = delete;
    }

    public DataImportSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(DataImportSchedule schedule) {
        this.schedule = schedule;
    }

    public String getImportSource() {
        return this.selektion1;
    }

    public void setImportSource(String importSource) {
        this.selektion1 = importSource;
    }

    public String getUniqueIdent() {
        return this.uniqueident;
    }

    public void setUniqueIdent(String uniqueIdent) {
        this.uniqueident = uniqueIdent;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public void setUserSelectedMapping(Map<String, String> mapping) {
        if (mapping != null && !mapping.isEmpty()) {
            this.selectionMap = mapping;
        }
    }

    public Map<String, String> getUserSelectedMapping() {
        String[] MY_COLUMNS = new String[]{"name", "assetnumber", "costcenter", "custom1", "computername", "room", "serialnumber", "invoicenumber", "custom2", "custom3", "custom4", "custom5", "custom6", "custom7", "custom8", "custom9", "description"};
        if (!"".equals(this.selektionlist)) {
            String[] parts;
            String[] currentColumnMapping = new String[17];
            int writePos = 0;
            for (String attrName : parts = this.selektionlist.split("<>")) {
                currentColumnMapping[writePos] = attrName.trim().length() > 0 ? attrName : null;
                ++writePos;
            }
            if (this.selektionlist.length() - this.selektionlist.replace("<>", "").length() < 32) {
                currentColumnMapping[16] = currentColumnMapping[12];
                currentColumnMapping[12] = null;
            }
            this.selectionMap = new HashMap<String, String>();
            for (int i = 0; i < MY_COLUMNS.length; ++i) {
                this.selectionMap.put(MY_COLUMNS[i], currentColumnMapping[i]);
            }
            this.selektionlist = "";
        }
        return this.selectionMap;
    }

    public boolean isLdap() {
        return this.ldap;
    }

    public void setLdap(boolean ldap) {
        this.ldap = ldap;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }

    public boolean isIgnoreUser() {
        return this.ignoreuser;
    }

    public void setIgnoreUser(boolean ignoreuser) {
        this.ignoreuser = ignoreuser;
    }

    public static DataImportSchedule mapOldSchedule(int mainTimeOption, int subTimeOption, String specialTimeOption) {
        DataImportSchedule schedule = new DataImportSchedule();
        switch (mainTimeOption) {
            case 1: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.DAILY);
                schedule.setSubImportTimeOption(null);
                schedule.setHourOfDay(subTimeOption);
                break;
            }
            case 2: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.WEEKLY);
                switch (subTimeOption) {
                    case 1: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.TUESDAY);
                        break;
                    }
                    case 2: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.WEDNESDAY);
                        break;
                    }
                    case 3: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.THURSDAY);
                        break;
                    }
                    case 4: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.FRIDAY);
                        break;
                    }
                    case 5: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.SATURDAY);
                        break;
                    }
                    case 6: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.SUNDAY);
                        break;
                    }
                    default: {
                        schedule.setSubImportTimeOption(DataImportSchedule.SubTimeOption.MONDAY);
                    }
                }
                schedule.setHourOfDay(3);
                break;
            }
            default: {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.MANUAL);
                schedule.setSubImportTimeOption(null);
                schedule.setHourOfDay(3);
            }
        }
        if (specialTimeOption.length() > 0) {
            String[] split;
            int minTime = 24;
            int maxTime = 0;
            for (String string : split = specialTimeOption.split("<>")) {
                if ((string = string.replaceAll("[^\\d]", "")).length() <= 0) continue;
                int cTime = Integer.valueOf(string);
                cTime = Math.min(Math.max(0, cTime), 24);
                maxTime = Math.max(maxTime, cTime);
                minTime = Math.min(minTime, cTime);
            }
            if (minTime != 24 || maxTime != 0) {
                schedule.setMainImportTimeOption(DataImportSchedule.MainTimeOption.HOURLY);
                schedule.setSubImportTimeOption(null);
                schedule.setHourOfDay(3);
                schedule.setStartHour(minTime);
                schedule.setEndHour(maxTime);
            }
        }
        return schedule;
    }
}

