/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeColumn;
import com.inet.dbupdater.model.NodeCondition;
import com.inet.dbupdater.model.NodeCustomScripts;
import com.inet.dbupdater.model.NodeDBUpdater;
import com.inet.dbupdater.model.NodeData;
import com.inet.dbupdater.model.NodeDatabase;
import com.inet.dbupdater.model.NodeFunction;
import com.inet.dbupdater.model.NodeIndex;
import com.inet.dbupdater.model.NodeModules;
import com.inet.dbupdater.model.NodeProcedure;
import com.inet.dbupdater.model.NodeReference;
import com.inet.dbupdater.model.NodeSQL;
import com.inet.dbupdater.model.NodeScript;
import com.inet.dbupdater.model.NodeSequence;
import com.inet.dbupdater.model.NodeStartValue;
import com.inet.dbupdater.model.NodeTable;
import com.inet.dbupdater.model.NodeTrigger;
import com.inet.dbupdater.model.NodeVersion;
import com.inet.dbupdater.model.NodeView;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;

public class NodeFactory {
    private static final Logger logger = LogManager.getLogger((String)"DB Updater");

    public Node createNode(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Cannot create an model node without a tag-name");
        }
        try {
            TAG tagRef = TAG.valueOf(tag.toLowerCase());
            return tagRef.getInstance();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown tag '" + tag + "'");
        }
    }

    public static enum TAG {
        dbupdater(NodeDBUpdater.class),
        database(NodeDatabase.class),
        modules(NodeModules.class),
        table(NodeTable.class),
        column(NodeColumn.class),
        reference(NodeReference.class),
        index(NodeIndex.class),
        view(NodeView.class),
        trigger(NodeTrigger.class),
        sequence(NodeSequence.class),
        startvalue(NodeStartValue.class),
        function(NodeFunction.class),
        procedure(NodeProcedure.class),
        customscripts(NodeCustomScripts.class),
        version(NodeVersion.class),
        condition(NodeCondition.class),
        script(NodeScript.class),
        sql(NodeSQL.class),
        data(NodeData.class);

        private Class<? extends Node> implementation;

        private TAG(Class<? extends Node> implementation) {
            this.implementation = implementation;
        }

        public Node getInstance() {
            if (this.implementation != null) {
                try {
                    Node obj = this.implementation.newInstance();
                    obj.setName(this);
                    return obj;
                }
                catch (InstantiationException e) {
                    logger.error((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.error((Throwable)e);
                }
            }
            return null;
        }
    }
}

