/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.modelpatch;

import com.inet.dbupdater.databases.modelpatch.IModelPatcher;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.util.List;

public abstract class ModelPatcherBase
implements IModelPatcher {
    public Node replaceNode(Node toReplace) {
        return toReplace;
    }

    public String replaceParameter(String key, String value, NodeFactory.TAG node, NodeFactory.TAG parent) {
        return value;
    }

    @Override
    public Node patchModel(Node model) {
        return this.crawl(model);
    }

    private Node crawl(Node node) {
        if ((node = this.replaceNode(node)) == null) {
            return node;
        }
        for (String key : node.getParameterNames()) {
            String value = node.getParameter(key);
            String newValue = this.replaceParameter(key, value, node.getName(), node.getParent() != null ? node.getParent().getName() : null);
            if (newValue == value) continue;
            if (newValue == "#removed#") {
                node.dropParameter(key);
                continue;
            }
            node.readParameter(key, newValue);
        }
        List<? extends Node> children = node.getAllChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                Node child = children.get(i);
                Node child2 = this.crawl(child);
                if (child2 == child) continue;
                node.removeChild(child);
                if (child2 == null) continue;
                node.addChild(child2);
            }
        }
        return node;
    }
}

