/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager;

import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.field.Field;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.PluggableTicketSearchTag;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketActionChecker;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.core.ticketmanager.TicketLinking;
import com.inet.helpdesk.core.ticketmanager.TicketMaintenance;
import com.inet.helpdesk.core.ticketmanager.TicketManagerComponents;
import com.inet.helpdesk.core.ticketmanager.TicketManagerFactory;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.TicketPermissionChecker;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.TicketReaderForSystem;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ReaStepEmailUsersVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttribute;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.SearchTagTicketTags;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.generated.GeneratedAttributeChangeEventSender;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.ticketmanager.NewTicketDataConnectorImpl;
import com.inet.helpdesk.ticketmanager.TicketLinkingImpl;
import com.inet.helpdesk.ticketmanager.TicketManipulatorImpl;
import com.inet.helpdesk.ticketmanager.TicketManipulatorInternal;
import com.inet.helpdesk.ticketmanager.TicketManipulatorSync;
import com.inet.helpdesk.ticketmanager.TicketReaderImpl;
import com.inet.helpdesk.ticketmanager.access.TicketActionCheckerImpl;
import com.inet.helpdesk.ticketmanager.access.TicketPermissionCheckerImpl;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOImpl;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOWithCache;
import com.inet.helpdesk.ticketmanager.dao.TicketWriteDAO;
import com.inet.helpdesk.ticketmanager.internal.IDGenerator;
import com.inet.helpdesk.ticketmanager.internal.IndexUpdateAndEvents;
import com.inet.helpdesk.ticketmanager.internal.TicketChangeCollector;
import com.inet.helpdesk.ticketmanager.internal.TicketPreconditionChecks;
import com.inet.helpdesk.ticketmanager.internal.generated.GeneratedAttributeChangeEventSenderImpl;
import com.inet.helpdesk.ticketmanager.search.TicketSearchDataCache;
import com.inet.helpdesk.ticketmanager.search.TicketSearchEngine;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.i18n.DisplayableKey;
import com.inet.logging.LogManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.thread.ServerLock;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.ServerInitializer;

public class TicketManagerFactoryImpl
implements TicketManagerFactory {
    private static final List<String> RESERVED_TICKET_KEYS = Collections.unmodifiableList(Arrays.asList("bundleslave", "reasteptext", "tickettags"));

    @Override
    public TicketManagerComponents create() {
        if (!ServerInitializer.getInstance().isConnectionInitialized()) {
            throw new IllegalStateException("[TicketManager] Connection to database was not established yet!");
        }
        ServerPluginManager spm = ServerPluginManager.getInstance();
        DynamicExtensionManager dem = DynamicExtensionManager.getInstance();
        ConnectionFactory connectionFactory = (ConnectionFactory)spm.getSingleInstance(ConnectionFactory.class);
        TicketReadDAOImpl readDAO = new TicketReadDAOImpl(connectionFactory);
        TicketReadDAOWithCache readDAOWithCache = new TicketReadDAOWithCache(readDAO);
        TicketWriteDAO writeDAO = new TicketWriteDAO(connectionFactory, readDAOWithCache);
        IDGenerator idGenerator = new IDGenerator(connectionFactory);
        TicketSearchDataCache searchDataCache = new TicketSearchDataCache();
        TicketSearchEngine searchEngine = new TicketSearchEngine();
        IndexUpdateAndEvents indexUpdateAndEvents = new IndexUpdateAndEvents(searchDataCache);
        TicketPermissionCheckerImpl permissionChecker = new TicketPermissionCheckerImpl(readDAOWithCache);
        TicketReaderImpl reader = new TicketReaderImpl(readDAOWithCache, searchDataCache, searchEngine);
        TicketActionCheckerImpl actionChecker = new TicketActionCheckerImpl(reader, permissionChecker);
        TicketManipulatorInternal manipulator = new TicketManipulatorInternal(readDAOWithCache, writeDAO, reader, searchDataCache, actionChecker, permissionChecker);
        NewTicketDataConnectorImpl.setReaderImpl(reader);
        TicketManipulatorImpl manipulatorCtrl = new TicketManipulatorImpl(manipulator, permissionChecker, actionChecker, readDAOWithCache, writeDAO, indexUpdateAndEvents, idGenerator);
        TicketMaintenanceImpl maintenance = new TicketMaintenanceImpl(manipulatorCtrl, readDAO, writeDAO, indexUpdateAndEvents, searchDataCache);
        try {
            this.throwIfThereAreProblemsWithKeysOfRegisteredTicketFieldsAndAttributesAndPluggableSearchTags();
            this.throwIfThereAreProblemsWithKeysOfRegisteredReaStepFieldsAndAttributes();
            this.throwIfThereAreProblemsWithKeysOfRegisteredTicketTags();
            readDAO.init(spm.get(TicketAttribute.class), spm.get(ReaStepAttribute.class));
            writeDAO.init(dem.get(TicketField.class), spm.get(ReaStepField.class));
            spm.get(TicketEventListener.class).stream().forEach(listener -> indexUpdateAndEvents.registerListener((TicketEventListener)listener));
            reader.init();
        }
        catch (Exception ex) {
            LogManager.getConfigLogger().fatal((Object)ex);
            ErrorCode.throwAny((Throwable)ex);
        }
        TicketManagerVetoPower vetoPower = TicketManagerFactoryImpl.createVetoPower(searchEngine, searchDataCache);
        GeneratedAttributeChangeEventSenderImpl sender = new GeneratedAttributeChangeEventSenderImpl(indexUpdateAndEvents, readDAOWithCache, reader);
        return new TicketManagerComponentsImpl(reader, permissionChecker, actionChecker, vetoPower, writeDAO, manipulatorCtrl, maintenance, manipulator.getSubOperations(), sender);
    }

    private void throwIfThereAreProblemsWithKeysOfRegisteredTicketTags() {
        List ticketTags = ServerPluginManager.getInstance().get(SearchTagTicketTags.TicketTag.class);
        List allKeys = ticketTags.stream().map(DisplayableKey::getKey).collect(Collectors.toList());
        long distinctKeysCount = allKeys.stream().distinct().count();
        if ((long)allKeys.size() != distinctKeysCount) {
            throw new IllegalArgumentException("Keys among registered ticket tags must be unique. Keys of registered ticket tags: " + String.valueOf(allKeys));
        }
    }

    public static TicketManagerVetoPower createVetoPower(TicketSearchEngine searchEngine, TicketSearchDataCache searchDataCache) {
        return new TicketManagerVetoPower(reindex -> {
            try {
                searchEngine.init(searchDataCache);
                if (reindex.booleanValue()) {
                    searchEngine.getSearchEngine().reIndexAsync();
                    searchEngine.getSlaveInfoEngine().reIndexAsync();
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        });
    }

    private void throwIfThereAreProblemsWithKeysOfRegisteredTicketFieldsAndAttributesAndPluggableSearchTags() {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        DynamicExtensionManager dem = DynamicExtensionManager.getInstance();
        List ticketFields = Collections.unmodifiableList(dem.get(TicketField.class));
        List fieldKeys = ticketFields.stream().map(Field::getKey).collect(Collectors.toList());
        List ticketAttributes = Collections.unmodifiableList(spm.get(TicketAttribute.class));
        List attributeKeys = ticketAttributes.stream().map(Field::getKey).collect(Collectors.toList());
        List pluggableSearchTags = Collections.unmodifiableList(spm.get(PluggableTicketSearchTag.class));
        List pluggableSearchTagKeys = pluggableSearchTags.stream().map(pst -> pst.getSearchTag().getTag()).collect(Collectors.toList());
        ArrayList allRegisteredKeys = new ArrayList();
        allRegisteredKeys.addAll(fieldKeys);
        allRegisteredKeys.addAll(attributeKeys);
        allRegisteredKeys.addAll(pluggableSearchTagKeys);
        long distinctKeysCount = allRegisteredKeys.stream().distinct().count();
        if ((long)allRegisteredKeys.size() != distinctKeysCount) {
            String msgPartWithKeys = String.format("Keys of registered fields: %s. Keys of registered attributes: %s. Keys of registered pluggable search tags: %s.", fieldKeys, attributeKeys, pluggableSearchTagKeys);
            throw new IllegalArgumentException("Keys among registered ticket fields and attributes and pluggable search tags must be unique. " + msgPartWithKeys);
        }
        ArrayList<String> foundReservedKeys = new ArrayList<String>();
        for (String reservedKey : RESERVED_TICKET_KEYS) {
            if (!allRegisteredKeys.contains(reservedKey.toLowerCase())) continue;
            foundReservedKeys.add(reservedKey);
        }
        if (!foundReservedKeys.isEmpty()) {
            String msg = String.format("Registered ticket fields and attributes may not have keys that are reserved: %s", foundReservedKeys);
            throw new IllegalArgumentException(msg);
        }
    }

    private void throwIfThereAreProblemsWithKeysOfRegisteredReaStepFieldsAndAttributes() {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        List reaStepFields = Collections.unmodifiableList(spm.get(ReaStepField.class));
        List fieldKeys = reaStepFields.stream().map(Field::getKey).collect(Collectors.toList());
        List reaStepAttributes = Collections.unmodifiableList(spm.get(ReaStepAttribute.class));
        List attributeKeys = reaStepAttributes.stream().map(Field::getKey).collect(Collectors.toList());
        ArrayList fieldAndAttributeKeys = new ArrayList();
        fieldAndAttributeKeys.addAll(fieldKeys);
        fieldAndAttributeKeys.addAll(attributeKeys);
        long distinctFieldAndAttributeKeysCount = fieldAndAttributeKeys.stream().distinct().count();
        if ((long)fieldAndAttributeKeys.size() != distinctFieldAndAttributeKeysCount) {
            String msg = String.format("Keys among registered rea-step fields and attributes must be unique. Keys of registered fields: %s. Keys of registered attributes: %s.", fieldKeys, attributeKeys);
            throw new IllegalArgumentException(msg);
        }
    }

    private static class TicketMaintenanceImpl
    implements TicketMaintenance {
        private final TicketManipulatorImpl manipulatorImpl;
        private final TicketReadDAO readDAO;
        private final TicketWriteDAO writeDAO;
        private final IndexUpdateAndEvents indexUpdateAndEvents;
        private final TicketSearchDataCache searchDatacache;

        public TicketMaintenanceImpl(TicketManipulatorImpl manipulatorImpl, TicketReadDAO readDAO, TicketWriteDAO writeDAO, IndexUpdateAndEvents indexUpdateAndEvents, TicketSearchDataCache searchDatacache) {
            this.manipulatorImpl = manipulatorImpl;
            this.readDAO = readDAO;
            this.writeDAO = writeDAO;
            this.indexUpdateAndEvents = indexUpdateAndEvents;
            this.searchDatacache = searchDatacache;
        }

        @Override
        public void deleteTicket(int bundleID) {
            this.manipulatorImpl.deleteTicketForever(bundleID);
        }

        @Override
        public void deleteAllTicketsMarkedAsDeleted() {
            this.manipulatorImpl.deleteForeverAllTicketsMarkedAsDeleted();
        }

        @Override
        public void deleteTicketsByDate(long lastModified) {
            this.manipulatorImpl.deleteTicketsForeverByDate(lastModified);
        }

        @Override
        public void deleteTicketsByID(int fromID, int toID) {
            this.manipulatorImpl.deleteTicketsForeverByID(fromID, toID);
        }

        @Override
        public void moveAllTicketsFromDeletedResources(List<Integer> deletedResourceIDs, int targetResID) {
            this.manipulatorImpl.moveAllTicketsFromDeletedResources(deletedResourceIDs, targetResID);
        }

        @Override
        public void updateReaStepProcessingTime(int stepID, ProcessingTime processingTime, boolean updateLastChanged) {
            ReaStepVO reaStep = this.readDAO.getReaStep(stepID);
            TicketPreconditionChecks.throwIfReaStepDoesNotExists(reaStep, stepID);
            ReaStepVO.FIELD_PROCESSING_TIME.validate(processingTime);
            int ticketID = reaStep.getBunID();
            TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
            TicketPreconditionChecks.throwIfTicketDoesNotExists(ticket, ticketID);
            try (ServerLock lock = TicketManipulatorSync.getTicketLock(ticket);){
                TicketChangeCollector changeCollector = TicketChangeCollector.start(this.readDAO, ticket, false);
                this.writeDAO.updateReaStepProcessingTime(stepID, processingTime);
                this.writeDAO.updateTicketSumTime(ticketID);
                this.writeDAO.updateLastChanged(ticketID, updateLastChanged ? processingTime.getStart() : System.currentTimeMillis());
                this.writeDAO.getCacheCleaner().clearTicket(ticketID);
                this.writeDAO.getCacheCleaner().clearReaStep(stepID);
                this.indexUpdateAndEvents.handleTicketChangeCollectorResult(changeCollector.collectChanges(), true);
            }
        }

        @Override
        public void removeReferencesToUserAccountFromAllTicketsAndReaSteps(GUID accountID) {
            if (accountID == null) {
                throw new IllegalArgumentException("accountID must not be null");
            }
            UserAccount account = UserManager.getRecoveryEnabledInstance().getUserAccount(accountID);
            if (account == null) {
                return;
            }
            int userID = HDUsersAndGroups.getUserID(account);
            List<Integer> idsOfTicketsWithReferences = this.readDAO.listTicketsWithReferencesToUser(userID);
            this.writeDAO.removeReferencesToUserFromAllReaStepsAndClearCache(userID);
            for (int ticketID : idsOfTicketsWithReferences) {
                ServerLock lock = TicketManipulatorSync.getTicketLock(ticketID);
                try {
                    TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
                    if (ticket == null) {
                        this.writeDAO.removeReferencesToUserFromTicketAndClearCache(ticketID, userID);
                        continue;
                    }
                    TicketChangeCollector changeCollector = TicketChangeCollector.start(this.readDAO, ticket, false);
                    this.writeDAO.removeReferencesToUserFromTicketAndClearCache(ticketID, userID);
                    this.indexUpdateAndEvents.handleTicketChangeCollectorResult(changeCollector.collectChanges(), true);
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
        }

        @Override
        public void closeAutoFinishableTickets(long currentTimeMillis) {
            this.manipulatorImpl.closeAutoFinishableTickets(currentTimeMillis);
        }

        @Override
        public void applyActionAnlageLoeschen(int ticketID, ReaStepTextVO stepText, String stepDescription) {
            this.manipulatorImpl.applyActionAnlageLoeschen(ticketID, stepText, stepDescription);
        }

        @Override
        public void clearAllTicketsInCache() {
            this.writeDAO.getCacheCleaner().clearAllTicketsInCache();
        }

        @Override
        public void deleteDataOfDeletedField(List<TicketField<?>> list) {
            MutableTicketData data = new MutableTicketData();
            list.forEach(f -> data.put(f, null));
            Iterator<Integer> iterator = this.searchDatacache.iterator();
            while (iterator.hasNext()) {
                int ticketId = iterator.next();
                ServerLock ticketLock = TicketManipulatorSync.getTicketLock(ticketId);
                try {
                    this.writeDAO.updateTicketData(ticketId, new MutableTicketAttributes(), data);
                    this.writeDAO.getCacheCleaner().clearTicket(ticketId);
                }
                finally {
                    if (ticketLock == null) continue;
                    ticketLock.close();
                }
            }
        }

        @Override
        public void resetTicketIDGenerator() {
            this.manipulatorImpl.resetTicketIDGenerator();
        }
    }

    public static class TicketManagerComponentsImpl
    implements TicketManagerComponents {
        private final TicketManipulatorImpl manipulatorForSupporter;
        private final TicketMaintenance maintenance;
        private TicketReaderForSystem readerForSystem;
        private TicketReader reader;
        private TicketActionChecker actionChecker;
        private TicketPermissionChecker permissionChecker;
        private TicketManagerVetoPower vetoPower;
        private TicketSubOperations innerOperations;
        private GeneratedAttributeChangeEventSender generatedAttSender;
        private TicketLinkingImpl ticketLinking;

        public TicketManagerComponentsImpl(@Nonnull TicketReaderImpl reader, TicketPermissionChecker permissionChecker, TicketActionCheckerImpl actionChecker, TicketManagerVetoPower vetoPower, TicketWriteDAO writeDao, TicketManipulatorImpl manipulatorImpl, TicketMaintenance maintenance, TicketSubOperations innerOps, GeneratedAttributeChangeEventSender generatedAttSender) {
            this.generatedAttSender = generatedAttSender;
            TicketReaderWrapper ticketReaderWrapper = new TicketReaderWrapper(reader, permissionChecker);
            this.readerForSystem = new TicketReaderForSystemImpl(reader);
            this.manipulatorForSupporter = manipulatorImpl;
            this.maintenance = maintenance;
            this.actionChecker = actionChecker;
            this.reader = ticketReaderWrapper;
            this.permissionChecker = permissionChecker;
            this.vetoPower = vetoPower;
            this.innerOperations = innerOps;
            this.ticketLinking = new TicketLinkingImpl(ticketReaderWrapper, manipulatorImpl);
        }

        @Override
        public TicketReaderForSystem getReaderForSystem() {
            return this.readerForSystem;
        }

        @Override
        public TicketManipulator getManipulator() {
            return this.manipulatorForSupporter;
        }

        @Override
        public TicketMaintenance getMaintenance() {
            return this.maintenance;
        }

        @Override
        public TicketReader getReader() {
            return this.reader;
        }

        @Override
        public TicketActionChecker getActionChecker() {
            return this.actionChecker;
        }

        @Override
        public TicketPermissionChecker getTicketPermissionChecker() {
            return this.permissionChecker;
        }

        @Override
        public TicketManagerVetoPower getVetoPower() {
            return this.vetoPower;
        }

        @Override
        public TicketSubOperations getTicketInnerOperations() {
            return this.innerOperations;
        }

        @Override
        public GeneratedAttributeChangeEventSender getGeneratedAttributeEventSender() {
            return this.generatedAttSender;
        }

        @Override
        public TicketLinking getTicketLinking() {
            return this.ticketLinking;
        }
    }

    private static class TicketReaderWrapper
    implements TicketReader {
        private final TicketReaderImpl reader;
        private final TicketPermissionChecker permissionChecker;

        public TicketReaderWrapper(TicketReaderImpl reader, TicketPermissionChecker permissionChecker) {
            this.reader = reader;
            this.permissionChecker = permissionChecker;
        }

        @Override
        public List<ReaStepVO> getReaStepsForTicket(int ticketID, BundleStepsFilter stepsFilter) {
            TicketPermissionContext info = this.permissionChecker.getTicketPermissionInfo(ticketID);
            if (info != null && !info.hasAnyAccessToTicket()) {
                this.throwAccessForbidden(ticketID);
            }
            return this.reader.getReaStepsForTicket(ticketID, info, stepsFilter);
        }

        @Override
        public List<TicketEmailSenderInformation> getSenderInformationForTicket(int ticketID) throws ServerDataException {
            return this.reader.getSenderInformationForTicket(ticketID);
        }

        @Override
        @Nonnull
        public IndexSearchEngine<Integer> getSearchEngine() {
            return this.reader.getSearchEngine();
        }

        @Override
        @Nonnull
        public IndexSearchEngine<SlaveInfo> getSlaveInfoEngine() {
            return this.reader.getSlaveInfoEngine();
        }

        @Override
        @Nonnull
        public IndexSearchEngine<Integer> getReaStepSearchEngine() {
            return this.reader.getReaStepSearchEngine();
        }

        @Override
        public TicketVO getTicket(int ticketID) {
            TicketPermissionContext ticketPermissionInfo = this.permissionChecker.getTicketPermissionInfo(ticketID);
            if (ticketPermissionInfo != null && !ticketPermissionInfo.hasAnyAccessToTicket()) {
                this.throwAccessForbidden(ticketID);
            }
            return this.reader.getTicket(ticketID, ticketPermissionInfo);
        }

        @Override
        public ReaStepVO getReaStep(int reaStepID) {
            if (!this.permissionChecker.checkCurrentUserCanReadReaStep(reaStepID)) {
                int ticketID = this.reader.getReaStep(reaStepID).getOrgBunID();
                this.throwAccessForbidden(ticketID);
            }
            return this.reader.getReaStep(reaStepID);
        }

        @Override
        public ReaStepTextVO getReaStepText(int reaStepID) {
            if (!this.permissionChecker.checkCurrentUserCanReadReaStep(reaStepID)) {
                int ticketID = this.reader.getReaStep(reaStepID).getOrgBunID();
                this.throwAccessForbidden(ticketID);
            }
            return this.reader.getReaStepText(reaStepID);
        }

        @Override
        @Nonnull
        public List<TicketVO> getTickets(Collection<Integer> ticketIDs) {
            if (ticketIDs == null) {
                throw new IllegalArgumentException("ticketIDs must not be null");
            }
            ArrayList<TicketVO> result = new ArrayList<TicketVO>(ticketIDs.size());
            ticketIDs.forEach(ticketID -> {
                TicketPermissionContext ticketPermissionInfo = this.permissionChecker.getTicketPermissionInfo((int)ticketID);
                if (ticketPermissionInfo != null && ticketPermissionInfo.hasAnyAccessToTicket()) {
                    result.add(this.reader.getTicket((int)ticketID, ticketPermissionInfo));
                } else {
                    UserAccount account = UserManager.getInstance().getCurrentUserAccount();
                    HDLogger.warn(String.format("[PermissionCheck] No access to requested ticket: %d for user %s", ticketID, account == null ? "null" : account.getDisplayName()));
                }
            });
            return result;
        }

        private void throwAccessForbidden(int ticketID) {
            UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
            String name = currentUserAccount == null ? "NULL" : currentUserAccount.getDisplayName();
            throw new AccessDeniedException(Tickets.MSG.getMsg("error.noTicketAccess", new Object[]{name, ticketID}), (ErrorCode)BaseErrorCode.forbidden);
        }

        @Override
        public List<TicketVOSingle> getTicketsInBundle(int bundleID, boolean includeMasterTicket) {
            if (!this.permissionChecker.checkCurrentUserCanReadTicket(bundleID)) {
                this.throwAccessForbidden(bundleID);
            }
            return this.reader.getTicketsInBundle(bundleID, includeMasterTicket);
        }

        @Override
        public ReaStepEmailUsersVO getReaStepEmailUsers(int stepID) {
            return this.reader.getReaStepEmailUsers(stepID);
        }

        @Override
        @Nullable
        public SearchExpression getGlobalSearchExpressionForAllVisibleTickets(GUID accountID, Locale locale) {
            return GlobalSearchViewDefinition.getGlobalSearchExpressionForAllVisibleTickets(accountID, locale, false);
        }
    }

    private static class TicketReaderForSystemImpl
    implements TicketReaderForSystem {
        private TicketReaderImpl reader;

        public TicketReaderForSystemImpl(TicketReaderImpl reader) {
            this.reader = reader;
        }

        @Override
        @Nonnull
        public IndexSearchEngine<Integer> getSearchEngine() {
            return this.reader.getSearchEngine();
        }

        @Override
        @Nonnull
        public IndexSearchEngine<SlaveInfo> getSlaveInfoEngine() {
            return this.reader.getSlaveInfoEngine();
        }

        @Override
        @Nonnull
        public IndexSearchEngine<Integer> getReaStepSearchEngine() {
            return this.reader.getReaStepSearchEngine();
        }

        @Override
        public TicketVO getTicket(int ticketID) {
            return this.reader.getTicket(ticketID, TicketPermissionContext.artificialSupporterForDispatchedTicket());
        }

        @Override
        public ReaStepVO getReaStep(int reaStepID) {
            return this.reader.getReaStep(reaStepID);
        }

        @Override
        public ReaStepTextVO getReaStepText(int reaStepID) {
            return this.reader.getReaStepText(reaStepID);
        }

        @Override
        public List<ReaStepVO> getReaStepsForTicket(int ticketID) {
            return this.reader.getReaStepsForTicket(ticketID, TicketPermissionContext.artificialSupporterForDispatchedTicket(), BundleStepsFilter.WITHOUT_BUNDLE_STEPS);
        }

        @Override
        public List<TicketVO> getTickets(Collection<Integer> ticketIDs) {
            return this.reader.getTickets(ticketIDs, false);
        }

        @Override
        public List<TicketVOSingle> getTicketsInBundle(int bundleID, boolean includeMasterTicket) {
            return this.reader.getTicketsInBundle(bundleID, includeMasterTicket);
        }
    }
}

