/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext.data;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.config.autotext.data.AutoTextPlaceholderEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
public class AutoTextPlaceholder {
    private String value;
    private ArrayList<AutoTextPlaceholderEntry> entries = new ArrayList();

    private AutoTextPlaceholder() {
    }

    public AutoTextPlaceholder(String value) {
        this.value = value;
    }

    public void addEntry(String key, String displayName) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        this.entries.add(new AutoTextPlaceholderEntry(key, displayName));
    }

    public void sort() {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        this.entries.sort(new Comparator<AutoTextPlaceholderEntry>(){

            @Override
            public int compare(AutoTextPlaceholderEntry o1, AutoTextPlaceholderEntry o2) {
                return o1.getValue().compareToIgnoreCase(o2.getValue());
            }
        });
    }

    public String getValue() {
        return this.value;
    }

    @Nonnull
    public List<AutoTextPlaceholderEntry> getEntries() {
        return this.entries == null ? new ArrayList<AutoTextPlaceholderEntry>() : this.entries;
    }
}

