/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandFactory;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.MSSQLAddColumnCommand;
import com.inet.dbupdater.databases.commands.MSSQLAddPrimaryCommand;
import com.inet.dbupdater.databases.commands.MSSQLAlterColumnCommand;
import com.inet.dbupdater.databases.commands.MSSQLAlterDropCommand;
import com.inet.dbupdater.databases.commands.MSSQLAlterIndexCommand;
import com.inet.dbupdater.databases.commands.MSSQLAlterPrimaryCommand;
import com.inet.dbupdater.databases.commands.MSSQLCommandSyntax;
import com.inet.dbupdater.databases.commands.MSSQLCreateDatabaseCommand;
import com.inet.dbupdater.databases.commands.MSSQLCreateFunctionCommand;
import com.inet.dbupdater.databases.commands.MSSQLCreateIndexCommand;
import com.inet.dbupdater.databases.commands.MSSQLCreatePrimaryIndexCommand;
import com.inet.dbupdater.databases.commands.MSSQLCreateProcedureCommand;
import com.inet.dbupdater.databases.commands.MSSQLCreateTriggerCommand;
import com.inet.dbupdater.databases.commands.MSSQLCreateViewCommand;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;

public class MSSQLCommandFactory
extends DefaultCommandFactory {
    private DatabaseInfos dbInfo;

    public MSSQLCommandFactory(DatabaseInfos dbInfo) {
        super(dbInfo);
        this.dbInfo = dbInfo;
        this.setSyntax(new MSSQLCommandSyntax(dbInfo));
    }

    @Override
    public IComposedCommand getCommand(ICommandFactory.COMMAND_TYPE action, NodeFactory.TAG type, IDatabaseCommand.TIME purpose, Node containerNode, String name) {
        if (action == ICommandFactory.COMMAND_TYPE.create) {
            if (type == NodeFactory.TAG.trigger) {
                return new MSSQLCreateTriggerCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.view) {
                return new MSSQLCreateViewCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.function) {
                return new MSSQLCreateFunctionCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.procedure) {
                return new MSSQLCreateProcedureCommand(this.dbInfo);
            }
            if (type == NodeFactory.TAG.database) {
                return new MSSQLCreateDatabaseCommand(this.dbInfo, containerNode);
            }
            if (type == NodeFactory.TAG.index) {
                if (name != null && name.equals("PRIMARY")) {
                    return new MSSQLCreatePrimaryIndexCommand(this.dbInfo);
                }
                return new MSSQLCreateIndexCommand(this.dbInfo, containerNode);
            }
        }
        if (action == ICommandFactory.COMMAND_TYPE.alter) {
            if (type == NodeFactory.TAG.column) {
                if (purpose == IDatabaseCommand.TIME.addstructure) {
                    return new MSSQLAddColumnCommand(this.dbInfo, this.getSyntax(), containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.alterstructure) {
                    return new MSSQLAlterColumnCommand(this.dbInfo, this.getSyntax(), containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.dropstructure) {
                    return new MSSQLAlterDropCommand(this.dbInfo, this.getSyntax(), containerNode);
                }
            }
            if (type == NodeFactory.TAG.reference && (purpose == IDatabaseCommand.TIME.dropstructure || purpose == IDatabaseCommand.TIME.dropreferences)) {
                return new MSSQLAlterDropCommand(this.dbInfo, this.getSyntax(), containerNode);
            }
            if (type == NodeFactory.TAG.index) {
                if ((purpose == IDatabaseCommand.TIME.addreferences || purpose == IDatabaseCommand.TIME.addstructure) && name != null && name.equals("PRIMARY")) {
                    return new MSSQLAddPrimaryCommand(this.dbInfo, containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.alterstructure || purpose == IDatabaseCommand.TIME.alterreferences) {
                    if (name != null && name.equals("PRIMARY")) {
                        return new MSSQLAlterPrimaryCommand(this.dbInfo, this.getSyntax(), containerNode);
                    }
                    return new MSSQLAlterIndexCommand(this.dbInfo, this.getSyntax(), containerNode);
                }
                if (purpose == IDatabaseCommand.TIME.dropstructure || purpose == IDatabaseCommand.TIME.dropreferences) {
                    return new MSSQLAlterDropCommand(this.dbInfo, this.getSyntax(), containerNode);
                }
            }
        }
        return super.getCommand(action, type, purpose, containerNode, name);
    }
}

