/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.trigger;

import com.inet.helpdesk.core.HDLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import srv.automatic.trigger.Trigger;

public class TriggerHandler {
    private static final List<String[]> TRIGGER_FIELDS = new ArrayList<String[]>();
    public static final int MAIL_NEW_IN_TRIGGER = 0;
    public static final int MAIL_IN_TRIGGER = 1;
    public static final int MAIL_OUT_TRIGGER = 2;
    public static final int STATUS_CHANGE_TRIGGER = 3;
    public static final int NEW_USER_TICKET_TRIGGER = 4;
    public static final int ITIL_CHANGE_TRIGGER = 5;
    private static Trigger[] allTriggers;

    public String[] readTriggers(Map<String, String> triggers) {
        return this.readTriggers(triggers, false);
    }

    public String[] readTriggers(Map<String, String> triggers, boolean validationTest) {
        for (int i = 0; i < allTriggers.length; ++i) {
            TriggerHandler.allTriggers[i] = null;
        }
        int count = 0;
        ArrayList<Object> result = new ArrayList<Object>();
        for (String key : triggers.keySet()) {
            Integer keyValue = this.keyValueForTriggerKeyName(key);
            if (keyValue == null) {
                HDLogger.info("Trigger invalid key: " + key + " - " + triggers.get(key));
                result.add(key);
                continue;
            }
            String content = triggers.get(key);
            if (content == null || content.length() <= 0) continue;
            ++count;
            Trigger trig = new Trigger(content, keyValue);
            if (trig.isValid()) {
                if (validationTest) {
                    Hashtable<String, String> table = new Hashtable<String, String>();
                    table.put("typdescription", "test");
                    for (String scriptKey : TRIGGER_FIELDS.get(keyValue)) {
                        table.put(scriptKey, "");
                    }
                    Exception ex = trig.checkData(table, false);
                    if (ex != null) {
                        result.add(key + " " + ex.getMessage());
                        HDLogger.debug(ex);
                        continue;
                    }
                    TriggerHandler.allTriggers[keyValue.intValue()] = trig;
                    continue;
                }
                TriggerHandler.allTriggers[keyValue.intValue()] = trig;
                continue;
            }
            result.add(key + " " + String.valueOf(trig.getProblem()));
        }
        return result.toArray(new String[result.size()]);
    }

    private Integer keyValueForTriggerKeyName(String triggerKey) {
        return (Integer)new HashMap<String, Integer>(){
            {
                this.put("MAIL_NEW_IN", 0);
                this.put("MAIL_IN", 1);
                this.put("MAIL_OUT", 2);
                this.put("STATUS_CHANGE", 3);
                this.put("NEW_USER_TICKET", 4);
                this.put("ITIL_CHANGE", 5);
            }
        }.get(triggerKey);
    }

    public static Trigger getTrigger(int type) {
        return allTriggers[type];
    }

    static {
        TRIGGER_FIELDS.add(new String[]{"auftrag", "betreff", "derbetreff", "emaileingang", "newuser", "priid", "resbezeichnung", "sender", "subject"});
        TRIGGER_FIELDS.add(new String[]{"abteilung", "auftrag", "auftragfrei1", "auftragfrei2", "auftragfrei3", "auftragfrei4", "auftragfrei5", "auftragfrei6", "auftragfrei7", "benutzerfrei1", "benutzerfrei2", "benutzerfrei3", "benutzerfrei4", "benutzerfrei5", "betreff", "computername", "current_status", "derbetreff", "emaileingang", "gebbezeichnung", "itilbezeichnung", "klassifizierung", "kostenstelle", "letzterbearbeiter", "locale", "nachname", "priid", "resanwesend", "resbezeichnung", "sender", "status", "statusbezeichnung", "subject", "telefon", "useremail", "username", "vorname", "zimmer"});
        TRIGGER_FIELDS.add(new String[]{"abteilung", "adresse", "anfragedatum", "anfragedatumgmt", "aufid", "aufidxxx", "auftrag", "auftragfrei1", "auftragfrei2", "auftragfrei3", "auftragfrei4", "auftragfrei5", "auftragfrei6", "auftragfrei7", "bearbeitungsdatum", "benutzerfrei1", "benutzerfrei2", "benutzerfrei3", "benutzerfrei4", "benutzerfrei5", "benutzerklasse", "betreff", "computername", "date", "deadlinezeit", "derbetreff", "dispatcher", "dispatcherusr", "email", "e-mail absender", "e-mail bcc", "e-mail cc", "e-mail disp", "e-mail empfaenger", "emaileingang", "firma", "gebbezeichnung", "info", "itilbezeichnung", "kennung", "klassifizierung", "klassifizierunginfo", "kostenstelle", "letzterbearbeiter", "locale", "logo", "mailtodispatcher", "nachname", "name absender", "pribezeichnung", "priid", "producer", "resanwesend", "resbezeichnung", "resmsgtext", "sendattachments", "status", "statusbezeichnung", "subtemplatesortorder", "telefon", "templatename", "time", "totyp", "useremail", "username", "vorname", "wvzeit", "zimmer"});
        TRIGGER_FIELDS.add(new String[]{"aufid", "benutzerklasse", "betreff", "e-mail empfaenger", "itilbezeichnung", "klassifizierung", "parent_resbezeichnung", "priid", "pribezeichnung", "stepproducer", "resbezeichnung", "sprid", "status", "useremail", "username"});
        TRIGGER_FIELDS.add(new String[]{"auftrag", "betreff", "derbetreff", "bunfeld1", "bunfeld2", "bunfeld3", "bunfeld4", "bunfeld5", "computername", "frei1", "frei2", "frei3", "frei4", "frei5", "itiid", "klaid", "kostenstelle", "nachname", "resid", "priid", "spezFeld", "telefon", "email", "username", "vorname", "zimmer"});
        TRIGGER_FIELDS.add(new String[]{"aufid", "benutzerklasse", "betreff", "e-mail empfaenger", "itilbezeichnung", "klassifizierung", "parent_resbezeichnung", "priid", "pribezeichnung", "stepproducer", "resbezeichnung", "sprid", "status", "useremail", "username"});
        allTriggers = new Trigger[6];
    }
}

