/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.helpdesk.config.FieldMapping;
import com.inet.helpdesk.config.FieldMappingEntry;
import com.inet.logging.LogManager;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import javax.annotation.Nonnull;

public class ImportUtilities {
    public static String validateValues(FieldMappingEntry fm, String value) throws AddressException {
        if (value == null) {
            return "";
        }
        value = ImportUtilities.replaceNonDisplayableCharacters(fm, value);
        if ("Email".equals(fm.getDefininitionColumn())) {
            value = ImportUtilities.validateMailAdresses(value, FieldMapping.getColumnSize(fm.getDefininitionColumn()));
        } else if (FieldMapping.getColumnSize(fm.getDefininitionColumn()) > -1 && value.length() > FieldMapping.getColumnSize(fm.getDefininitionColumn())) {
            LogManager.getLogger((String)"Data Import").error((Object)(fm.getDefininitionColumn() + " -" + value + "- wird gek\u00fcrzt!"));
            value = value.substring(0, FieldMapping.getColumnSize(fm.getDefininitionColumn()));
        }
        return value;
    }

    private static String replaceNonDisplayableCharacters(FieldMappingEntry fm, @Nonnull String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) >= ' ') continue;
            char[] chars = str.toCharArray();
            for (int n = i; n < chars.length; ++n) {
                if (str.charAt(n) >= ' ' || str.charAt(n) == '\n' && "Frei6".equals(fm.getDefininitionColumn())) continue;
                chars[n] = 32;
            }
            return new String(chars).trim();
        }
        return str;
    }

    private static String validateMailAdresses(String addresses, int size) throws AddressException {
        if (addresses.length() > 0) {
            String[] mails;
            StringBuilder buf = new StringBuilder();
            for (String mailAdr : mails = addresses.split(";|,|\\s")) {
                if (mailAdr.length() <= 0) continue;
                ImportUtilities.checkEmailReceivers(mailAdr);
                if (buf.length() > 0) {
                    if (buf.length() + 1 + mailAdr.length() >= size) continue;
                    buf.append(';').append(mailAdr);
                    continue;
                }
                if (mailAdr.length() >= size) continue;
                buf.append(mailAdr);
            }
            return buf.toString();
        }
        return addresses;
    }

    static void checkEmailReceivers(String emailaddresses) throws AddressException {
        String[] mails = emailaddresses.split(";");
        if (mails != null && mails.length > 0) {
            for (String mail : mails) {
                if ((mail = mail.trim()).length() <= 0) continue;
                try {
                    new InternetAddress(mail, true);
                    int index = mail.indexOf(64);
                    if (index > 0) {
                        if ((index = mail.indexOf(46, index)) != -1) continue;
                        throw new AddressException(mail);
                    }
                    throw new AddressException(mail);
                }
                catch (AddressException ae) {
                    throw new AddressException(mail);
                }
            }
        }
    }
}

