/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.ExtensionUtils;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import srv.controller.ticket.timeline.ResourceTimelineManager;

public class EscalateOrAuthorizeTicketActionExtensionFactory
implements TicketActionExtensionFactory {
    @Override
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        ExtensionArguments.ResourceActionExtensionData extData = arguments.get(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA);
        int actionID = action.getId();
        if (actionID == 8 || actionID == 6 || action.getStatusID() == 101) {
            this.validateEscalation(extData, ticket.createIntermediateTicketVO());
            return new EscalateTicketActionExtension(extData);
        }
        if (actionID == 5) {
            this.validateAuthorization(extData, ticket.createIntermediateTicketVO());
            return new AuthorizeTicketActionExtension(extData);
        }
        return null;
    }

    private void validateEscalation(ExtensionArguments.ResourceActionExtensionData extData, TicketVO ticket) {
        if (extData == null) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.noResourceSpecified", new Object[0]));
        }
        GUID targetResID = extData.getTargetResID();
        UserGroupInfo targetResource = UserGroupManager.getInstance().getGroup(targetResID);
        if (targetResource == null) {
            throw new IllegalStateException(Tickets.MSG.getMsg("error.resourceNotExists", new Object[]{targetResID}));
        }
        if (targetResID.equals((Object)ticket.getResourceID())) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.resourceAlreadySpecified", new Object[]{targetResource.getDisplayName()}));
        }
    }

    private void validateAuthorization(ExtensionArguments.ResourceActionExtensionData extData, TicketVO ticket) {
        if (ticket.getResourceID() == null) {
            if (extData == null) {
                throw new IllegalArgumentException(Tickets.MSG.getMsg("error.noResourceSpecified", new Object[0]));
            }
            GUID targetResID = extData.getTargetResID();
            if (UserGroupManager.getInstance().getGroup(targetResID) == null) {
                throw new IllegalStateException(Tickets.MSG.getMsg("error.resourceNotExists", new Object[]{targetResID}));
            }
        }
    }

    @Override
    public TicketActionExtensionFactory.ActionTransformation transformActionRequest(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments) {
        ExtensionArguments.ResourceActionExtensionData extData = arguments.get(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA);
        if (extData == null || extData.shouldChangeTicketStatus()) {
            return null;
        }
        return TicketActionExtensionFactory.ActionTransformation.of(action.copyActionWithChangedStatus(-100), arguments);
    }

    @Override
    public int getExecutionPriority() {
        return 43;
    }

    public static class EscalateTicketActionExtension
    implements TicketActionExtension {
        @Nullable
        private final ExtensionArguments.ResourceActionExtensionData extensionData;

        public EscalateTicketActionExtension(ExtensionArguments.ResourceActionExtensionData extData) {
            this.extensionData = extData;
        }

        @Override
        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            GUID targetResID = this.extensionData.getTargetResID();
            UserGroupInfo targetResource = UserGroupManager.getInstance().getGroup(targetResID);
            if (targetResource == null) {
                throw new IllegalStateException(String.format("Resource with ID \"%s\" does not exist.", targetResID));
            }
            GUID oldResID = ticket.getFieldValue(Tickets.FIELD_RESOURCE_GUID);
            String description = oldResID == null ? targetResource.getDisplayName() : ExtensionUtils.buildResourceChangeText(oldResID, targetResource.getID());
            ticket.getNewTicketData().put(Tickets.FIELD_RESOURCE_GUID, targetResID);
            reaStep.getFields().put(ReaStepVO.FIELD_DESC, description);
            this.escalateSlaveTicketsIfRequested(ticket.getParentModel(), targetResource);
            if (action.getId() == 6) {
                ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_AUTOESCALATED, true);
            }
        }

        private void escalateSlaveTicketsIfRequested(TicketOperationModel model, UserGroupInfo targetResource) {
            long lastChanged = System.currentTimeMillis();
            List<Integer> slaveTicketIDs = this.extensionData.getSlaveTicketIDs();
            for (int slaveID : slaveTicketIDs) {
                OperationChangedTicket slave = model.changeExistingTicket(slaveID);
                ExtensionUtils.escalateTicketSilently(slave, targetResource, lastChanged);
            }
        }
    }

    public static class AuthorizeTicketActionExtension
    implements TicketActionExtension {
        @Nullable
        private final ExtensionArguments.ResourceActionExtensionData args;

        public AuthorizeTicketActionExtension(ExtensionArguments.ResourceActionExtensionData args) {
            this.args = args;
        }

        @Override
        public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            GUID resourceOfTicketWillBe;
            if (this.args != null) {
                GUID targetResID;
                resourceOfTicketWillBe = targetResID = this.args.getTargetResID();
                UserGroupInfo targetResource = UserGroupManager.getInstance().getGroup(targetResID);
                if (targetResource == null) {
                    throw new IllegalStateException(String.format("Resource with ID \"%s\" does not exist.", targetResID));
                }
                ticket.getNewTicketData().put(Tickets.FIELD_RESOURCE_GUID, targetResID);
            } else {
                resourceOfTicketWillBe = ticket.getFieldValue(Tickets.FIELD_RESOURCE_GUID);
            }
            if (ticket.getFieldValue(Tickets.FIELD_DEADLINE) == null) {
                this.setDeadlineIfPossible(resourceOfTicketWillBe, ticket);
            }
            GUID oldResource = ticket.getOldTicket().map(oldTicket -> oldTicket.getValue(Tickets.FIELD_RESOURCE_GUID)).orElse(null);
            String description = ExtensionUtils.buildResourceChangeText(oldResource, resourceOfTicketWillBe);
            reaStep.getFields().put(ReaStepVO.FIELD_DESC, description);
        }

        private void setDeadlineIfPossible(GUID resourceId, OperationChangedTicket ticket) {
            Integer priorityId = ticket.getFieldValue(Tickets.FIELD_PRIORITY_ID);
            Date deadline = ResourceTimelineManager.getInstance().calcDeadline(HDUsersAndGroups.getResourceId(resourceId), priorityId);
            if (deadline != null) {
                ticket.getNewTicketData().put(Tickets.FIELD_DEADLINE, Long.valueOf(deadline.getTime()));
            }
        }
    }
}

