/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.category;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CategoryManager
extends GenericFieldsManager<CategoryVO> {
    private static final int CATEGORY_MAX_LENGTH = 49;
    private static CategoryManager manager = new CategoryManager();
    public static final ConfigValue<RESOURCE_TAKEOVER> RESOURCE_TAKEOVER_SETTING = new ConfigValue<RESOURCE_TAKEOVER>(HDConfigKeys.CATEGORY_RESOURCE_TAKEOVER){

        protected RESOURCE_TAKEOVER convert(@Nonnull String strValue) throws IllegalArgumentException {
            return RESOURCE_TAKEOVER.valueOf(strValue);
        }
    };

    private CategoryManager() {
        super(CategoryVO.class, "tblBetreffs");
    }

    public static CategoryManager getInstance() {
        return manager;
    }

    @Override
    public URL getIcon(int id, int size) {
        return this.resolveImageURL("kategorie_16.gif", size);
    }

    @Override
    protected void addDefaultData(Map<Integer, CategoryVO> map) {
        map.put(0, new CategoryVO(0, "", null, 0, false, false, null));
    }

    public CategoryVO getCategoryByPath(String path) {
        return this.getCategoryByPath(path, false);
    }

    public CategoryVO getCategoryByPath(String path, boolean validOnly) {
        if (path != null) {
            Optional<CategoryVO> first = this.getAll(true).stream().filter(cat -> cat.getPath().equals(path)).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
            if (!validOnly && (first = this.getAll(false).stream().filter(cat -> cat.getPath().equals(path)).findFirst()).isPresent()) {
                return first.get();
            }
        }
        HDLogger.warn("No Category can be found for path: " + path);
        return null;
    }

    public String findCategoryPathOrThrow(@Nullable Integer categoryID) throws ServerDataException {
        if (categoryID == null) {
            return "";
        }
        CategoryVO category = (CategoryVO)this.get(categoryID);
        if (category == null) {
            String msg = String.format("category with ID = \"%d\" does not exist", categoryID);
            throw new ServerDataException(new IllegalArgumentException(msg));
        }
        return category.getPath();
    }

    public Integer findOrCreateCategory(String categoryPath) throws SQLException {
        return this.findOrCreateCategory(categoryPath, false);
    }

    public Integer findOrCreateCategory(String categoryPath, boolean createAsDeleted) throws SQLException {
        return this.findOrCreateCategory(categoryPath, createAsDeleted, false);
    }

    public Integer findOrCreateCategory(String categoryPath, boolean createAsDeleted, boolean validOnly) throws SQLException {
        List<String> splittedCategoryPath = CategoryManager.splitIntoCategoryNames(categoryPath);
        if (splittedCategoryPath.isEmpty()) {
            return null;
        }
        Integer categoryID = null;
        String currentPath = "";
        for (String categoryName : splittedCategoryPath) {
            currentPath = currentPath.isEmpty() ? categoryName : currentPath + "\\" + categoryName;
            CategoryVO createdCategory = this.findOrCreateCategory(categoryName, currentPath, categoryID, createAsDeleted, validOnly);
            categoryID = createdCategory.getId();
        }
        return categoryID;
    }

    private CategoryVO findOrCreateCategory(String categoryName, String categoryPath, @Nullable Integer parentCategoryID, boolean createAsDeleted, boolean validOnly) throws SQLException {
        CategoryVO category = this.getCategoryByPath(categoryPath, validOnly);
        if (category != null) {
            return category;
        }
        parentCategoryID = parentCategoryID == null ? Integer.valueOf(0) : parentCategoryID;
        CategoryVO vo = new CategoryVO(-1, categoryName, parentCategoryID, 0, false, createAsDeleted, null);
        this.add(vo);
        return vo;
    }

    private static List<String> splitIntoCategoryNames(String value) {
        ArrayList<String> categoryNames = new ArrayList<String>();
        for (String token : value.split("\\\\")) {
            if (token.trim().isEmpty()) continue;
            if (token.length() > 49) {
                token = token.substring(0, 49);
            }
            categoryNames.add(token);
        }
        return categoryNames;
    }

    @Override
    protected void setDataFromResult(ResultSet rs, CategoryVO instance) throws SQLException, IllegalAccessException {
        super.setDataFromResult(rs, instance);
        instance.resetPath();
    }

    public Map<Integer, String> getAllPathNames(boolean onlyActiveEntries) {
        List all = CategoryManager.getInstance().getAll(onlyActiveEntries);
        return all.stream().collect(Collectors.toMap(c -> c.getId(), c -> c.getPath()));
    }

    @Override
    public CategoryVO remove(int id) throws SQLException {
        if (id == 0) {
            throw new IllegalArgumentException("cannot delete root category");
        }
        return (CategoryVO)super.remove(id);
    }

    @Override
    public int add(CategoryVO vo) throws SQLException {
        if (this.getCategoryByPath(vo.getPath(), true) != null) {
            throw new IllegalArgumentException("Not allowed to add a category whose path already exists elsewhere!");
        }
        return super.add(vo);
    }

    public static enum RESOURCE_TAKEOVER {
        never,
        newticketnotset,
        ondemand,
        askifnotempty,
        always;

    }
}

