/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketfieldsettings.fields;

import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeBoolean;
import com.inet.field.fieldtypes.FieldTypeCurrency;
import com.inet.field.fieldtypes.FieldTypeDate;
import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeInteger;
import com.inet.field.fieldtypes.FieldTypeRating;
import com.inet.field.fieldtypes.FieldTypeSelect;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.nature.CustomNature;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithField;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomTicketFieldDefinition<T>
extends AbstractTicketFieldDefinitionWithField<T> {
    private GenericFieldSetting settings;

    public CustomTicketFieldDefinition(@Nonnull TicketField<T> field, @Nonnull GenericFieldSetting settings) {
        super(field, true, false, settings.getSortPriority());
        this.settings = settings;
    }

    @Override
    @Nullable
    public FieldEditDefinition getEditDefinition() {
        if (this.getField().getFieldType() instanceof FieldTypeSelect) {
            return new Select_EditDefinition(this);
        }
        return new Standard_EditDefinition(this);
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return this.settings.getType();
    }

    @Override
    @Nonnull
    public Map<String, String> getProperties() {
        if (FieldSettingsType.TYPE_CURRENCY.equals((Object)this.settings.getType())) {
            return Map.of("symbol", FieldTypeCurrency.getCurrency().getSymbol());
        }
        return super.getProperties();
    }

    @Override
    public void setDefaultValue(@Nullable String value) {
        if (this.getField().getFieldType() instanceof FieldTypeBoolean && value != null && value.equalsIgnoreCase("true")) {
            value = "1";
        }
        super.setDefaultValue(value);
    }

    private final class Select_EditDefinition
    extends SelectEditDefinition {
        private Select_EditDefinition(TicketFieldDefinition definition) {
            super(definition);
        }

        @Override
        public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
            String value = values.get(this.getFieldKey());
            if (!StringFunctions.isEmpty((String)value)) {
                if (((CustomNature)CustomTicketFieldDefinition.this.settings.getNature()).getSelectOptionsMode() == 3) {
                    ticketData.put(CustomTicketFieldDefinition.this.getField(), CustomTicketFieldDefinition.this.getField().getFieldType().valueOf(value));
                } else {
                    SelectOption selectOption = (SelectOption)new Json().fromJson(value, SelectOption.class);
                    String valueString = selectOption.getValue();
                    ticketData.put(CustomTicketFieldDefinition.this.getField(), CustomTicketFieldDefinition.this.getField().getFieldType().valueOf(valueString));
                }
            } else {
                ticketData.put(CustomTicketFieldDefinition.this.getField(), null);
            }
        }

        @Override
        public void updateCurrentValue(@Nullable TicketVO ticket, @Nullable GUID ownerId, Map<String, String> values) {
            SelectOption option = new SelectOption(null, "");
            if (ticket != null) {
                Object value = ticket.getValue(CustomTicketFieldDefinition.this.getField());
                if (value != null) {
                    option = new SelectOption(CustomTicketFieldDefinition.this.getField().getFieldType().asString(value), CustomTicketFieldDefinition.this.getField().getFieldType().asString(value));
                }
            } else {
                SelectOptionResult selectOptions;
                Object defaultValue = CustomTicketFieldDefinition.this.getField().getDefaultValue();
                if (defaultValue != null && (selectOptions = this.getSelectOptions(null, CustomTicketFieldDefinition.this.getField().getFieldType().asString(defaultValue), 10, 0)).getOptions().stream().anyMatch(op -> Objects.equals(op.getValue(), defaultValue))) {
                    option = new SelectOption(CustomTicketFieldDefinition.this.getField().getFieldType().asString(defaultValue), CustomTicketFieldDefinition.this.getField().getFieldType().asString(defaultValue));
                }
            }
            if (((CustomNature)CustomTicketFieldDefinition.this.settings.getNature()).getSelectOptionsMode() == 3) {
                values.put(this.getFieldKey(), option.getValue());
            } else {
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }
        }

        @Override
        public String getFieldKey() {
            return CustomTicketFieldDefinition.this.getKey();
        }

        @Override
        public String getDisplayName() {
            return CustomTicketFieldDefinition.this.getDisplayName();
        }

        @Override
        public String getDisplayType() {
            switch (((CustomNature)CustomTicketFieldDefinition.this.settings.getNature()).getSelectOptionsMode()) {
                case 3: {
                    return "selectmultieditable";
                }
                case 2: {
                    return "selecteditable";
                }
            }
            return "select";
        }

        @Override
        public SelectOptionResult getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
            List list = CustomTicketFieldDefinition.this.settings.getSelectOptions(searchTerm);
            if (!StringFunctions.isEmpty((String)searchTerm) && ((CustomNature)CustomTicketFieldDefinition.this.settings.getNature()).getSelectOptionsMode() == 2) {
                list.add(0, new SelectOption(searchTerm, searchTerm));
            }
            List staticValuesWithData = ((CustomNature)CustomTicketFieldDefinition.this.settings.getNature()).getStaticValuesWithData();
            if (!HDUsersAndGroups.isSupporter()) {
                list.removeIf(option -> {
                    Optional<List> datarow = staticValuesWithData.stream().filter(data -> Objects.equals(data.get(0), option.getLabel())).findFirst();
                    return datarow.isPresent() && datarow.get().size() > 1 && Objects.equals(datarow.get().get(1), "selectOnlyForSupporter");
                });
            }
            if (list.size() < currentSize) {
                return new SelectOptionResult(0, new ArrayList());
            }
            List subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
            return new SelectOptionResult(list.size(), subList);
        }
    }

    private final class Standard_EditDefinition
    extends FieldEditDefinition {
        private Standard_EditDefinition(TicketFieldDefinition definition) {
            super(definition);
        }

        @Override
        public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
            String subject = values.get(this.getFieldKey());
            Object valueOf = CustomTicketFieldDefinition.this.getField().getFieldType() instanceof FieldTypeBoolean ? ("true".equalsIgnoreCase(subject) ? Boolean.TRUE : Boolean.FALSE) : CustomTicketFieldDefinition.this.getField().getFieldType().valueOf(subject);
            ticketData.put(CustomTicketFieldDefinition.this.getField(), valueOf);
        }

        @Override
        public void updateCurrentValue(@Nullable TicketVO ticket, @Nullable GUID ownerId, Map<String, String> values) {
            Object subject = ticket != null ? ticket.getFieldOrAttributeValue(CustomTicketFieldDefinition.this.getField()) : CustomTicketFieldDefinition.this.getField().getDefaultValue();
            String asString = CustomTicketFieldDefinition.this.getField().getFieldType().asString(subject);
            if (CustomTicketFieldDefinition.this.getField().getFieldType() instanceof FieldTypeBoolean) {
                asString = subject != null && (Boolean)subject != false ? "true" : "false";
            }
            values.put(this.getFieldKey(), asString);
        }

        @Override
        public String getFieldKey() {
            return CustomTicketFieldDefinition.this.getKey();
        }

        @Override
        public String getDisplayType() {
            FieldType fieldType = CustomTicketFieldDefinition.this.getField().getFieldType();
            if (fieldType instanceof FieldTypeBoolean) {
                return "boolean";
            }
            if (fieldType instanceof FieldTypeDate) {
                if (((FieldTypeDate)fieldType).isDateWithTime()) {
                    return "datevalue";
                }
                return "dateonlyvalue";
            }
            if (fieldType instanceof FieldTypeTime) {
                return "timeonlyvalue";
            }
            if (fieldType instanceof FieldTypeCurrency) {
                return "currency";
            }
            if (fieldType instanceof FieldTypeDouble) {
                return "double";
            }
            if (fieldType instanceof FieldTypeInteger) {
                return "integer";
            }
            if (fieldType instanceof FieldTypeRating) {
                return "rating";
            }
            if (fieldType instanceof FieldTypeString && CustomTicketFieldDefinition.this.settings.getType() == FieldSettingsType.TYPE_MULTILINE_TEXT) {
                return "textarea";
            }
            return "textinput";
        }

        @Override
        public String getDisplayName() {
            return CustomTicketFieldDefinition.this.getDisplayName();
        }
    }
}

